/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.validation;

import com.gface.date.DatePickerCombo;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyFormatBase;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationDateFormat;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ValidationUtils {
    public static void validate(boolean condition, String label, String message) {
        if (!condition) {
            throw new ValidationException(ValidationUtils.format(message, label));
        }
    }

    public static void validate(boolean condition, String label, String value, String message) {
        if (!condition) {
            throw new ValidationException(ValidationUtils.format(message, label, value));
        }
    }

    public static void validate(Text control, String label, VerifyFormatBase validator, String message) {
        if (!validator.verifyText(control.getText())) {
            throw new ValidationException(ValidationUtils.format(message, label, control.getText()));
        }
    }

    public static void validate(Combo control, String label, String message) {
        if (control.getItemCount() == 0) {
            throw new ValidationException(ValidationUtils.format(message, label));
        }
    }

    public static void validate(DatePickerCombo control, String label, String message) {
        if (StringUtils.isEmpty((String)control.getText()) || control.getDate() == null) {
            throw new ValidationException(ValidationUtils.format(message, label, control.getText()));
        }
    }

    public static void validate(DatePickerCombo control, Date left, Date right, String message) {
        if (control.getDate().before(left) || control.getDate().after(right)) {
            throw new ValidationException(ValidationUtils.formatDates(message, SimulationDateFormat.getInteractiveDateFormatInstance().format(left), SimulationDateFormat.getInteractiveDateFormatInstance().format(right)));
        }
    }

    public static String format(String message, String label) {
        return MessageFormat.format(message, ValidationUtils.replaceMnemonics(label));
    }

    public static String format(String message, String label, String value) {
        return MessageFormat.format(message, ValidationUtils.replaceMnemonics(label), ValidationUtils.quote(value));
    }

    public static String formatDates(String message, Object arg1, Object arg2) {
        return MessageFormat.format(message, arg1, arg2);
    }

    public static String replaceMnemonics(String string) {
        return string != null ? string.replaceAll("\\&\\&", "_SAVE_AND_OP_").replaceAll("\\&", "").replaceAll(":$", "").replaceAll("_SAVE_AND_OP_", "\\&") : null;
    }

    public static String quote(String value) {
        return StringUtils.isEmpty((String)value) ? Simulation_Modeling_Messages.EMPTY_STRING : "\"" + value + "\"";
    }

    public static class ValidationException
    extends RuntimeException {
        public ValidationException(String message) {
            super(message);
        }
    }
}

