/*******************************************************************************
 * Copyright (c) 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class AbstractDelegate implements IDelegate
{
   /* Extension point ID */
   protected static final String PORTAL_DELEGATES_ID = "org.eclipse.stardust.ide.wst.facet.portal.portalDelegates"; //$NON-NLS-1$
   
   /* IDs for elements regarding the extension point */
   public static final String INSTALL_DELEGATE_ELEM_ID = "installDelegate"; //$NON-NLS-1$
   public static final String UNINSTALL_DELEGATE_ELEM_ID = "uninstallDelegate"; //$NON-NLS-1$
   public static final String VERSION_CHANGE_DELEGATE_ELEM_ID = "versionChangeDelegate"; //$NON-NLS-1$
   
   /* Attribute names */
   public static final String CLASS_ATTR_ID = "class"; //$NON-NLS-1$
   

   protected void invokeDelegateExtensions(String delegateConfiguration,
         IProject project, IProjectFacetVersion fv, Object config,
         IProgressMonitor monitor)
   {
      IConfigurationElement[] configElems = RegistryFactory.getRegistry()
            .getConfigurationElementsFor(PORTAL_DELEGATES_ID);
      for (IConfigurationElement e : configElems)
      {
         Object o = null;
         if (delegateConfiguration.equals(e.getName()))
         {
            try
            {
               o = e.createExecutableExtension(CLASS_ATTR_ID);
               if (o instanceof IDelegate)
               {
                  ((IDelegate) o).execute(project, fv, config, monitor);
               }
            }
            catch (CoreException ce)
            {
               ce.printStackTrace();
            }
         }
      }
   }

}
