/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.audittrail.ui;

import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.modeling.audittrail.AuditTrailDbManager;
import org.eclipse.stardust.modeling.audittrail.AuditTrailManagementException;
import org.eclipse.stardust.modeling.audittrail.ui.AuditTrailUtils;
import org.eclipse.stardust.modeling.audittrail.ui.Audittrail_UI_Messages;
import org.eclipse.stardust.modeling.audittrail.ui.DbLocationLabelProvider;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AuditTrailPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer vwDbs;

    public AuditTrailPreferencePage() {
    }

    public AuditTrailPreferencePage(String title) {
        super(title);
    }

    public AuditTrailPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite page = FormBuilder.createComposite((Composite)parent, (int)3);
        FormBuilder.createLabel((Composite)page, (String)Audittrail_UI_Messages.LBL_DERBY_AUDITTRAIL_DBS, (int)3);
        this.vwDbs = new ListViewer(FormBuilder.createList((Composite)page, (int)2));
        GridData gd = (GridData)this.vwDbs.getList().getLayoutData();
        gd.verticalSpan = 5;
        FormBuilder.createButton((Composite)page, (String)Audittrail_UI_Messages.BUT_NEW, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditTrailPreferencePage.this.createNewDb();
            }
        });
        final Button btnReset = FormBuilder.createButton((Composite)page, (String)Audittrail_UI_Messages.BUT_RESET, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditTrailPreferencePage.this.resetDb(AuditTrailPreferencePage.this.getSelectedDb(AuditTrailPreferencePage.this.vwDbs));
            }
        });
        final Button btnDelete = FormBuilder.createButton((Composite)page, (String)Audittrail_UI_Messages.BUT_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditTrailPreferencePage.this.deleteDb(AuditTrailPreferencePage.this.getSelectedDb(AuditTrailPreferencePage.this.vwDbs));
            }
        });
        this.vwDbs.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IFolder dbFolder = AuditTrailPreferencePage.this.getSelectedDb(AuditTrailPreferencePage.this.vwDbs);
                btnReset.setEnabled(dbFolder != null);
                btnDelete.setEnabled(dbFolder != null);
            }
        });
        this.vwDbs.setLabelProvider((IBaseLabelProvider)new DbLocationLabelProvider());
        this.vwDbs.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vwDbs.setInput((Object)AuditTrailDbManager.listDbs());
        this.vwDbs.setSelection((ISelection)StructuredSelection.EMPTY);
        return page;
    }

    public void init(IWorkbench workbench) {
    }

    public void createNewDb() {
        IFolder newDb = AuditTrailUtils.createNewDb(this.vwDbs.getList().getShell());
        if (newDb != null) {
            this.vwDbs.setInput((Object)AuditTrailDbManager.listDbs());
            this.vwDbs.setSelection((ISelection)new StructuredSelection((Object)newDb), true);
        }
    }

    private void resetDb(IFolder dbFolder) {
        try {
            AuditTrailDbManager.resetDb((String)dbFolder.getFullPath().lastSegment());
        }
        catch (AuditTrailManagementException atme) {
            MessageDialog.openError((Shell)this.getShell(), (String)Audittrail_UI_Messages.MSG_ERR_FAILED_RESETTING_AUDITTRAIL_DB, (String)atme.getMessage());
        }
        this.vwDbs.setInput((Object)AuditTrailDbManager.listDbs());
        this.vwDbs.setSelection((ISelection)new StructuredSelection((Object)dbFolder), true);
    }

    private void deleteDb(IFolder dbFolder) {
        try {
            AuditTrailDbManager.deleteDb((String)dbFolder.getFullPath().lastSegment());
        }
        catch (AuditTrailManagementException atme) {
            MessageDialog.openError((Shell)this.getShell(), (String)Audittrail_UI_Messages.MSG_ERR_FAILED_RESETTING_AUDITTRAIL_DB, (String)atme.getMessage());
        }
        this.vwDbs.setInput((Object)AuditTrailDbManager.listDbs());
        this.vwDbs.setSelection((ISelection)new StructuredSelection((Object)dbFolder), true);
    }

    private IFolder getSelectedDb(ListViewer vwDbs) {
        IFolder dbFolder = null;
        ISelection sel = vwDbs.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)sel).getFirstElement();
            dbFolder = (IFolder)element;
        }
        return dbFolder;
    }
}

