/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.databinding;

import org.eclipse.stardust.modeling.common.ui.jface.databinding.AbstractWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public abstract class SwtWidgetAdapter
extends AbstractWidgetAdapter {
    private final Widget widget;
    private DisposeListener disposer;

    public SwtWidgetAdapter(Widget widget) {
        this.widget = widget;
    }

    public abstract void updateControl(Object var1);

    public Widget getWidget() {
        return this.widget;
    }

    @Override
    public void bind(IBindingMediator manager) {
        super.bind(manager);
        this.disposer = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtWidgetAdapter.this.unbind();
            }
        };
        this.widget.addDisposeListener(this.disposer);
    }

    @Override
    public void unbind() {
        if (this.disposer != null) {
            if (!this.widget.isDisposed()) {
                this.widget.removeDisposeListener(this.disposer);
            }
            this.disposer = null;
        }
        super.unbind();
    }

    @Override
    public void updateVisuals(Object value) {
        if (!this.widget.isDisposed()) {
            this.updateControl(value);
        }
    }
}

