/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.utils;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;

public class TableEditorTraverseManager
implements TraverseListener {
    public static final int NONE = -1;
    public static final int NEXT_ROW = -2;
    public static final int PREVIOUS_ROW = -3;
    private StructuredViewer viewer;
    private int nextColumn;
    private int previousColumn;
    private int firstColumn;
    private int lastColumn;

    public TableEditorTraverseManager(TreeViewer treeViewer, int previousColumn, int nextColumn, int firstColumn, int lastColumn) {
        this.viewer = treeViewer;
        this.nextColumn = nextColumn;
        this.previousColumn = previousColumn;
        this.firstColumn = firstColumn;
        this.lastColumn = lastColumn;
    }

    public TableEditorTraverseManager(TableViewer tableViewer, int previousColumn, int nextColumn, int firstColumn, int lastColumn) {
        this.viewer = tableViewer;
        this.nextColumn = nextColumn;
        this.previousColumn = previousColumn;
        this.firstColumn = firstColumn;
        this.lastColumn = lastColumn;
    }

    public void keyTraversed(TraverseEvent e) {
        Object selection;
        if (e.detail == 16 && this.nextColumn != -1) {
            Object selection2 = this.getSelection(this.nextColumn);
            if (selection2 != null) {
                e.doit = false;
                if (this.viewer instanceof TreeViewer) {
                    ((TreeViewer)this.viewer).editElement(selection2, this.nextColumn == -2 ? this.firstColumn : this.nextColumn);
                } else if (this.viewer instanceof TableViewer) {
                    ((TableViewer)this.viewer).editElement(selection2, this.nextColumn == -2 ? this.firstColumn : this.nextColumn);
                }
            }
        } else if (e.detail == 8 && this.previousColumn != -1 && (selection = this.getSelection(this.previousColumn)) != null) {
            e.doit = false;
            if (this.viewer instanceof TreeViewer) {
                ((TreeViewer)this.viewer).editElement(selection, this.previousColumn == -3 ? this.lastColumn : this.previousColumn);
            } else if (this.viewer instanceof TableViewer) {
                ((TableViewer)this.viewer).editElement(selection, this.previousColumn == -3 ? this.lastColumn : this.previousColumn);
            }
        }
    }

    private Object getSelection(int column) {
        Object selection = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        switch (column) {
            case -1: {
                selection = null;
                break;
            }
            case -2: {
                selection = this.getNextElement(selection);
                break;
            }
            case -3: {
                selection = this.getPreviousElement(selection);
            }
        }
        return selection;
    }

    public Object getPreviousElement(Object selection) {
        return null;
    }

    public Object getNextElement(Object selection) {
        return null;
    }
}

