/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TextSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditorOutlinePage;
import org.eclipse.stardust.modeling.core.editors.IValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SearchAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowPropertiesAction;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.WorkflowModelTreeEditPartFactory;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class WorkflowModelOutlinePage
extends AbstractMultiPageGraphicalEditorOutlinePage
implements IValidationEventListener {
    public WorkflowModelOutlinePage(WorkflowModelEditor editor) {
        super(editor, (EditPartViewer)new TreeViewer());
    }

    @Override
    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    @Override
    protected EditPartFactory createOutlineEditPartFactory() {
        return new WorkflowModelTreeEditPartFactory((WorkflowModelEditor)this.getEditor());
    }

    @Override
    protected void contributeToolBarActions(IToolBarManager tbm) {
        IAction searchAction = this.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.core.search");
        tbm.add(searchAction);
    }

    @Override
    protected void createActions() {
        ShowPropertiesAction propDlgAction = new ShowPropertiesAction((WorkflowModelEditor)this.getEditor(), this.getSite().getSelectionProvider());
        propDlgAction.setId(ActionFactory.PROPERTIES.getId());
        this.getActionRegistry().registerAction((IAction)propDlgAction);
        SearchAction searchAction = new SearchAction((IWorkbenchPart)this.getEditor());
        this.getActionRegistry().registerAction((IAction)searchAction);
    }

    protected EditPartViewer getViewer() {
        return super.getViewer();
    }

    @Override
    public void onIssuesUpdated(EObject element, IValidationStatus validationStatus) {
        Object editPart = this.getViewer().getEditPartRegistry().get(element);
        if (editPart instanceof AbstractEObjectTreeEditPart) {
            boolean hasWarnings = !validationStatus.getWarnings().isEmpty() || !validationStatus.getChildrenWithWarnings().isEmpty();
            boolean hasErrors = !validationStatus.getErrors().isEmpty() || !validationStatus.getChildrenWithErrors().isEmpty();
            AbstractEObjectTreeEditPart treePart = (AbstractEObjectTreeEditPart)editPart;
            treePart.setState(hasErrors ? 2 : (hasWarnings ? 1 : 0));
        }
    }

    public void selectElement(EObject modelElement) {
        EditPart editPart = this.getEditPart(modelElement);
        if (editPart instanceof AbstractEObjectTreeEditPart) {
            this.selectEditPart(editPart);
        } else {
            editPart = this.getEditPart(modelElement.eContainer());
            if (editPart instanceof AbstractEObjectTreeEditPart) {
                this.selectEditPart(editPart);
            }
        }
    }

    public EditPart getEditPart(EObject modelElement) {
        return (EditPart)this.getViewer().getEditPartRegistry().get(modelElement);
    }

    private void selectEditPart(Object editPart) {
        this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(editPart));
        this.setFocus();
    }

    @Override
    protected boolean canDelete(ISelection selection) {
        Object selObj = null;
        if (selection instanceof IStructuredSelection && (selObj = ((IStructuredSelection)selection).getFirstElement()) instanceof EditPart) {
            boolean isNoEndEventSymbol;
            Object element = ((EditPart)selObj).getModel();
            boolean isTransition = !(element instanceof TransitionConnectionType) || ((TransitionConnectionType)element).getTransition() != null;
            boolean isNoGatewaySymbol = !(element instanceof GatewaySymbol);
            boolean isNoTextSymbol = !(element instanceof TextSymbolType);
            boolean isNoAnnotationSymbol = !(element instanceof AnnotationSymbolType);
            boolean isNoStartEventSymbol = !(element instanceof StartEventSymbol) || ((StartEventSymbol)element).getTrigger() != null;
            boolean bl = isNoEndEventSymbol = !(element instanceof EndEventSymbol);
            return isTransition && isNoGatewaySymbol && isNoTextSymbol && isNoAnnotationSymbol && isNoStartEventSymbol && isNoEndEventSymbol;
        }
        return false;
    }
}

