/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;

public class ConnectionUtils {
    public static List getTransitions(List activities) {
        ArrayList tmpTransitions = new ArrayList();
        ArrayList<TransitionType> transitions = new ArrayList<TransitionType>();
        for (ActivityType activity : activities) {
            tmpTransitions.addAll(activity.getInTransitions());
            tmpTransitions.addAll(activity.getOutTransitions());
        }
        if (!tmpTransitions.isEmpty()) {
            for (TransitionType transition : tmpTransitions) {
                if (!activities.contains(transition.getFrom()) && !activities.contains(transition.getTo()) || transitions.contains(transition)) continue;
                transitions.add(transition);
            }
        }
        return transitions;
    }

    public static void deleteTransitions(ActivityType activity, List transitionList) {
        ArrayList inTransitions = new ArrayList();
        inTransitions.addAll(activity.getInTransitions());
        if (!inTransitions.isEmpty()) {
            for (TransitionType transition : inTransitions) {
                if (transitionList != null && transitionList.contains(transition)) continue;
                transition.setFrom(null);
                transition.setTo(null);
                MergeUtils.deleteElement((EObject)transition, null);
            }
        }
        ArrayList outTransitions = new ArrayList();
        outTransitions.addAll(activity.getOutTransitions());
        if (!outTransitions.isEmpty()) {
            for (TransitionType transition : outTransitions) {
                if (transitionList != null && transitionList.contains(transition)) continue;
                transition.setFrom(null);
                transition.setTo(null);
                MergeUtils.deleteElement((EObject)transition, null);
            }
        }
    }

    public static void deleteConnectionsFromSymbol(INodeSymbol symbol, List connectionList) {
        ArrayList connectionFeatures = new ArrayList();
        connectionFeatures.addAll(symbol.getInConnectionFeatures());
        connectionFeatures.addAll(symbol.getOutConnectionFeatures());
        for (EStructuralFeature feature : connectionFeatures) {
            Object object = symbol.eGet(feature);
            if (object == null) continue;
            ConnectionUtils.removeConnection(object, connectionList);
        }
        ArrayList<EList> links = new ArrayList<EList>();
        if (!symbol.getInLinks().isEmpty()) {
            links.add(symbol.getInLinks());
        }
        if (!symbol.getOutLinks().isEmpty()) {
            links.add(symbol.getOutLinks());
        }
        for (Object e : links) {
            if (e == null) continue;
            ConnectionUtils.removeConnection(e, connectionList);
        }
        symbol.getInLinks().clear();
        symbol.getOutLinks().clear();
        symbol.getReferingFromConnections().clear();
        symbol.getReferingToConnections().clear();
    }

    private static void removeConnection(Object object, List connectionList) {
        if (object instanceof EObjectEList) {
            List data = ((EcoreEList)object).basicList();
            for (EObject eObject : data) {
                if (connectionList != null && connectionList.contains(eObject) || !(eObject instanceof IConnectionSymbol)) continue;
                ((IConnectionSymbol)eObject).setTargetNode(null);
                ((IConnectionSymbol)eObject).setSourceNode(null);
                MergeUtils.deleteElement((EObject)((IModelElement)eObject), null);
            }
        } else if (object instanceof EObject && (connectionList == null || !connectionList.contains(object)) && object instanceof IConnectionSymbol) {
            ((IConnectionSymbol)object).setTargetNode(null);
            ((IConnectionSymbol)object).setSourceNode(null);
            MergeUtils.deleteElement((EObject)((IModelElement)object), null);
        }
    }

    public static Object getInConnectionFromSymbol(INodeSymbol symbol, TransitionType transition) {
        IConnectionSymbol connection = null;
        ArrayList connectionFeatures = new ArrayList();
        connectionFeatures.addAll(symbol.getInConnectionFeatures());
        for (EStructuralFeature feature : connectionFeatures) {
            Object object = symbol.eGet(feature);
            if (object == null) continue;
            if (object instanceof EObjectEList) {
                List data = ((EcoreEList)object).basicList();
                for (EObject eObject : data) {
                    if (!(eObject instanceof TransitionConnectionType)) continue;
                    TransitionType inTransition = ((TransitionConnectionType)eObject).getTransition();
                    if ((transition != null || inTransition != null) && (transition == null || !transition.equals(inTransition))) continue;
                    INodeSymbol source = ((IConnectionSymbol)eObject).getSourceNode();
                    if (!(transition == null && source instanceof AbstractEventSymbol || transition != null && source instanceof ActivitySymbolType) && (transition == null || !(source instanceof GatewaySymbol))) continue;
                    if (connection == null) {
                        connection = (IConnectionSymbol)eObject;
                        continue;
                    }
                    return Boolean.FALSE;
                }
                continue;
            }
            if (!(object instanceof EObject) || !(object instanceof TransitionConnectionType)) continue;
            TransitionType inTransition = ((TransitionConnectionType)object).getTransition();
            if ((transition != null || inTransition != null) && (transition == null || !transition.equals(inTransition))) continue;
            INodeSymbol source = ((IConnectionSymbol)object).getSourceNode();
            if (!(transition == null && source instanceof AbstractEventSymbol || transition != null && source instanceof ActivitySymbolType) && (transition == null || !(source instanceof GatewaySymbol))) continue;
            if (connection == null) {
                connection = (IConnectionSymbol)object;
                continue;
            }
            return Boolean.FALSE;
        }
        return connection;
    }

    public static Object getOutConnectionFromSymbol(INodeSymbol symbol, TransitionType transition) {
        IConnectionSymbol connection = null;
        ArrayList connectionFeatures = new ArrayList();
        connectionFeatures.addAll(symbol.getOutConnectionFeatures());
        for (EStructuralFeature feature : connectionFeatures) {
            Object object = symbol.eGet(feature);
            if (object == null) continue;
            if (object instanceof EObjectEList) {
                List data = ((EcoreEList)object).basicList();
                for (EObject eObject : data) {
                    if (!(eObject instanceof TransitionConnectionType)) continue;
                    TransitionType inTransition = ((TransitionConnectionType)eObject).getTransition();
                    if ((transition != null || inTransition != null) && (transition == null || !transition.equals(inTransition))) continue;
                    INodeSymbol target = ((IConnectionSymbol)eObject).getTargetNode();
                    if (!(transition == null && target instanceof AbstractEventSymbol || transition != null && target instanceof ActivitySymbolType) && (transition == null || !(target instanceof GatewaySymbol))) continue;
                    if (connection == null) {
                        connection = (IConnectionSymbol)eObject;
                        continue;
                    }
                    return Boolean.FALSE;
                }
                continue;
            }
            if (!(object instanceof EObject) || !(object instanceof TransitionConnectionType)) continue;
            TransitionType inTransition = ((TransitionConnectionType)object).getTransition();
            if ((transition != null || inTransition != null) && (transition == null || !transition.equals(inTransition))) continue;
            INodeSymbol target = ((IConnectionSymbol)object).getTargetNode();
            if (!(transition == null && target instanceof AbstractEventSymbol || transition != null && target instanceof ActivitySymbolType) && (transition == null || !(target instanceof GatewaySymbol))) continue;
            if (connection == null) {
                connection = (IConnectionSymbol)object;
                continue;
            }
            return Boolean.FALSE;
        }
        return connection;
    }
}

