/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures.routers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.utils.TransitionConnectionUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class TransitionConnectionRouter
extends AbstractRouter {
    private Map constraints = new HashMap(11);
    private Map rowsUsed = new HashMap();
    private Map colsUsed = new HashMap();
    private Map reservedInfo = new HashMap();
    private static Ray UP = new Ray(0, -1);
    private static Ray DOWN = new Ray(0, 1);
    private static Ray LEFT = new Ray(-1, 0);
    private static Ray RIGHT = new Ray(1, 0);

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = new Integer(r + proximity * direction);
            if (!this.colsUsed.containsKey(i)) {
                this.colsUsed.put(i, i);
                this.reserveColumn(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 2;
        }
        return r;
    }

    protected Ray getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Ray direction = LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = UP;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = DOWN;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            distance = i;
            direction = RIGHT;
        }
        return direction;
    }

    protected Ray getEndDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getTargetAnchor();
        Point p = this.getEndPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getTargetAnchor().getOwner().getBounds().getCopy();
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)rect);
        }
        return this.getDirection(rect, p);
    }

    protected int getRowNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = new Integer(r + proximity * direction);
            if (!this.rowsUsed.containsKey(i)) {
                this.rowsUsed.put(i, i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 2;
        }
        return r;
    }

    protected Ray getStartDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getSourceAnchor();
        Point p = this.getStartPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getSourceAnchor().getOwner().getBounds().getCopy();
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)rect);
        }
        return this.getDirection(rect, p);
    }

    protected void processPositions(Ray start, Ray end, List positions, boolean horizontal, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontal ? start.x : start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = (Integer)positions.get(i);
            ++i;
        }
        pos[++i] = horizontal == (positions.size() % 2 == 1) ? end.x : end.y;
        PointList points = new PointList();
        points.addPoint(new Point(start.x, start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point p;
            int max;
            int min;
            boolean adjust;
            horizontal = !horizontal;
            int prev = pos[i - 1];
            int current = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontal) {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getRowNear(conn, current, min, max);
                }
                p = new Point(prev, current);
            } else {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getColumnNear(conn, current, min, max);
                }
                p = new Point(current, prev);
            }
            points.addPoint(p);
            ++i;
        }
        points.addPoint(new Point(end.x, end.y));
        if (this.isStraight(points)) {
            PointList fix = new PointList(2);
            fix.addPoint(points.getFirstPoint());
            fix.addPoint(points.getLastPoint());
            points = fix;
        }
        conn.setPoints(points);
    }

    private boolean isStraight(PointList points) {
        Point dummy = new Point();
        if (points.size() > 2) {
            points.getPoint(dummy, 0);
            int x = dummy.x;
            int y = dummy.y;
            boolean horizontal = true;
            boolean vertical = true;
            int i = 1;
            while (i < points.size() && (horizontal || vertical)) {
                points.getPoint(dummy, i);
                if (horizontal && x != dummy.x) {
                    horizontal = false;
                }
                if (vertical && y != dummy.y) {
                    vertical = false;
                }
                ++i;
            }
            return horizontal || vertical;
        }
        return false;
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
        this.constraints.remove(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = (ReservedInfo)this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        int i = 0;
        while (i < rInfo.reservedRows.size()) {
            this.rowsUsed.remove(rInfo.reservedRows.get(i));
            ++i;
        }
        i = 0;
        while (i < rInfo.reservedCols.size()) {
            this.colsUsed.remove(rInfo.reservedCols.get(i));
            ++i;
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = (ReservedInfo)this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedCols.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = (ReservedInfo)this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedRows.add(row);
    }

    public void route(Connection conn) {
        boolean horizontal;
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Ray start = new Ray(startPoint);
        Ray end = new Ray(endPoint);
        Ray average = start.getAveraged(end);
        Ray direction = new Ray(start, end);
        Ray startNormal = this.getStartDirection(conn);
        Ray endNormal = this.getEndDirection(conn);
        ArrayList<Integer> positions = new ArrayList<Integer>(5);
        boolean fixRouting = startNormal.equals((Object)endNormal);
        Ray realStart = start;
        Ray realEnd = end;
        boolean startHorizontally = startNormal.isHorizontal();
        if (fixRouting) {
            if (startNormal.isHorizontal()) {
                positions.add(new Integer(start.y));
                startPoint = new Point(start.x + startNormal.getScaled((int)25).x, start.y);
                endPoint = new Point(end.x + endNormal.getScaled((int)25).x, end.y);
                startNormal = start.y <= end.y ? DOWN : UP;
                endNormal = start.y <= end.y ? UP : DOWN;
            } else {
                positions.add(new Integer(start.x));
                startPoint = new Point(start.x, start.y + startNormal.getScaled((int)25).y);
                endPoint = new Point(end.x, end.y + endNormal.getScaled((int)25).y);
                startNormal = start.x <= end.x ? RIGHT : LEFT;
                endNormal = start.x <= end.x ? RIGHT : LEFT;
            }
            start = new Ray(startPoint);
            end = new Ray(endPoint);
            average = start.getAveraged(end);
            direction = new Ray(start, end);
        }
        if (horizontal = startNormal.isHorizontal()) {
            positions.add(new Integer(start.y));
        } else {
            positions.add(new Integer(start.x));
        }
        boolean bl = horizontal = !horizontal;
        if (startNormal.dotProduct(endNormal) == 0) {
            if (startNormal.dotProduct(direction) < 0 || endNormal.dotProduct(direction) > 0) {
                int i = startNormal.dotProduct(direction) < 0 ? startNormal.similarity(start.getAdded(startNormal.getScaled(25))) : (horizontal ? average.y : average.x);
                positions.add(new Integer(i));
                boolean bl2 = horizontal = !horizontal;
                i = endNormal.dotProduct(direction) > 0 ? endNormal.similarity(end.getAdded(endNormal.getScaled(25))) : (horizontal ? average.y : average.x);
                positions.add(new Integer(i));
                horizontal = !horizontal;
            }
        } else if (startNormal.dotProduct(endNormal) > 0) {
            int i = startNormal.dotProduct(direction) >= 0 ? startNormal.similarity(start.getAdded(startNormal.getScaled(25))) : endNormal.similarity(end.getAdded(endNormal.getScaled(25)));
            positions.add(new Integer(i));
            horizontal = !horizontal;
        } else {
            int i;
            if (startNormal.dotProduct(direction) < 0) {
                i = startNormal.similarity(start.getAdded(startNormal.getScaled(25)));
                positions.add(new Integer(i));
                horizontal = !horizontal;
            }
            i = horizontal ? average.y : average.x;
            positions.add(new Integer(i));
            boolean bl3 = horizontal = !horizontal;
            if (startNormal.dotProduct(direction) < 0) {
                i = endNormal.similarity(end.getAdded(endNormal.getScaled(25)));
                positions.add(new Integer(i));
                boolean bl4 = horizontal = !horizontal;
            }
        }
        if (horizontal) {
            positions.add(new Integer(end.y));
        } else {
            positions.add(new Integer(end.x));
        }
        if (fixRouting) {
            if (startHorizontally) {
                positions.add(new Integer(end.y));
            } else {
                positions.add(new Integer(end.x));
            }
        }
        List savePositions = (List)positions.clone();
        boolean isLoop = false;
        boolean[] gatewaysFlag = new boolean[1];
        Integer newPosition = null;
        boolean[] isVertical = new boolean[1];
        Point startPoint__ = new Point(start.x, start.y);
        Point endPoint__ = new Point(end.x, end.y);
        boolean bl5 = isLoop = positions.size() == 5 && positions.get(0).equals(positions.get(2)) && positions.get(2).equals(positions.get(4));
        if (isLoop) {
            TransitionConnectionUtils.orderPoints(isVertical, startPoint__, endPoint__);
            newPosition = TransitionConnectionUtils.getNewPosition(conn, isVertical, true, startPoint__, endPoint__);
            if (newPosition != null) {
                Integer value = new Integer(newPosition + 10);
                positions.clear();
                positions.add((Integer)savePositions.get(0));
                positions.add((Integer)savePositions.get(1));
                positions.add(value);
                positions.add((Integer)savePositions.get(3));
                positions.add((Integer)savePositions.get(4));
            }
        }
        WorkflowModelEditor editor = null;
        if (!isLoop) {
            try {
                IEditorPart editor_;
                IWorkbenchWindow workBenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workBenchWindow.getActivePage();
                if (page != null && (editor_ = page.getActiveEditor()) instanceof WorkflowModelEditor) {
                    editor = (WorkflowModelEditor)editor_;
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if ((!isLoop && editor != null && positions.size() == 5 || positions.size() == 4) && (newPosition = TransitionConnectionUtils.isTransitionWithGateways(conn, savePositions, startPoint__, endPoint__, isVertical, gatewaysFlag)) != null) {
            positions.clear();
            if (savePositions.size() == 4) {
                if (gatewaysFlag[0]) {
                    positions.add((Integer)savePositions.get(0));
                    positions.add(newPosition);
                    positions.add((Integer)savePositions.get(2));
                    positions.add((Integer)savePositions.get(3));
                } else {
                    positions.add((Integer)savePositions.get(0));
                    positions.add((Integer)savePositions.get(1));
                    positions.add(newPosition);
                    positions.add((Integer)savePositions.get(3));
                }
            } else if (savePositions.size() == 5) {
                positions.add((Integer)savePositions.get(0));
                positions.add(newPosition);
                positions.add((Integer)savePositions.get(2));
                positions.add(newPosition);
                positions.add((Integer)savePositions.get(4));
            }
        }
        this.processPositions(realStart, realEnd, positions, startHorizontally, conn);
    }

    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.constraints.put(connection, constraint);
    }

    public Point getStartConnectionPoint(Connection connection) {
        return this.getStartPoint(connection);
    }

    public Point getEndConnectionPoint(Connection connection) {
        return this.getEndPoint(connection);
    }

    private class ReservedInfo {
        public List reservedRows = new ArrayList(2);
        public List reservedCols = new ArrayList(2);

        private ReservedInfo() {
        }
    }
}

