/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.ui.IWorkbenchPart;

public class AlignmentSnapToGridAction
extends SelectionAction {
    private AlignmentAction alignmentAction;
    private final ISelectionProvider selectionProvider = new ISelectionProvider(){
        private ISelection selection;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }
    };
    private final int alignment;

    public AlignmentSnapToGridAction(IWorkbenchPart part, AlignmentAction alignmentAction, int alignment) {
        super(part);
        this.alignment = alignment;
        this.setId(alignmentAction.getId());
        this.setText(alignmentAction.getText());
        alignmentAction.setSelectionProvider(this.selectionProvider);
        this.alignmentAction = alignmentAction;
    }

    public boolean isEnabled() {
        this.selectionProvider.setSelection(this.getSelection());
        this.alignmentAction.update();
        return this.alignmentAction.isEnabled();
    }

    public void run() {
        final boolean isSnapToGrid = this.isSnapToGridEnabled();
        Command alignCmd = new Command(){

            public void execute() {
                AlignmentSnapToGridAction.this.alignmentAction.run();
                if (isSnapToGrid) {
                    AlignmentSnapToGridAction.this.getCommandStack().execute((Command)AlignmentSnapToGridAction.this.createSnapToGridCmd());
                }
            }

            public void undo() {
                AlignmentSnapToGridAction.this.getCommandStack().undo();
                if (isSnapToGrid) {
                    AlignmentSnapToGridAction.this.getCommandStack().undo();
                }
            }

            public void redo() {
                AlignmentSnapToGridAction.this.getCommandStack().redo();
                if (isSnapToGrid) {
                    AlignmentSnapToGridAction.this.getCommandStack().redo();
                }
            }
        };
        this.getCommandStack().execute(alignCmd);
    }

    protected boolean calculateEnabled() {
        this.selectionProvider.setSelection(this.getSelection());
        this.alignmentAction.update();
        return this.alignmentAction.isEnabled();
    }

    private boolean isSnapToGridEnabled() {
        return Boolean.TRUE.equals(((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGrid.isEnabled")) && (Boolean.FALSE.equals(((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGeometry.isEnabled")) || ((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGeometry.isEnabled") == null);
    }

    private CompoundCommand createSnapToGridCmd() {
        CompoundCommand command = new CompoundCommand();
        List editParts = this.getSelectedObjects();
        this.addSnapToClosestGridPointCmd(command, editParts);
        return command;
    }

    private void addSnapToClosestGridPointCmd(CompoundCommand command, List editParts) {
        if (16 == this.alignment || 2 == this.alignment) {
            for (AbstractNodeSymbolEditPart part : editParts) {
                INodeSymbol symbol = (INodeSymbol)part.getModel();
                Rectangle rect = new Rectangle(new Long(symbol.getXPos()).intValue(), new Long(symbol.getYPos()).intValue(), symbol.getWidth(), symbol.getHeight());
                PrecisionRectangle baseRect = new PrecisionRectangle(rect);
                PrecisionPoint preciseDelta = new PrecisionPoint(0, 0);
                SnapToHelper snapToHelper = (SnapToHelper)part.getParent().getAdapter(SnapToHelper.class);
                if (snapToHelper == null) continue;
                snapToHelper.snapPoint((Request)new AlignmentRequest(), 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
                this.addMoveNodeSymbolCmd(command, preciseDelta, symbol);
            }
        }
    }

    private void addMoveNodeSymbolCmd(CompoundCommand command, PrecisionPoint delta, INodeSymbol symbol) {
        MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
        moveCommand.setPart(symbol);
        moveCommand.setLocation(delta.getTranslated(new PrecisionRectangle(new Rectangle(new Long(symbol.getXPos()).intValue(), new Long(symbol.getYPos()).intValue(), symbol.getWidth(), symbol.getHeight())).getLocation()));
        command.add((Command)moveCommand);
    }
}

