/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateTypedModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.ui.IWorkbenchPart;

public class CreateDataAction
extends SelectionAction {
    private IConfigurationElement config;
    protected DataType data;

    public CreateDataAction(IConfigurationElement config, WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.config = config;
        if (config == null) {
            this.setId("org.eclipse.stardust.modeling.core.createGenericData");
            this.setText(Diagram_Messages.CreateDataAction_LB_NewData);
            this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/data.gif"));
        } else {
            this.setId("org.eclipse.stardust.modeling.core.createData." + config.getAttribute("id"));
            this.setText(config.getAttribute("name"));
            this.setImageDescriptor(DiagramPlugin.getImageDescriptor(config));
        }
    }

    protected boolean calculateEnabled() {
        return this.config != null && this.getSelectedObjects().size() == 1 && (this.getModel() != null || this.isDataCategoryNode());
    }

    private boolean isDataCategoryNode() {
        Object selection = this.getSelectedObjects().get(0);
        return selection instanceof ChildCategoryNode && Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Data());
    }

    public void run() {
        this.execute(this.createCommand());
        CreationUtils.showInOutlineAndEdit((EObject)this.data);
    }

    private Command createCommand() {
        IdFactory id = new IdFactory(this.config == null ? "data" : this.config.getAttribute("id"), this.config == null ? Diagram_Messages.NodeCreationFactory_BASENAME_Data : this.config.getAttribute("name"));
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        if (this.config != null) {
            command.add(new CreateMetaTypeCommand(this.config, CarnotWorkflowModelPackage.eINSTANCE.getDataTypeType(), new EStructuralFeature[0]));
        }
        command.add(new CreateTypedModelElementCommand(2, id, this.config == null ? null : this.config.getAttribute("id"), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), CarnotWorkflowModelPackage.eINSTANCE.getDataType()){

            @Override
            protected IModelElement createModelElement() {
                List attributes;
                DataType element = (DataType)super.createModelElement();
                IDataInitializer initializer = ModelUtils.getInitializer((DataTypeType)element.getType());
                if (initializer != null && (attributes = initializer.initialize(element, Collections.emptyList())) != null) {
                    element.getAttribute().addAll((Collection)attributes);
                }
                CreateDataAction.this.data = element;
                return element;
            }
        });
        command.setParent((EObject)(this.getModel() == null ? ((EditPart)this.getSelectedObjects().get(0)).getParent().getModel() : this.getModel()));
        return command;
    }

    private ModelType getModel() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ModelType) {
            return (ModelType)model;
        }
        return null;
    }
}

