/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InvalidIdentifierDialog
extends Dialog {
    private Text idText;
    private Button performCheckBox;
    private Text characterText;
    private Button autoPerformCheckBox;
    private String id;
    private String iconPath;
    private String type;
    private boolean perform = false;
    private char character = (char)95;
    private boolean autoPerform = false;
    private boolean hasInvalidCharacters;
    private boolean canAutoPerform;

    protected InvalidIdentifierDialog(Shell parentShell, boolean canAutoPerform, boolean hasInvalidCharacters) {
        super(parentShell);
        this.hasInvalidCharacters = hasInvalidCharacters;
        this.canAutoPerform = canAutoPerform;
        this.perform = !canAutoPerform;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Diagram_Messages.TXT_WR);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        Image image = DiagramPlugin.getImage(this.iconPath);
        Label iconLabel = FormBuilder.createLabel((Composite)composite, (String)"");
        iconLabel.setImage(image);
        FormBuilder.createLabel((Composite)composite, (String)this.id, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)this.getMessageText(), (int)3);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_ID);
        this.idText = FormBuilder.createText((Composite)composite, (int)2);
        this.idText.setText(this.id);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvalidIdentifierDialog.this.id = InvalidIdentifierDialog.this.idText.getText();
            }
        });
        this.performCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)this.getPerformCheckBoxText(), (int)2);
        this.performCheckBox.setSelection(this.perform);
        this.performCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                InvalidIdentifierDialog.this.perform = InvalidIdentifierDialog.this.performCheckBox.getSelection();
                InvalidIdentifierDialog.this.autoPerformCheckBox.setSelection(false);
                InvalidIdentifierDialog.this.autoPerformCheckBox.setVisible(InvalidIdentifierDialog.this.perform && InvalidIdentifierDialog.this.canAutoPerform);
                InvalidIdentifierDialog.this.updateId();
            }
        });
        this.characterText = new Text(composite, 2048);
        this.characterText.setTextLimit(1);
        this.characterText.setText(Character.toString(this.character));
        this.characterText.addVerifyListener(new VerifyListener(){
            private boolean changing = false;

            public void verifyText(VerifyEvent e) {
                if (!this.changing && !Character.isISOControl(e.character)) {
                    if (Character.isJavaIdentifierPart(e.character)) {
                        this.changing = true;
                        InvalidIdentifierDialog.this.characterText.setText(Character.toString(e.character));
                        this.changing = false;
                    }
                    e.doit = false;
                }
            }
        });
        GridData layoutData = new GridData();
        layoutData.minimumWidth = layoutData.widthHint = this.convertWidthInCharsToPixels(2);
        this.characterText.setLayoutData((Object)layoutData);
        this.characterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String replaceString = InvalidIdentifierDialog.this.characterText.getText();
                InvalidIdentifierDialog.this.character = replaceString.length() == 0 ? (char)'\u0000' : replaceString.charAt(0);
                InvalidIdentifierDialog.this.updateId();
            }
        });
        this.autoPerformCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)this.getAutoPerformCheckBoxText(), (int)3);
        this.autoPerformCheckBox.setSelection(this.autoPerform);
        this.autoPerformCheckBox.setVisible(this.perform && this.canAutoPerform);
        this.autoPerformCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                InvalidIdentifierDialog.this.autoPerform = InvalidIdentifierDialog.this.autoPerformCheckBox.getSelection();
            }
        });
        this.updateId();
        return composite;
    }

    private String getAutoPerformCheckBoxText() {
        return this.canAutoPerform ? Diagram_Messages.BOX_TXT_APPLY_TO_ALL_INVALID_ID_S : Diagram_Messages.BOX_TXT_APPLY_TO_ALL_SIMILAR_ISSUES_IN_THIS_MD;
    }

    public void updateId() {
        if (this.perform) {
            if (this.hasInvalidCharacters) {
                StringBuffer sb = new StringBuffer(this.id);
                int i = sb.length() - 1;
                while (i >= 0) {
                    if (!Character.isJavaIdentifierPart(sb.charAt(i))) {
                        if (this.character == '\u0000') {
                            sb.deleteCharAt(i);
                        } else {
                            sb.setCharAt(i, this.character);
                        }
                    }
                    --i;
                }
                this.id = sb.toString();
            } else if (this.character != '\u0000') {
                this.id = String.valueOf(Character.toString(this.character)) + this.id;
            }
            if (!this.idText.isDisposed()) {
                this.idText.setText(this.id);
            }
        }
    }

    public void initialize(String id, String iconPath, String type, boolean autoReplace) {
        this.id = id;
        this.iconPath = iconPath;
        this.type = type;
        this.autoPerform = autoReplace;
    }

    private String getMessageText() {
        return String.valueOf(this.type) + (this.hasInvalidCharacters ? Diagram_Messages.MSG_TXT_ID_CONTAINS_INVALID_CHARACTERS : Diagram_Messages.MSG_TXT_ID_IS_NOT_VALID);
    }

    private String getPerformCheckBoxText() {
        return this.hasInvalidCharacters ? Diagram_Messages.BOX_TXT_REPLACE_INVALID_CHARACTERS_WITH : Diagram_Messages.BOX_TXT_PREFIX_ID_WITH;
    }

    public String getId() {
        return this.id;
    }

    public boolean getAutoPerform() {
        return this.autoPerform;
    }
}

