/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.ui.IWorkbenchPart;

public class UpgradeDataAction
extends SelectionAction {
    private Command cmd;
    private static final String STARTING_USER = "STARTING_USER";
    private static final String LAST_ACTIVITY_PERFORMER = "LAST_ACTIVITY_PERFORMER";

    public UpgradeDataAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId("org.eclipse.stardust.model.xpdl.upgradeData");
        this.setText(Diagram_Messages.LB_UpgradeData);
    }

    protected boolean calculateEnabled() {
        Object modelElement;
        Object obj = this.getSelection();
        if (obj instanceof IStructuredSelection && (obj = ((IStructuredSelection)obj).getFirstElement()) instanceof IdentifiableModelElementTreeEditPart && (modelElement = ((AbstractTreeEditPart)obj).getModel()) instanceof DataType && (LAST_ACTIVITY_PERFORMER.equals(((DataType)modelElement).getId()) || STARTING_USER.equals(((DataType)modelElement).getId()))) {
            this.cmd = this.createUpdatePredefinedDataCmd((DataType)modelElement);
            return this.cmd.canExecute();
        }
        return false;
    }

    public void run() {
        this.execute(this.cmd);
    }

    private Command createUpdatePredefinedDataCmd(DataType data) {
        CompoundCommand command = new CompoundCommand();
        if (data != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("carnot:engine:homeInterface", "ag.carnot.workflow.runtime.UserHome");
            map.put("carnot:engine:remoteInterface", "ag.carnot.workflow.runtime.beans.IUser");
            map.put("carnot:engine:primaryKey", "ag.carnot.workflow.runtime.UserPK");
            map.put("carnot:engine:jndiPath", "ag.carnot.workflow.runtime.User");
            for (String attName : map.keySet()) {
                String attValue = (String)map.get(attName);
                AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)attName);
                if (attribute == null || attribute.getValue().equals(attValue)) continue;
                command.add((Command)new SetValueCmd((EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)attValue));
            }
            if (!data.isPredefined()) {
                command.add((Command)new SetValueCmd((EObject)data, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataType_Predefined(), true));
            }
        }
        return command;
    }
}

