/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.CurrentVersion;
import org.eclipse.stardust.common.config.Version;
import org.eclipse.stardust.engine.core.model.beans.XMLConstants;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetMapValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;

public class UpgradeModelAction
extends SelectionAction {
    private static final String TNS_PREFIX = "tns";
    private static final String STANDARD_CARNOT_WORKSPACE = "http://www.carnot.ag/workflowmodel/3.1/struct";
    private static final String STARTING_USER = "STARTING_USER";
    private static final String LAST_ACTIVITY_PERFORMER = "LAST_ACTIVITY_PERFORMER";
    private final WorkflowModelEditor editor;
    private HashMap<XSDSchema, String> schemas2namespace = new HashMap();

    public UpgradeModelAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.editor = editor;
        this.setId("org.eclipse.stardust.model.xpdl.upgradeModel");
        this.setText(Diagram_Messages.LB_UpgradeModel);
    }

    protected boolean calculateEnabled() {
        Object obj = this.getSelection();
        if (obj instanceof IStructuredSelection && (obj = ((IStructuredSelection)obj).getFirstElement()) instanceof ModelTreeEditPart) {
            return this.createUpdateModelCmd().canExecute();
        }
        return false;
    }

    public void run() {
        this.execute(this.createUpdateModelCmd());
    }

    public Command createUpdateModelCmd() {
        String carnotVersion;
        CompoundCommand command = new CompoundCommand();
        ModelType model = this.editor.getWorkflowModel();
        if (model == null) {
            return command.unwrap();
        }
        String vendor = model.getVendor();
        if (vendor != null && !vendor.equals(XMLConstants.VENDOR_NAME)) {
            command.add((Command)new SetValueCmd((EObject)this.editor.getWorkflowModel(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_Vendor(), (Object)XMLConstants.VENDOR_NAME));
        }
        if ((carnotVersion = model.getCarnotVersion()) == null || CurrentVersion.getVersion().compareTo(new Version(carnotVersion)) > 0) {
            command.add((Command)new SetValueCmd((EObject)this.editor.getWorkflowModel(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_CarnotVersion(), (Object)CurrentVersion.getVersionName()));
            this.createUpdatePredefinedDataCmd(command, (DataType)ModelUtils.findIdentifiableElement((List)this.editor.getWorkflowModel().getData(), (String)LAST_ACTIVITY_PERFORMER));
            this.createUpdatePredefinedDataCmd(command, (DataType)ModelUtils.findIdentifiableElement((List)this.editor.getWorkflowModel().getData(), (String)STARTING_USER));
            this.createUpdateControllingAttributes(command, this.editor.getWorkflowModel());
        }
        this.createMissingDataCmd(command);
        this.createMissingDataTypes(command);
        this.createMissingApplicationContextTypes(command);
        this.createModifiedValidatorsCmds(command);
        this.createChangeStructuredDataCmd(command);
        this.createModifiedDataMappingCmd(command);
        this.createModifiedProjectPlanningParametersCmd(command);
        return command.unwrap();
    }

    private void createModifiedProjectPlanningParametersCmd(CompoundCommand command) {
        ModelType model = this.editor.getWorkflowModel();
        for (AttributeType attribute : model.getAttribute()) {
            if (attribute.getName().indexOf("project-planning") <= -1) continue;
            String value = attribute.getValue();
            if (value != null && value.startsWith("ag.carnot.workflow.model.carnot")) {
                value = value.replaceAll("ag.carnot.workflow.model.carnot", "org.eclipse.stardust.model.xpdl.carnot");
                command.add((Command)new SetValueCmd((EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)value));
            }
            if (value == null || !value.startsWith("ag.carnot.modeling.project")) continue;
            value = value.replaceAll("ag.carnot.modeling.project", "org.eclipse.stardust.modeling.project");
            command.add((Command)new SetValueCmd((EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)value));
        }
    }

    private void createModifiedDataMappingCmd(CompoundCommand command) {
        ModelType model = this.editor.getWorkflowModel();
        for (ProcessDefinitionType processDefinition : model.getProcessDefinition()) {
            for (ActivityType activity : processDefinition.getActivity()) {
                for (DataMappingType dataMapping : activity.getDataMapping()) {
                    if (!StringUtils.isEmpty((String)dataMapping.getName())) continue;
                    dataMapping.setName(dataMapping.getId());
                }
            }
        }
    }

    private void createChangeStructuredDataCmd(CompoundCommand command) {
        ModelType model = this.editor.getWorkflowModel();
        TypeDeclarationsType declarations = model.getTypeDeclarations();
        if (declarations == null) {
            declarations = XpdlFactory.eINSTANCE.createTypeDeclarationsType();
            command.add((Command)new SetValueCmd((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_TypeDeclarations(), (Object)declarations));
        }
        EList list = declarations.getTypeDeclaration();
        boolean needUpgrade = true;
        for (TypeDeclarationType decl : list) {
            XpdlTypeType type = decl.getDataType();
            if (type instanceof SchemaTypeType) {
                XSDSchema schema = ((SchemaTypeType)type).getSchema();
                if (schema == null) {
                    String error = Diagram_Messages.ERR_NULL_SCHEMA_FOR_DECL_NULL;
                    System.err.println(MessageFormat.format(error, decl.getId()));
                    continue;
                }
                String targetNamespace = schema.getTargetNamespace();
                if (targetNamespace == null || targetNamespace.equals(STANDARD_CARNOT_WORKSPACE)) continue;
                needUpgrade = false;
                break;
            }
            needUpgrade = false;
            break;
        }
        if (needUpgrade) {
            XSDSchema schema;
            for (TypeDeclarationType decl : list) {
                schema = decl.getSchemaType().getSchema();
                if (schema == null) continue;
                this.patchSchemaNamespaces(command, decl, schema);
            }
            for (TypeDeclarationType decl : list) {
                schema = decl.getSchemaType().getSchema();
                if (schema == null) continue;
                this.resolveTypes(command, decl, schema);
            }
        }
    }

    private void patchSchemaNamespaces(CompoundCommand command, TypeDeclarationType declaration, XSDSchema schema) {
        ModelType model = (ModelType)declaration.eContainer().eContainer();
        command.add((Command)new SetMapValueCmd(schema.getQNamePrefixToNamespaceMap(), "xsd", "http://www.w3.org/2001/XMLSchema"));
        schema.setSchemaForSchemaQNamePrefix("xsd");
        command.add((Command)new SetMapValueCmd(schema.getQNamePrefixToNamespaceMap(), TNS_PREFIX, null));
        String targetNamespace = TypeDeclarationUtils.computeTargetNamespace((ModelType)model, (String)declaration.getId());
        String prefix = TypeDeclarationUtils.computePrefix((String)declaration.getId(), schema.getQNamePrefixToNamespaceMap().keySet());
        command.add((Command)new SetMapValueCmd(schema.getQNamePrefixToNamespaceMap(), prefix, targetNamespace));
        command.add((Command)new SetValueCmd((EObject)schema, (EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_TargetNamespace(), (Object)targetNamespace));
        this.schemas2namespace.put(schema, targetNamespace);
    }

    private void resolveTypes(CompoundCommand command, TypeDeclarationType declaration, XSDSchema schema) {
        for (XSDElementDeclaration element : schema.getElementDeclarations()) {
            if (!CompareHelper.areEqual((Object)schema, (Object)element.getSchema())) continue;
            this.patchElement(command, declaration, element);
        }
        for (XSDTypeDefinition type : schema.getTypeDefinitions()) {
            if (!(type instanceof XSDComplexTypeDefinition) || !CompareHelper.areEqual((Object)schema, (Object)type.getSchema())) continue;
            this.patchType(command, declaration, (XSDComplexTypeDefinition)type);
        }
    }

    private void patchType(CompoundCommand command, TypeDeclarationType declaration, XSDComplexTypeDefinition complexType) {
        XSDComplexTypeContent content = complexType.getContent();
        if (content instanceof XSDParticle) {
            this.patchParticle(command, declaration, (XSDParticle)content);
        }
    }

    private void patchParticle(CompoundCommand command, TypeDeclarationType declaration, XSDParticle particle) {
        XSDTerm term = particle.getTerm();
        if (term != null) {
            this.patchTerm(command, declaration, term);
        }
    }

    private void patchTerm(CompoundCommand command, TypeDeclarationType declaration, XSDTerm term) {
        if (term instanceof XSDElementDeclaration) {
            this.patchElement(command, declaration, (XSDElementDeclaration)term);
        } else if (term instanceof XSDModelGroup) {
            for (XSDParticle particle : ((XSDModelGroup)term).getContents()) {
                this.patchParticle(command, declaration, particle);
            }
        }
    }

    private void patchElement(CompoundCommand command, TypeDeclarationType declaration, XSDElementDeclaration element) {
        XSDTypeDefinition type = element.getAnonymousTypeDefinition();
        if (type instanceof XSDComplexTypeDefinition) {
            this.patchType(command, declaration, (XSDComplexTypeDefinition)type);
        } else if (type == null && (type = element.getType()) != null && type.getSchema() == null && (type = this.resolve(declaration, element, type)) != null && type.getSchema() != null) {
            this.updateImports(command, element.getSchema(), type.getSchema());
            command.add((Command)new SetValueCmd((EObject)element, (EStructuralFeature)XSDPackage.eINSTANCE.getXSDElementDeclaration_TypeDefinition(), (Object)type));
        }
    }

    private XSDTypeDefinition resolve(TypeDeclarationType declaration, XSDElementDeclaration element, XSDTypeDefinition type) {
        String name = type.getName();
        String targetNamespace = type.getTargetNamespace();
        if (name != null) {
            XSDSchema schema;
            XSDTypeDefinition def;
            if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace) && (def = UpgradeModelAction.findTypeDefinition(schema = element.getSchema(), name)) != null) {
                return def;
            }
            if (STANDARD_CARNOT_WORKSPACE.equals(targetNamespace) || TNS_PREFIX.equals(targetNamespace) || "http://www.w3.org/2001/XMLSchema".equals(targetNamespace)) {
                TypeDeclarationType decl = ((TypeDeclarationsType)declaration.eContainer()).getTypeDeclaration(name);
                return UpgradeModelAction.findTypeDefinition(decl);
            }
        }
        return null;
    }

    private static XSDTypeDefinition findTypeDefinition(TypeDeclarationType declaration) {
        XpdlTypeType type;
        if (declaration != null && (type = declaration.getDataType()) instanceof SchemaTypeType) {
            XSDSchema schema = ((SchemaTypeType)type).getSchema();
            String name = declaration.getId();
            return UpgradeModelAction.findTypeDefinition(schema, name);
        }
        return null;
    }

    private static XSDTypeDefinition findTypeDefinition(XSDSchema schema, String name) {
        if (schema != null) {
            for (XSDTypeDefinition def : schema.getTypeDefinitions()) {
                if (!name.equals(def.getName()) || !CompareHelper.areEqual((Object)schema, (Object)def.getSchema())) continue;
                return def;
            }
        }
        return null;
    }

    private void updateImports(CompoundCommand command, XSDSchema schema, XSDSchema schema2Import) {
        if (schema == schema2Import) {
            return;
        }
        for (XSDSchemaContent item : schema.getContents()) {
            XSDImport imported;
            if (!(item instanceof XSDImport) || schema2Import != (imported = (XSDImport)item).getResolvedSchema()) continue;
            return;
        }
        TypeDeclarationType decl = (TypeDeclarationType)schema2Import.eContainer().eContainer();
        String prefix = TypeDeclarationUtils.computePrefix((String)decl.getId(), schema.getQNamePrefixToNamespaceMap().keySet());
        command.add((Command)new SetMapValueCmd(schema.getQNamePrefixToNamespaceMap(), prefix, this.schemas2namespace.get(schema2Import)));
        XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
        xsdImport.setNamespace(this.schemas2namespace.get(schema2Import));
        xsdImport.setSchemaLocation(schema2Import.getSchemaLocation());
        command.add((Command)new SetValueCmd((EObject)schema, (EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_Contents(), 0, xsdImport));
    }

    private void createUpdateControllingAttributes(CompoundCommand command, ModelType model) {
        for (ProcessDefinitionType process : model.getProcessDefinition()) {
            this.createUpdateControllingAttributes(command, process);
        }
    }

    private void createUpdateControllingAttributes(CompoundCommand command, ProcessDefinitionType process) {
        for (ActivityType activity : process.getActivity()) {
            this.createUpdateControllingAttributes(command, activity);
        }
    }

    private void createUpdateControllingAttributes(CompoundCommand command, ActivityType activity) {
        this.createUpdateControllingAttribute(command, (IExtensibleElement)activity, "carnot:pwh:targetProcessingTime");
        this.createUpdateControllingAttribute(command, (IExtensibleElement)activity, "carnot:pwh:targetExecutionTime");
        this.createUpdateControllingAttribute(command, (IExtensibleElement)activity, "carnot:pwh:targetIdleTime");
        this.createUpdateControllingAttribute(command, (IExtensibleElement)activity, "carnot:pwh:targetWaitingTime");
    }

    private void createUpdateControllingAttribute(CompoundCommand command, IExtensibleElement element, String name) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)element, (String)name);
        if (attribute != null) {
            String value = attribute.getValue();
            try {
                long minutes = Long.parseLong(value);
                long hours = 0L;
                long days = 0L;
                if (minutes > 59L) {
                    hours = minutes / 60L;
                    minutes -= 60L * hours;
                    if (hours > 23L) {
                        days = hours / 24L;
                        hours -= 24L * days;
                    }
                }
                StringBuffer period = new StringBuffer();
                period.append("000:00:");
                this.appendNumber(period, days, 3);
                period.append(':');
                this.appendNumber(period, hours, 2);
                period.append(':');
                this.appendNumber(period, minutes, 2);
                period.append(":00");
                command.add((Command)new SetValueCmd((EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)period.toString()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void appendNumber(StringBuffer buffer, long value, int count) {
        if (value > 999L) {
            value = 999L;
        }
        if (count > 2 && value < 100L) {
            buffer.append('0');
        }
        if (count > 1 && value < 10L) {
            buffer.append('0');
        }
        buffer.append(value);
    }

    private void createMissingDataCmd(CompoundCommand command) {
        ModelType model = this.editor.getWorkflowModel();
        this.createMissingPrimitiveDataCmd(command, model, "PROCESS_PRIORITY", "Process Priority", "Priority assigned to the current process.", "int");
        this.createMissingPrimitiveDataCmd(command, model, "BUSINESS_DATE", Diagram_Messages.NAME_BusinessDate, Diagram_Messages.DESC_BusinessDate, "Timestamp");
    }

    protected void createMissingPrimitiveDataCmd(CompoundCommand command, ModelType model, String id, String name, String description, String subtype) {
        DataTypeType primitiveDataType;
        DataType data = (DataType)ModelUtils.findIdentifiableElement((List)model.getData(), (String)id);
        if (data == null && (primitiveDataType = (DataTypeType)ModelUtils.findIdentifiableElement((List)model.getDataType(), (String)"primitive")) != null) {
            CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
            data = factory.createDataType();
            data.setId(id);
            data.setName(name);
            data.setDescription(ModelUtils.createDescription((String)description));
            data.setPredefined(true);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:type", (String)"ag.carnot.workflow.spi.providers.data.java.Type", (String)subtype);
            command.add((Command)new SetValueCmd((EObject)this.editor.getWorkflowModel(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_Data(), (Object)data));
            command.add((Command)new SetValueCmd((EObject)data, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataType_Type(), (Object)primitiveDataType));
        }
    }

    private void createMissingApplicationContextTypes(CompoundCommand command) {
        String[] defaultContextTypes = new String[]{"default", "engine", "application", "jfc", "jsp", "processInterface", "externalWebApp"};
        ModelType model = this.editor.getWorkflowModel();
        EList applicationContextTypes = model.getApplicationContextType();
        Map dataTypesConfig = SpiExtensionRegistry.instance().getExtensions("contextTypes");
        String[] stringArray = defaultContextTypes;
        int n = defaultContextTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contextTypeKey = stringArray[n2];
            ApplicationContextTypeType contextType = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((List)applicationContextTypes, (String)contextTypeKey);
            if (contextType == null) {
                IConfigurationElement contextConfig = (IConfigurationElement)dataTypesConfig.get(contextTypeKey);
                CreateMetaTypeCommand createContextTypeCommand = new CreateMetaTypeCommand(contextConfig, CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasMappingId(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasApplicationPath()});
                createContextTypeCommand.setParent((EObject)model);
                command.add((Command)createContextTypeCommand);
            }
            ++n2;
        }
    }

    private void createMissingDataTypes(CompoundCommand command) {
        String[] dmsDataTypeKeys = new String[]{"dmsDocument", "dmsDocumentList", "dmsFolder", "dmsFolderList"};
        Map dataTypesConfig = SpiExtensionRegistry.instance().getExtensions("dataTypes");
        ModelType model = this.editor.getWorkflowModel();
        EList modelDataTypes = model.getDataType();
        String[] stringArray = dmsDataTypeKeys;
        int n = dmsDataTypeKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String dmsDataTypeKey = stringArray[n2];
            DataTypeType dmsDataType = (DataTypeType)ModelUtils.findIdentifiableElement((List)modelDataTypes, (String)dmsDataTypeKey);
            if (dmsDataType == null) {
                IConfigurationElement dataConfig = (IConfigurationElement)dataTypesConfig.get(dmsDataTypeKey);
                CreateMetaTypeCommand createDataTypeCommand = new CreateMetaTypeCommand(dataConfig, CarnotWorkflowModelPackage.eINSTANCE.getDataTypeType(), new EStructuralFeature[0]);
                createDataTypeCommand.setParent((EObject)model);
                command.add((Command)createDataTypeCommand);
            }
            ++n2;
        }
    }

    private void createModifiedValidatorsCmds(CompoundCommand command) {
        ModelType model = this.editor.getWorkflowModel();
        EventActionTypeType eventAction = (EventActionTypeType)ModelUtils.findIdentifiableElement((List)model.getEventActionType(), (String)"trigger");
        this.createModifiedValidatorCmd(command, (IExtensibleElement)eventAction, "carnot:engine:validator", "org.eclipse.stardust.engine.core.extensions.actions.trigger.TriggerActionValidator");
        eventAction = (EventActionTypeType)ModelUtils.findIdentifiableElement((List)model.getEventActionType(), (String)"mail");
        this.createModifiedValidatorCmd(command, (IExtensibleElement)eventAction, "carnot:engine:validator", "org.eclipse.stardust.engine.extensions.mail.action.sendmail.MailActionValidator");
        ApplicationContextTypeType appContext = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((List)model.getApplicationContextType(), (String)"jfc");
        this.createModifiedValidatorCmd(command, (IExtensibleElement)appContext, "carnot:engine:validator", "org.eclipse.stardust.engine.core.extensions.interactive.contexts.jfc.JFCValidator");
        appContext = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((List)model.getApplicationContextType(), (String)"jsp");
        this.createModifiedValidatorCmd(command, (IExtensibleElement)appContext, "carnot:engine:validator", "org.eclipse.stardust.engine.extensions.web.jsp.contexts.JSPValidator");
    }

    private void createModifiedValidatorCmd(CompoundCommand command, IExtensibleElement eventAction, String validatorAttrName, String validatorClassName) {
        if (eventAction == null) {
            return;
        }
        AttributeType validatorAttr = AttributeUtil.getAttribute((IExtensibleElement)eventAction, (String)validatorAttrName);
        if (validatorAttr == null) {
            validatorAttr = AttributeUtil.createAttribute((String)validatorAttrName);
            validatorAttr.setValue(validatorClassName);
            command.add((Command)new SetValueCmd((EObject)eventAction, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute(), (Object)validatorAttr));
        } else if (!validatorAttr.getAttributeValue().equals(validatorClassName)) {
            command.add((Command)new SetValueCmd((EObject)validatorAttr, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)validatorClassName));
        }
    }

    private void createUpdatePredefinedDataCmd(CompoundCommand command, DataType data) {
        if (data != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("carnot:engine:homeInterface", "ag.carnot.workflow.runtime.UserHome");
            map.put("carnot:engine:remoteInterface", "ag.carnot.workflow.runtime.beans.IUser");
            map.put("carnot:engine:primaryKey", "ag.carnot.workflow.runtime.UserPK");
            map.put("carnot:engine:jndiPath", "ag.carnot.workflow.runtime.User");
            for (String attName : map.keySet()) {
                String attValue = (String)map.get(attName);
                AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)attName);
                if (attribute.getValue().equals(attValue)) continue;
                command.add((Command)new SetValueCmd((EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)attValue));
            }
            if (!data.isPredefined()) {
                command.add((Command)new SetValueCmd((EObject)data, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataType_Predefined(), true));
            }
        }
    }
}

