/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.ui.AccessPathWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AccessPathBrowserComposite {
    private Text methodText;
    private IDirectionProvider directionProvider;
    private DirectionType staticDirection = DirectionType.OUT_LITERAL;
    private ITypedElement accessPoint;
    private Button browseButton;
    private boolean browsePrimitiveAllowed = true;
    private boolean enabled = true;

    public AccessPathBrowserComposite(WorkflowModelEditor editor, Composite parent, String title) {
        this.init(editor, parent, title, 1);
    }

    public AccessPathBrowserComposite(WorkflowModelEditor editor, Composite parent, String title, int span) {
        this.init(editor, parent, title, span);
    }

    public AccessPathBrowserComposite(WorkflowModelEditor editor, Composite parent, String title, boolean browsePrimAllowed) {
        this.browsePrimitiveAllowed = browsePrimAllowed;
        this.init(editor, parent, title, 1);
    }

    private void init(final WorkflowModelEditor editor, Composite parent, final String title, int span) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        GridData gd = FormBuilder.createDefaultSingleLineWidgetGridData();
        gd.horizontalSpan = span;
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        composite.setLayoutData((Object)gd);
        this.methodText = FormBuilder.createText((Composite)composite);
        this.browseButton = FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.Btn_Browse, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AccessPathWizard browser = new AccessPathWizard(editor, title, AccessPathBrowserComposite.this.accessPoint, AccessPathBrowserComposite.this.getDirection());
                browser.setMethod(AccessPathBrowserComposite.this.getMethod());
                if (browser.open() == 0) {
                    AccessPathBrowserComposite.this.methodText.setText(browser.getSelectedMethod() == null ? "" : browser.getSelectedMethod());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public String getMethod() {
        return this.methodText.isEnabled() ? this.methodText.getText().trim() : "";
    }

    public void setMethod(String methodName) {
        this.methodText.setText(methodName);
    }

    public Text getMethodText() {
        return this.methodText;
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    public void setDirectionProvider(IDirectionProvider provider) {
        this.directionProvider = provider;
    }

    public void setAccessPoint(ITypedElement element, DirectionType direction) {
        this.staticDirection = direction;
        this.accessPoint = element;
        this.enableControls();
    }

    private void enableControls() {
        boolean enable;
        boolean bl = enable = this.enabled && this.accessPoint != null;
        if (this.accessPoint != null && this.accessPoint.eIsProxy()) {
            enable = false;
        }
        if (enable) {
            if (this.accessPoint instanceof DataType) {
                enable = this.dataTypeSupportsBrowsing(((DataType)this.accessPoint).getType());
            } else if (this.accessPoint instanceof IExtensibleElement) {
                boolean bl2 = enable = !DirectionType.IN_LITERAL.equals((Object)this.getDirection());
                if (!enable) {
                    enable = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)this.accessPoint), (String)"carnot:engine:browsable");
                }
            }
        }
        this.methodText.setEnabled(enable);
        this.browseButton.setEnabled(enable);
        if (!enable) {
            this.methodText.setText("");
        }
    }

    private DirectionType getDirection() {
        return this.directionProvider == null ? this.staticDirection : this.directionProvider.getDirection();
    }

    private boolean dataTypeSupportsBrowsing(DataTypeType type) {
        DataTypeType dataType = type;
        if ("primitive".equals(type.getId()) && !this.browsePrimitiveAllowed) {
            return false;
        }
        IAccessPathEditor editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)dataType);
        return editor != null && editor.supportsBrowsing();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enableControls();
    }

    public static interface IDirectionProvider {
        public DirectionType getDirection();
    }
}

