/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.engine.extensions.jms.app.DefaultMessageProvider;
import org.eclipse.stardust.engine.extensions.jms.app.JMSLocation;
import org.eclipse.stardust.engine.extensions.jms.app.MessageType;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IMessageProvider;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RequestPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String[] types = new String[]{MessageType.MAP.getId(), MessageType.OBJECT.getId(), MessageType.TEXT.getId(), MessageType.STREAM.getId()};
    private static final String[] classNames;
    private LabeledText factoryJndiText;
    private LabeledText queueJndiText;
    private LabeledCombo lbcMsgProvider;
    private ComboViewer providerCombo;
    private LabeledCombo lbcMsgType;
    private ComboViewer messageTypeCombo;
    private Button includeHeaders;
    private Button[] buttons;
    private ISelectionChangedListener providerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            RequestPropertyPage.this.providerChanged(true);
        }
    };
    private ISelectionChangedListener messageListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            RequestPropertyPage.this.messageTypeChanged();
        }
    };

    static {
        String[] stringArray = new String[4];
        stringArray[1] = Object.class.getName();
        stringArray[2] = String.class.getName();
        classNames = stringArray;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.providerCombo.removeSelectionChangedListener(this.providerListener);
        this.messageTypeCombo.removeSelectionChangedListener(this.messageListener);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        ApplicationType application = (ApplicationType)element;
        binding.bind(this.factoryJndiText, (IExtensibleElement)application, "carnot:engine:queueConnectionFactory.jndiName");
        binding.bind(this.queueJndiText, (IExtensibleElement)application, "carnot:engine:queue.jndiName");
        binding.getValidationBindingManager().bind((EObject)application, (Object)"carnot:engine:messageProvider", this.lbcMsgProvider.getLabel());
        binding.getValidationBindingManager().bind((EObject)application, (Object)"carnot:engine:messageType", this.lbcMsgType.getLabel());
        Collection providers = this.getProviders();
        String providerClass = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:messageProvider");
        this.providerCombo.setInput((Object)providers);
        IMessageProvider provider = this.findProvider(providers, providerClass);
        this.providerCombo.setSelection((ISelection)(provider == null ? null : new StructuredSelection((Object)provider)));
        this.providerChanged(false);
        String messageType = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:requestMessageType");
        this.messageTypeCombo.setSelection((ISelection)new StructuredSelection((Object)(messageType == null ? types[0] : messageType)));
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)"carnot:engine:includeOidHeaders");
        this.includeHeaders.setSelection(attribute != null && AttributeUtil.getBooleanValue((AttributeType)attribute));
        this.providerCombo.addSelectionChangedListener(this.providerListener);
        this.messageTypeCombo.addSelectionChangedListener(this.messageListener);
    }

    private IMessageProvider findProvider(Collection providers, String providerClass) {
        for (IMessageProvider msgProvider : providers) {
            if (!msgProvider.getRuntimeClassName().equals(providerClass)) continue;
            return msgProvider;
        }
        return providerClass == null && providers.size() == 1 ? providers.iterator().next() : null;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = (ApplicationType)element;
        IMessageProvider provider = this.getSelectedProvider();
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:messageProvider", (String)(provider == null ? null : provider.getRuntimeClassName()));
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:requestMessageType", (String)MessageType.class.getName(), (String)this.getSelectedMessageType());
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:includeOidHeaders", (String)Boolean.TYPE.getName(), (String)(this.includeHeaders.getSelection() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
    }

    private IMessageProvider getSelectedProvider() {
        IStructuredSelection selection = (IStructuredSelection)this.providerCombo.getSelection();
        IMessageProvider provider = null;
        if (selection != null && !selection.isEmpty()) {
            provider = (IMessageProvider)selection.getFirstElement();
        }
        return provider;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.factoryJndiText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ConnectionFactoryJNDI);
        this.queueJndiText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_QueueJNDI);
        this.lbcMsgProvider = FormBuilder.createLabeledCombo((Composite)composite, (String)Diagram_Messages.LB_SPI_MessageProviderTypeClass);
        this.providerCombo = new ComboViewer(this.lbcMsgProvider.getCombo());
        this.providerCombo.setSorter(new ViewerSorter());
        this.providerCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.providerCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMessageProvider)element).getName();
            }
        });
        this.lbcMsgType = FormBuilder.createLabeledCombo((Composite)composite, (String)Diagram_Messages.LB_MessageType);
        this.messageTypeCombo = new ComboViewer(this.lbcMsgType.getCombo());
        this.messageTypeCombo.setSorter(new ViewerSorter());
        this.messageTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_IncludeOIDHeaderFields);
        this.includeHeaders = FormBuilder.createCheckBox((Composite)composite, (String)"");
        return composite;
    }

    private void messageTypeChanged() {
        ApplicationType application = this.getApplication();
        EList aps = application.getAccessPoint();
        int i = aps.size() - 1;
        while (i >= 0) {
            AccessPointType ap = (AccessPointType)aps.get(i);
            if (ap.getDirection().equals((Object)DirectionType.IN_LITERAL)) {
                aps.remove(ap);
            }
            --i;
        }
        IMessageProvider provider = this.getSelectedProvider();
        if (provider != null) {
            String messageType = this.getSelectedMessageType();
            aps.addAll(provider.getPredefinedAccessPoints(messageType));
        }
    }

    private String getSelectedMessageType() {
        IStructuredSelection selection = (IStructuredSelection)this.messageTypeCombo.getSelection();
        String messageType = null;
        if (selection != null && !selection.isEmpty()) {
            messageType = (String)selection.getFirstElement();
        }
        return messageType;
    }

    private ApplicationType getApplication() {
        return (ApplicationType)this.getElement().getAdapter(IModelElement.class);
    }

    private void providerChanged(boolean propagate) {
        this.messageTypeCombo.setInput(null);
        IMessageProvider provider = this.getSelectedProvider();
        if (provider != null) {
            Collection messageTypes = provider.getMessageTypes();
            this.messageTypeCombo.setInput((Object)messageTypes);
            if (!messageTypes.isEmpty()) {
                this.messageTypeCombo.setSelection((ISelection)new StructuredSelection(messageTypes.iterator().next()));
            }
        }
        if (propagate) {
            this.messageTypeChanged();
        }
    }

    private Collection getProviders() {
        TreeMap<String, IMessageProvider> providers = new TreeMap<String, IMessageProvider>();
        Map extensions = SpiExtensionRegistry.instance().getExtensions("messageProviders");
        for (IConfigurationElement config : extensions.values()) {
            try {
                IMessageProvider provider = (IMessageProvider)config.createExecutableExtension("providerClass");
                providers.put(provider.getName(), provider);
            }
            catch (CoreException coreException) {}
        }
        IMessageProvider defaultProvider = new IMessageProvider(){

            public String getName() {
                return Diagram_Messages.NAME_PROVIDER_DefaultProvider;
            }

            public Collection getMessageTypes() {
                return Arrays.asList(types);
            }

            public String getRuntimeClassName() {
                return DefaultMessageProvider.class.getName();
            }

            public Collection getPredefinedAccessPoints(String messageType) {
                int i = 1;
                while (i < 3) {
                    if (types[i].equals(messageType)) {
                        return Collections.singletonList(RequestPropertyPage.this.getAccessPoint(classNames[i]));
                    }
                    ++i;
                }
                return Collections.EMPTY_LIST;
            }
        };
        providers.put(defaultProvider.getName(), defaultProvider);
        return providers.values();
    }

    private Object getAccessPoint(String classname) {
        AccessPointType ap = AccessPointUtil.createIntrinsicAccessPoint((String)"content", (String)Diagram_Messages.BASENAME_Content, (String)classname, (DirectionType)DirectionType.IN_LITERAL, (boolean)false, null, (DataTypeType)ModelUtils.getDataType((IModelElement)this.getApplication(), (String)"serializable"));
        AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:jms.location", (String)JMSLocation.class.getName(), (String)JMSLocation.BODY.getId());
        return ap;
    }

    public void setVisible(boolean visible) {
        IButtonManager manager;
        if (visible && (manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class)) != null) {
            manager.updateButtons("Request", this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        if (manager != null) {
            this.buttons = manager.createButtons(parent);
        }
    }
}

