/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractSwimlaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ChangeConstraintCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneHelper;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.PlatformUI;

public class PoolLaneUtils
extends PoolLaneHelper {
    public static Comparator LANESYMBOL_COMPARATOR = new LaneSymbolComparator();

    public static CompoundCommand shrinkToFitAllContainer(AbstractSwimlaneEditPart editPart, int[] currentSpace, List siblings, boolean childSibling, List changedContainer) {
        boolean isSibling = false;
        if (!siblings.isEmpty() && siblings.contains(editPart)) {
            isSibling = true;
        }
        if (childSibling) {
            isSibling = true;
        }
        CompoundCommand cmd = new CompoundCommand();
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)editPart.getModel()));
        OrientationType direction = diagram.getOrientation();
        ISwimlaneSymbol symbol = editPart.getSwimlaneModel();
        Rectangle symbolBounds = GenericUtils.getSymbolRectangle((EditPart)editPart);
        int[] useSpace = new int[]{currentSpace[0], currentSpace[1], currentSpace[2], currentSpace[3]};
        if (isSibling || !PoolLaneUtils.containsSymbols((EditPart)editPart)) {
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                useSpace[0] = 0;
                useSpace[2] = 0;
            } else {
                useSpace[1] = 0;
                useSpace[3] = 0;
            }
        }
        symbolBounds.width -= useSpace[0] + useSpace[2];
        symbolBounds.height -= useSpace[1] + useSpace[3];
        MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
        moveCommand.setPart((INodeSymbol)symbol);
        symbolBounds = SnapGridUtils.getSnapRectangle(editPart.getParent(), (EditPart)editPart, symbolBounds.getSize(), symbolBounds.getLocation());
        moveCommand.setBounds(symbolBounds);
        cmd.add((Command)moveCommand);
        if (PoolLaneUtils.containsOthers(editPart)) {
            if (useSpace[0] > 0 || useSpace[1] > 0) {
                int[] resizeValue = new int[2];
                if (useSpace[0] > 0 && useSpace[1] > 0) {
                    resizeValue = new int[]{-useSpace[0], -useSpace[1]};
                } else if (useSpace[0] > 0) {
                    int[] nArray = new int[2];
                    nArray[0] = -useSpace[0];
                    resizeValue = nArray;
                } else if (useSpace[1] > 0) {
                    int[] nArray = new int[2];
                    nArray[1] = -useSpace[1];
                    resizeValue = nArray;
                }
                cmd.add((Command)PoolLaneUtils.moveAllChildren((EditPart)editPart, resizeValue));
            }
            changedContainer.add(editPart);
        } else if (PoolLaneUtils.containsLanes((EditPart)editPart)) {
            List children = editPart.getChildren();
            int i = 0;
            while (i < children.size()) {
                LaneEditPart childEP = (LaneEditPart)children.get(i);
                cmd.add((Command)PoolLaneUtils.shrinkToFitAllContainer(childEP, useSpace, siblings, isSibling, changedContainer));
                ++i;
            }
        }
        return cmd;
    }

    public static CompoundCommand shrinkToFit(AbstractSwimlaneEditPart editPart) {
        EditPart poolEP = PoolLaneUtils.getPoolEditPart((EditPart)editPart);
        CompoundCommand cmd = new CompoundCommand();
        ArrayList siblings = new ArrayList();
        if (!(editPart instanceof PoolEditPart)) {
            EditPart parentEP = editPart.getParent();
            AbstractSwimlaneEditPart checkEP = editPart;
            while (!(parentEP instanceof DiagramEditPart)) {
                List checkSiblings = PoolLaneUtils.getSiblings(parentEP, (EditPart)checkEP);
                if (!checkSiblings.isEmpty()) {
                    siblings.addAll(checkSiblings);
                }
                checkEP = parentEP;
                parentEP = parentEP.getParent();
            }
        }
        ArrayList changedContainer = new ArrayList();
        int[] currentSpace = new int[]{-1, -1, -1, -1};
        PoolLaneUtils.canShrink(editPart, currentSpace);
        cmd.add((Command)PoolLaneUtils.shrinkToFitAllContainer((AbstractSwimlaneEditPart)poolEP, currentSpace, siblings, false, changedContainer));
        if (!changedContainer.isEmpty()) {
            int i = 0;
            while (i < changedContainer.size()) {
                EditPart container = (EditPart)changedContainer.get(i);
                if (!(container instanceof PoolEditPart)) {
                    PoolLaneUtils.setResizeFlags(-1);
                    CompoundCommand changeContainer = PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)container.getParent(), new Integer(4));
                    cmd.add((Command)changeContainer);
                }
                ++i;
            }
        }
        return cmd;
    }

    public static CompoundCommand reorderSiblings(EditPart changedEP, EditPart useParentEP) {
        if (changedEP.getParent() == null && useParentEP == null) {
            return null;
        }
        CompoundCommand cmd = new CompoundCommand();
        ArrayList siblings = new ArrayList();
        if (!(changedEP instanceof PoolEditPart)) {
            EditPart parentEP = useParentEP == null ? changedEP.getParent() : useParentEP;
            EditPart checkEP = changedEP;
            while (!(parentEP instanceof DiagramEditPart)) {
                List checkSiblings = PoolLaneUtils.getSiblings(parentEP, checkEP);
                if (!checkSiblings.isEmpty()) {
                    siblings.addAll(checkSiblings);
                }
                checkEP = parentEP;
                parentEP = parentEP.getParent();
            }
        }
        if (siblings.size() > 0) {
            int i = 0;
            while (i < siblings.size()) {
                final EditPart sibling = (EditPart)siblings.get(i);
                INodeSymbol symbol = (INodeSymbol)sibling.getModel();
                final int[] oldSize = new int[]{symbol.getWidth(), symbol.getHeight()};
                if (PoolLaneUtils.containsLanes(sibling)) {
                    cmd.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.resizeChildLanes((AbstractSwimlaneEditPart)sibling, oldSize);
                        }
                    });
                    cmd.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.reorderChildLanes((AbstractSwimlaneEditPart)sibling, new Integer(3));
                        }
                    });
                }
                ++i;
            }
        }
        return cmd;
    }

    public static CompoundCommand checkMoveChildren(EditPart editPart, int[] newInnerSpace) {
        CompoundCommand cmd = new CompoundCommand();
        if ((resizeLeft || resizeTop) && (newInnerSpace[0] != 0 || newInnerSpace[1] != 0)) {
            int[] resizeValue;
            if (resizeLeft && resizeTop) {
                resizeValue = new int[]{newInnerSpace[0], newInnerSpace[1]};
            } else if (resizeLeft) {
                int[] nArray = new int[2];
                nArray[0] = newInnerSpace[0];
                resizeValue = nArray;
            } else if (resizeTop) {
                int[] nArray = new int[2];
                nArray[1] = newInnerSpace[1];
                resizeValue = nArray;
            } else {
                return null;
            }
            cmd.add((Command)PoolLaneUtils.moveAllChildren(editPart, resizeValue));
        }
        return cmd;
    }

    public static CompoundCommand resizeChildLanes(final AbstractSwimlaneEditPart containerEP, int[] oldSize) {
        CompoundCommand cmd = new CompoundCommand();
        INodeSymbol containerSymbol = (INodeSymbol)containerEP.getModel();
        int newWidthSpace = containerSymbol.getWidth() - oldSize[0];
        int newHeightSpace = containerSymbol.getHeight() - oldSize[1];
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)containerEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        if (!PoolLaneUtils.containsLanes((EditPart)containerEP)) {
            return null;
        }
        int[] fixValue = new int[1];
        double onePercent = PoolLaneUtils.getOnePercent(containerEP, fixValue, null);
        List children = containerEP.getChildren();
        EditPart laneToFix = null;
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (editPart instanceof LaneEditPart && PoolLaneUtils.canChange(editPart)) {
                laneToFix = editPart;
            }
            ++i;
        }
        if (newWidthSpace != 0 || newHeightSpace != 0) {
            Rectangle snapRectangle;
            Rectangle symbolRectangle;
            int[] newInnerSpace;
            INodeSymbol symbol;
            EditPart editPart;
            int i2;
            int changedSum = 0;
            int snapGridLeftValue = 0;
            if (SnapGridUtils.getSnapToHelper(containerEP) != null) {
                i2 = 0;
                while (i2 < children.size()) {
                    editPart = (EditPart)children.get(i2);
                    if (editPart instanceof LaneEditPart) {
                        symbol = (INodeSymbol)editPart.getModel();
                        newInnerSpace = new int[2];
                        newInnerSpace = editPart.equals(laneToFix) && fixValue[0] != 0 ? (OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? PoolLaneUtils.getNewChildLaneSize(editPart, new int[]{newWidthSpace + fixValue[0], newHeightSpace}, onePercent) : PoolLaneUtils.getNewChildLaneSize(editPart, new int[]{newWidthSpace, newHeightSpace + fixValue[0]}, onePercent)) : PoolLaneUtils.getNewChildLaneSize(editPart, new int[]{newWidthSpace, newHeightSpace}, onePercent);
                        symbolRectangle = new Rectangle(new Long(symbol.getXPos()).intValue(), new Long(symbol.getYPos()).intValue(), newInnerSpace[0] + symbol.getWidth(), newInnerSpace[1] + symbol.getHeight());
                        snapRectangle = SnapGridUtils.getSnapRectangle((EditPart)containerEP, editPart, symbolRectangle.getSize(), symbolRectangle.getLocation());
                        changedSum = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (changedSum += snapRectangle.width - symbol.getWidth()) : (changedSum += snapRectangle.height - symbol.getHeight());
                    }
                    ++i2;
                }
                if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                    if (changedSum != newWidthSpace) {
                        snapGridLeftValue = newWidthSpace - changedSum;
                    }
                } else if (changedSum != newHeightSpace) {
                    snapGridLeftValue = newHeightSpace - changedSum;
                }
            }
            i2 = 0;
            while (i2 < children.size()) {
                editPart = (EditPart)children.get(i2);
                if (editPart instanceof LaneEditPart) {
                    symbol = (INodeSymbol)editPart.getModel();
                    if (editPart.equals(laneToFix) && (fixValue[0] != 0 || snapGridLeftValue != 0)) {
                        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                            newInnerSpace = PoolLaneUtils.getNewChildLaneSize(editPart, new int[]{newWidthSpace + fixValue[0], newHeightSpace}, onePercent);
                            newInnerSpace[0] = newInnerSpace[0] + snapGridLeftValue;
                        } else {
                            newInnerSpace = PoolLaneUtils.getNewChildLaneSize(editPart, new int[]{newWidthSpace, newHeightSpace + fixValue[0]}, onePercent);
                            newInnerSpace[1] = newInnerSpace[1] + snapGridLeftValue;
                        }
                    } else {
                        newInnerSpace = PoolLaneUtils.getNewChildLaneSize(editPart, new int[]{newWidthSpace, newHeightSpace}, onePercent);
                    }
                    symbolRectangle = new Rectangle(new Long(symbol.getXPos()).intValue(), new Long(symbol.getYPos()).intValue(), newInnerSpace[0] + symbol.getWidth(), newInnerSpace[1] + symbol.getHeight());
                    snapRectangle = SnapGridUtils.getSnapRectangle((EditPart)containerEP, editPart, symbolRectangle.getSize(), symbolRectangle.getLocation());
                    cmd.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            MoveNodeSymbolCommand changeCmd = new MoveNodeSymbolCommand();
                            changeCmd.setPart(symbol);
                            changeCmd.setBounds(snapRectangle);
                            return changeCmd;
                        }
                    });
                    cmd.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.checkMoveChildren(editPart, newInnerSpace);
                        }
                    });
                }
                ++i2;
            }
        }
        final int[] newSize = new int[2];
        cmd.add((Command)new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                return PoolLaneUtils.changeContainerLanes(containerEP, newSize, new Integer(3), false);
            }
        });
        int i3 = 0;
        while (i3 < children.size()) {
            final EditPart editPart = (EditPart)children.get(i3);
            if (editPart instanceof LaneEditPart) {
                INodeSymbol symbol = (INodeSymbol)editPart.getModel();
                final int[] innerOldSize = new int[]{symbol.getWidth(), symbol.getHeight()};
                cmd.add((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.resizeChildLanes((AbstractSwimlaneEditPart)editPart, innerOldSize);
                    }
                });
            }
            ++i3;
        }
        return cmd;
    }

    public static CompoundCommand resizeLane(final AbstractSwimlaneEditPart containerEP) {
        EditPart editPart;
        boolean mustResizeContainer = false;
        CompoundCommand cmd = new CompoundCommand();
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)containerEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        List children = containerEP.getChildren();
        final INodeSymbol containerSymbol = (INodeSymbol)containerEP.getModel();
        Insets insets = ((AbstractSwimlaneFigure)containerEP.getFigure()).getAbstractSwimlaneFigureInsets();
        Rectangle drawingArea = null;
        Rectangle defaultDrawingArea = containerEP.getFigure().getBounds().getCopy();
        int[] resizeValue = new int[2];
        int i = 0;
        while (i < children.size()) {
            editPart = (EditPart)children.get(i);
            INodeSymbol symbol = (INodeSymbol)editPart.getModel();
            if (symbol.getXPos() < 0L || symbol.getYPos() < 0L) {
                if (symbol.getXPos() < 0L) {
                    resizeValue[0] = -new Long(symbol.getXPos()).intValue();
                }
                if (symbol.getYPos() >= 0L) break;
                resizeValue[1] = -new Long(symbol.getYPos()).intValue();
                if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                    resizeValue[1] = resizeValue[1] + insets.bottom * 2;
                    break;
                }
                resizeValue[1] = resizeValue[1] + insets.getHeight();
                break;
            }
            ++i;
        }
        if (resizeValue[0] != 0 || resizeValue[1] != 0) {
            boolean[] addFixValue = new boolean[2];
            if (SnapGridUtils.getSnapToHelper(containerEP) != null) {
                PoolLaneUtils.getSnapGridResizeValue((EditPart)containerEP, resizeValue, addFixValue);
            }
            final int[] innerResizeValue = new int[]{resizeValue[0], resizeValue[1]};
            mustResizeContainer = true;
            cmd.add((Command)new DelegatingCommand(){

                @Override
                public Command createDelegate() {
                    return PoolLaneUtils.moveAllChildren((EditPart)containerEP, innerResizeValue);
                }
            });
            defaultDrawingArea.width = defaultDrawingArea.width + (resizeValue[0] + (addFixValue[0] ? SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2 : 0));
            defaultDrawingArea.height = defaultDrawingArea.height + (resizeValue[1] + (addFixValue[1] ? SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2 : 0));
            Dimension currentDimension = new Dimension(defaultDrawingArea.width, defaultDrawingArea.height);
            Point currentLocation = new Point(defaultDrawingArea.x, defaultDrawingArea.y);
            defaultDrawingArea = SnapGridUtils.getSnapRectangle(containerEP.getParent(), (EditPart)containerEP, currentDimension, currentLocation);
            final Rectangle newBounds = new Rectangle(defaultDrawingArea);
            cmd.add((Command)new DelegatingCommand(){

                @Override
                public Command createDelegate() {
                    MoveNodeSymbolCommand cmd = new MoveNodeSymbolCommand();
                    cmd.setPart(containerSymbol);
                    cmd.setBounds(newBounds);
                    return cmd;
                }
            });
        }
        i = 0;
        while (i < children.size()) {
            editPart = (EditPart)children.get(i);
            Rectangle symbolRectangle = GenericUtils.getSymbolRectangle(editPart);
            if (drawingArea != null) {
                drawingArea.union(symbolRectangle);
            } else {
                drawingArea = symbolRectangle;
            }
            ++i;
        }
        if (drawingArea != null) {
            if (resizeValue[0] != 0 || resizeValue[1] != 0) {
                drawingArea.width += resizeValue[0];
                drawingArea.height += resizeValue[1];
            }
            drawingArea.width += drawingArea.x;
            drawingArea.height += drawingArea.y;
            drawingArea.x = defaultDrawingArea.x;
            drawingArea.y = defaultDrawingArea.y;
            drawingArea.width += insets.getWidth();
            drawingArea.height += insets.getHeight() + insets.bottom;
            if (defaultDrawingArea.width < drawingArea.width || defaultDrawingArea.height < drawingArea.height) {
                mustResizeContainer = true;
                if (drawingArea.width < defaultDrawingArea.width) {
                    drawingArea.width = defaultDrawingArea.width;
                }
                if (drawingArea.height < defaultDrawingArea.height) {
                    drawingArea.height = defaultDrawingArea.height;
                }
                Dimension currentDimension = new Dimension(drawingArea.width, drawingArea.height);
                Point currentLocation = new Point(drawingArea.x, drawingArea.y);
                Rectangle snapRectangle = SnapGridUtils.getSnapRectangle(containerEP.getParent(), (EditPart)containerEP, currentDimension, currentLocation);
                final Rectangle newBounds = new Rectangle(snapRectangle);
                cmd.add((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        MoveNodeSymbolCommand cmd = new MoveNodeSymbolCommand();
                        cmd.setPart(containerSymbol);
                        cmd.setBounds(newBounds);
                        return cmd;
                    }
                });
            }
        }
        if (mustResizeContainer && containerEP.getParent() instanceof AbstractSwimlaneEditPart) {
            cmd.add((Command)PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)containerEP.getParent(), new Integer(2)));
        }
        return cmd;
    }

    public static CompoundCommand reorderChildLanes(final AbstractSwimlaneEditPart containerEP, final Integer changeChildLanes) {
        CompoundCommand cmd = new CompoundCommand();
        if (!PoolLaneUtils.containsLanes((EditPart)containerEP)) {
            return null;
        }
        cmd.add((Command)new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                return PoolLaneUtils.changeContainerLanes(containerEP, new int[2], changeChildLanes, true);
            }
        });
        List children = containerEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (PoolLaneUtils.containsLanes(editPart)) {
                cmd.add((Command)PoolLaneUtils.reorderChildLanes((AbstractSwimlaneEditPart)editPart, changeChildLanes));
            }
            ++i;
        }
        return cmd;
    }

    public static CompoundCommand reorderLanes(AbstractSwimlaneEditPart containerEP, Integer changeChildLanes) {
        CompoundCommand cmd = new CompoundCommand();
        AbstractSwimlaneEditPart parent = containerEP;
        while (parent != null && parent instanceof AbstractSwimlaneEditPart) {
            int[] newSize = new int[2];
            AbstractSwimlaneEditPart useParent = parent;
            cmd.add((Command)new DelegatingCommand((EditPart)useParent, newSize, changeChildLanes){
                private final /* synthetic */ EditPart val$useParent;
                private final /* synthetic */ int[] val$newSize;
                private final /* synthetic */ Integer val$changeChildLanes;
                {
                    this.val$useParent = editPart;
                    this.val$newSize = nArray;
                    this.val$changeChildLanes = n;
                }

                @Override
                public Command createDelegate() {
                    CompoundCommand command = new CompoundCommand();
                    command.add((Command)PoolLaneUtils.changeContainerLanes((AbstractSwimlaneEditPart)this.val$useParent, this.val$newSize, this.val$changeChildLanes, false));
                    final int[] newInnerSize = new int[]{this.val$newSize[0], this.val$newSize[1]};
                    final EditPart useInnerParent = this.val$useParent;
                    if (useInnerParent instanceof AbstractSwimlaneEditPart && (newInnerSize[0] != 0 || newInnerSize[1] != 0)) {
                        command.add((Command)new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                return PoolLaneUtils.changeParentLane((AbstractSwimlaneEditPart)useInnerParent, newInnerSize);
                            }
                        });
                    }
                    return command;
                }
            });
            parent = parent.getParent();
        }
        return cmd;
    }

    public static CompoundCommand changeContainerLanes(AbstractSwimlaneEditPart containerEP, int[] newSize, Integer changeChildLanes, boolean keepPosition) {
        CompoundCommand cmd = new CompoundCommand();
        Insets insets = ((AbstractSwimlaneFigure)containerEP.getFigure()).getAbstractSwimlaneFigureInsets();
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)containerEP.getModel()));
        if (diagram == null) {
            cmd.add((Command)UnexecutableCommand.INSTANCE);
            return cmd;
        }
        OrientationType direction = diagram.getOrientation();
        ISwimlaneSymbol containerSymbol = (ISwimlaneSymbol)containerEP.getModel();
        Rectangle containerBounds = new Rectangle(new Long(containerSymbol.getXPos()).intValue(), new Long(containerSymbol.getYPos()).intValue(), containerSymbol.getWidth(), containerSymbol.getHeight());
        HashMap<Rectangle, LaneEditPart> areaMap = new HashMap<Rectangle, LaneEditPart>();
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>();
        List children = containerEP.getChildren();
        ArrayList<EditPart> lanes = new ArrayList<EditPart>();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (editPart instanceof LaneEditPart) {
                lanes.add(editPart);
            }
            ++i;
        }
        int maxSize = 0;
        if (lanes.size() > 0) {
            int i2 = 0;
            while (i2 < lanes.size()) {
                LaneEditPart laneEP = (LaneEditPart)lanes.get(i2);
                LaneFigure figure = laneEP.getLaneFigure();
                Rectangle symbolRectangle = GenericUtils.getSymbolRectangle((EditPart)laneEP);
                if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                    if (maxSize == 0) {
                        maxSize = symbolRectangle.height;
                    } else if (changeChildLanes == 1) {
                        if (symbolRectangle.height < maxSize) {
                            maxSize = symbolRectangle.height;
                        }
                    } else if (changeChildLanes == 2 && symbolRectangle.height > maxSize) {
                        maxSize = symbolRectangle.height;
                    }
                } else if (maxSize == 0) {
                    maxSize = symbolRectangle.width;
                } else if (changeChildLanes == 1) {
                    if (symbolRectangle.width < maxSize) {
                        maxSize = symbolRectangle.width;
                    }
                } else if (changeChildLanes == 2 && symbolRectangle.width > maxSize) {
                    maxSize = symbolRectangle.width;
                }
                if (figure.isCollapsed()) {
                    if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                        symbolRectangle.width = LaneFigure.getCollapsedSize((EditPart)laneEP);
                    } else {
                        symbolRectangle.height = LaneFigure.getCollapsedSize((EditPart)laneEP);
                    }
                }
                areaMap.put(symbolRectangle, laneEP);
                areas.add(symbolRectangle);
                ++i2;
            }
        } else {
            newSize[0] = 0;
            return null;
        }
        if (changeChildLanes == 3) {
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                if (maxSize < containerBounds.height - 2 * PoolLaneUtils.getSpace() - insets.top) {
                    maxSize = containerBounds.height - 2 * PoolLaneUtils.getSpace() - insets.top;
                } else if (maxSize > containerBounds.height - 2 * PoolLaneUtils.getSpace() - insets.top) {
                    maxSize = containerBounds.height - 2 * PoolLaneUtils.getSpace() - insets.top;
                }
                if (SnapGridUtils.getSnapToHelper(containerEP) == null) {
                    ++maxSize;
                }
            } else {
                if (maxSize < containerBounds.width - 2 * PoolLaneUtils.getSpace() - insets.left) {
                    maxSize = containerBounds.width - 2 * PoolLaneUtils.getSpace() - insets.left;
                } else if (maxSize > containerBounds.width - 2 * PoolLaneUtils.getSpace() - insets.left) {
                    maxSize = containerBounds.width - 2 * PoolLaneUtils.getSpace() - insets.left;
                }
                if (SnapGridUtils.getSnapToHelper(containerEP) == null) {
                    maxSize += 4;
                }
            }
        }
        if (PoolLaneUtils.getSpace() > 20) {
            maxSize = SnapGridUtils.getRoundSnapValue(maxSize, containerEP);
        }
        int lastPosition = PoolLaneUtils.getSpace();
        lastPosition = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (lastPosition -= insets.getWidth() / 2) : (lastPosition -= insets.getHeight() / 2);
        ((PoolLaneHelper.RectangleComparator)RECT_COMPARATOR).setOrientation(direction);
        Collections.sort(areas, RECT_COMPARATOR);
        if (areas.size() > 0) {
            int i3 = 0;
            while (i3 < areas.size()) {
                Rectangle area = (Rectangle)areas.get(i3);
                LaneEditPart laneEP = (LaneEditPart)areaMap.get(area);
                LaneFigure figure = laneEP.getLaneFigure();
                LaneSymbol symbol = laneEP.getLaneModel();
                Rectangle symbolRectangle = area.getCopy();
                Rectangle oldSize = area.getCopy();
                if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                    symbolRectangle.x = lastPosition;
                    symbolRectangle.y = PoolLaneUtils.getSpace();
                    if (PoolLaneUtils.getSpace() <= 15) {
                        symbolRectangle.y -= insets.bottom;
                    }
                    symbolRectangle.height = maxSize;
                } else {
                    symbolRectangle.y = lastPosition;
                    symbolRectangle.x = PoolLaneUtils.getSpace();
                    if (PoolLaneUtils.getSpace() <= 15) {
                        symbolRectangle.x -= insets.right;
                    }
                    symbolRectangle.width = maxSize;
                }
                ChangeConstraintCommand changeCmd = new ChangeConstraintCommand();
                changeCmd.setSnapToGrid(false);
                changeCmd.setTarget((EditPart)laneEP);
                changeCmd.setHost((EditPart)containerEP);
                changeCmd.setPart((INodeSymbol)symbol);
                lastPosition = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (lastPosition += symbolRectangle.width + PoolLaneUtils.getSpace()) : (lastPosition += symbolRectangle.height + PoolLaneUtils.getSpace());
                if (figure.isCollapsed()) {
                    if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                        symbolRectangle.width = symbol.getWidth();
                    } else {
                        symbolRectangle.height = symbol.getHeight();
                    }
                }
                Dimension currentDimension = new Dimension(symbolRectangle.width, symbolRectangle.height);
                Point currentLocation = new Point(symbolRectangle.x, symbolRectangle.y);
                symbolRectangle = SnapGridUtils.getSnapRectangle((EditPart)containerEP, (EditPart)laneEP, currentDimension, currentLocation);
                if (keepPosition) {
                    symbolRectangle.setLocation(area.x, area.y);
                }
                changeCmd.setBounds(symbolRectangle);
                cmd.add((Command)changeCmd);
                int[] newSpace = new int[]{symbolRectangle.width - oldSize.width, symbolRectangle.height - oldSize.height};
                if (newSpace[0] < 0 || newSpace[1] < 0 && PoolLaneUtils.containsOthers(laneEP)) {
                    cmd.add((Command)PoolLaneUtils.checkMoveChildren((EditPart)laneEP, newSpace));
                }
                ++i3;
            }
        }
        lastPosition = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (lastPosition += insets.getWidth() / 2) : (lastPosition += insets.getHeight() / 2);
        newSize[0] = lastPosition;
        newSize[1] = maxSize + 3 * PoolLaneUtils.getSpace();
        if (PoolLaneUtils.getSpace() <= 10) {
            newSize[1] = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? newSize[1] + PoolLaneUtils.getSpace() : newSize[1] + PoolLaneUtils.getSpace();
        }
        return cmd;
    }

    public static Command changeParentLane(AbstractSwimlaneEditPart part, int[] newSize) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)part.getModel()));
        OrientationType direction = diagram.getOrientation();
        ISwimlaneSymbol symbol = (ISwimlaneSymbol)part.getModel();
        Rectangle symbolRectangle = new Rectangle(new Long(symbol.getXPos()).intValue(), new Long(symbol.getYPos()).intValue(), symbol.getWidth(), symbol.getHeight());
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            symbolRectangle.width = newSize[0];
            symbolRectangle.height = newSize[1];
        } else {
            symbolRectangle.height = newSize[0];
            symbolRectangle.width = newSize[1];
        }
        if (symbol instanceof PoolSymbol) {
            symbolRectangle.x = 0;
            symbolRectangle.y = 0;
        }
        Rectangle snapRectangle = SnapGridUtils.getSnapRectangle(part.getParent(), (EditPart)part, symbolRectangle.getSize(), symbolRectangle.getLocation());
        ChangeConstraintCommand changeCmd = new ChangeConstraintCommand();
        changeCmd.setSnapToGrid(false);
        changeCmd.setTarget((EditPart)part);
        changeCmd.setHost(part.getParent());
        changeCmd.setPart((INodeSymbol)symbol);
        changeCmd.setBounds(snapRectangle);
        return changeCmd;
    }

    public static Command updateProcessDiagram(ISwimlaneSymbol container) {
        LaneSymbol lane;
        CompoundCommand cmd = new CompoundCommand();
        ISymbolContainer diagram = (ISymbolContainer)container;
        while (!(diagram instanceof DiagramType) && diagram.eContainer() instanceof ISymbolContainer) {
            diagram = (ISymbolContainer)diagram.eContainer();
        }
        OrientationType direction = ((DiagramType)diagram).getOrientation();
        int lastPosition = space;
        EList symbols = container.getChildLanes();
        ArrayList<LaneSymbol> lanes = new ArrayList<LaneSymbol>();
        int i = 0;
        while (i < symbols.size()) {
            lane = (LaneSymbol)symbols.get(i);
            lanes.add(lane);
            ++i;
        }
        ((LaneSymbolComparator)LANESYMBOL_COMPARATOR).setOrientation(direction);
        Collections.sort(lanes, LANESYMBOL_COMPARATOR);
        i = 0;
        while (i < lanes.size()) {
            Point location;
            lane = (LaneSymbol)lanes.get(i);
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                location = new Point(lastPosition, space);
                lastPosition += lane.getWidth() + space;
            } else {
                location = new Point(space, lastPosition);
                lastPosition += lane.getHeight() + space;
            }
            MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
            moveCommand.setPart((INodeSymbol)lane);
            moveCommand.setLocation(location);
            cmd.add((Command)moveCommand);
            FeatureMap.ValueListIterator iter = lane.getNodes().valueListIterator();
            while (iter.hasNext()) {
                Object node = iter.next();
                if (!(node instanceof INodeSymbol)) continue;
                boolean execute = false;
                Point position = new Point((double)((INodeSymbol)node).getXPos(), (double)((INodeSymbol)node).getYPos());
                if (((INodeSymbol)node).getXPos() <= (long)space) {
                    execute = true;
                    position.x = space;
                }
                if (((INodeSymbol)node).getYPos() <= (long)space) {
                    execute = true;
                    position.y = space;
                }
                if (!execute) continue;
                MoveNodeSymbolCommand moveNodeCommand = new MoveNodeSymbolCommand();
                moveNodeCommand.setPart((INodeSymbol)node);
                moveNodeCommand.setLocation(position);
                cmd.add((Command)moveNodeCommand);
            }
            ++i;
        }
        return cmd;
    }

    public static void refreshLaneContent() {
        PoolSymbol pool;
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null) {
            return;
        }
        DiagramType diagram = editor.getActiveDiagram();
        DiagramModeType actualMode = diagram.getMode();
        if (actualMode.equals((Object)DiagramModeType.MODE_450_LITERAL) && (pool = DiagramUtil.getDefaultPool((DiagramType)diagram)) != null) {
            EList lanes = pool.getLanes();
            int i = 0;
            while (i < lanes.size()) {
                LaneSymbol lane = (LaneSymbol)lanes.get(i);
                LaneEditPart editPart = (LaneEditPart)editor.findEditPart(lane);
                editPart.refreshContent();
                ++i;
            }
        }
    }

    public static class LaneSymbolComparator
    implements Comparator {
        OrientationType direction = null;

        public void setOrientation(OrientationType direction) {
            this.direction = direction;
        }

        public int compare(Object o1, Object o2) {
            long lx = ((LaneSymbol)o1).getXPos();
            long ly = ((LaneSymbol)o1).getYPos();
            long rx = ((LaneSymbol)o2).getXPos();
            long ry = ((LaneSymbol)o2).getYPos();
            if (OrientationType.VERTICAL_LITERAL.equals((Object)this.direction)) {
                if (lx != rx) {
                    return lx < rx ? -1 : 1;
                }
            } else if (ly != ry) {
                return ly < ry ? -1 : 1;
            }
            return 0;
        }
    }
}

