/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XpdlSwitch;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XsdContentProvider;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class StructContentProvider
implements ITreeContentProvider {
    private EditableXsdContentProvider xsdProvider;
    private XpdlContentProvider xpdlProvider;

    public StructContentProvider(boolean showDirectContentOnly) {
        this.xsdProvider = new EditableXsdContentProvider(showDirectContentOnly);
        this.xpdlProvider = new XpdlContentProvider();
    }

    public void setNewElement(XSDSimpleTypeDefinition parent, XSDConstrainingFacet newElement) {
        this.xsdProvider.newElements.put(parent, newElement);
    }

    public void setNewElement(XSDModelGroup parent, XSDElementDeclaration newElement) {
        this.xsdProvider.newElements.put(parent, newElement);
    }

    public void removeNewElement(XSDSimpleTypeDefinition parent) {
        this.xsdProvider.newElements.remove(parent);
    }

    public void removeNewElement(XSDModelGroup parent) {
        this.xsdProvider.newElements.remove(parent);
    }

    public XSDModelGroup getEditingParent(XSDElementDeclaration element) {
        for (Map.Entry entry : this.xsdProvider.newElements.entrySet()) {
            if (!element.equals(entry.getValue())) continue;
            return (XSDModelGroup)entry.getKey();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof EObject) {
            return (Object[])this.xpdlProvider.doSwitch((EObject)parent);
        }
        return XsdContentProvider.EMPTY_ARRAY;
    }

    private static class EditableXsdContentProvider
    extends XsdContentProvider {
        private Map<XSDComponent, XSDComponent> newElements = CollectionUtils.newMap();

        private EditableXsdContentProvider(boolean showDirectContentOnly) {
            super(showDirectContentOnly);
        }

        protected <T> T getNewItem(XSDComponent parent) {
            return (T)this.newElements.get(parent);
        }
    }

    private class XpdlContentProvider
    extends XpdlSwitch<Object> {
        private XpdlContentProvider() {
        }

        public Object caseTypeDeclarationsType(TypeDeclarationsType declarations) {
            return declarations.getTypeDeclaration().toArray();
        }

        public Object caseTypeDeclarationType(TypeDeclarationType declaration) {
            XSDNamedComponent decl = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)declaration);
            if (decl != null) {
                return StructContentProvider.this.xsdProvider.doSwitch((EObject)decl);
            }
            return XsdContentProvider.EMPTY_ARRAY;
        }

        public Object defaultCase(EObject object) {
            return StructContentProvider.this.xsdProvider.doSwitch(object);
        }
    }
}

