/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.actions.ISpiAction;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenXSDEditorAction
extends Action
implements ISpiAction {
    private IStructuredSelection selection;
    private WorkflowModelEditor editor;

    protected List<?> getSelectedObjects() {
        return this.selection instanceof IStructuredSelection ? this.selection.toList() : Collections.EMPTY_LIST;
    }

    public void setConfiguration(IConfigurationElement config, WorkflowModelEditor editor, IStructuredSelection selection) {
        this.setId(config.getAttribute("id"));
        this.setText(Structured_Messages.OpenXSDEditorAction_ActionLabel);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor((String)"icons/full/obj16/schemaView.gif"));
        this.editor = editor;
        this.selection = selection;
    }

    public boolean isEnabled() {
        Object model;
        Object selection;
        if (this.getSelectedObjects().size() == 1 && (selection = this.getSelectedObjects().get(0)) instanceof TreeEditPart && (model = ((TreeEditPart)selection).getModel()) instanceof TypeDeclarationType) {
            TypeDeclarationType decl = (TypeDeclarationType)model;
            return this.isWorkspaceSchema(decl);
        }
        return false;
    }

    private boolean isWorkspaceSchema(TypeDeclarationType decl) {
        XpdlTypeType xpdlType = decl.getDataType();
        if (xpdlType instanceof ExternalReferenceType) {
            ExternalReferenceType ref = (ExternalReferenceType)xpdlType;
            String location = ref.getLocation();
            return location != null && !location.startsWith("urn:internal:") && !location.startsWith("http://");
        }
        return false;
    }

    public void run() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    FileEditorInput input = null;
                    TreeEditPart part = (TreeEditPart)OpenXSDEditorAction.this.getSelectedObjects().get(0);
                    TypeDeclarationType decl = (TypeDeclarationType)part.getModel();
                    IProject project = WorkspaceUtils.getProjectFromEObject((EObject)decl);
                    String name = String.valueOf(decl.getId()) + ".xsd";
                    if (OpenXSDEditorAction.this.isWorkspaceSchema(decl)) {
                        ExternalReferenceType ref = decl.getExternalReference();
                        name = project.getFile(ref.getLocation()).getName();
                        IFile file = GenericUtils.getFile((IProject)project, (String)ref.getLocation());
                        if (file != null) {
                            input = new FileEditorInput(file);
                        } else {
                            MessageDialog.openError((Shell)OpenXSDEditorAction.this.editor.getSite().getShell(), (String)name, (String)Structured_Messages.OpenXSDEditorAction_FileNotFoundMessage);
                        }
                    }
                    if (input != null) {
                        OpenXSDEditorAction.this.openEditor(monitor, input, name);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.editor.getSite().getWorkbenchWindow().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)Structured_Messages.OpenXSDEditorAction_ErrorTitle, (String)realException.getMessage());
        }
    }

    private void openEditor(IProgressMonitor monitor, final IEditorInput input, final String name) {
        monitor.setTaskName(Structured_Messages.OpenXSDEditorAction_TaskName);
        this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = OpenXSDEditorAction.this.editor.getSite().getPage();
                try {
                    IContentTypeManager ctm = Platform.getContentTypeManager();
                    String tmp = "<schema></schema>";
                    IContentType ct = ctm.findContentTypeFor((InputStream)new ByteArrayInputStream(tmp.getBytes("UTF-8")), name);
                    IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
                    IEditorDescriptor editorDesc = editorReg.getDefaultEditor(name, ct);
                    page.openEditor(input, editorDesc.getId(), true);
                }
                catch (PartInitException partInitException) {
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        monitor.worked(2);
    }
}

