/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotationEditor;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotationValidator;

public class ConfigurationItem {
    private static final String EDITOR_ATTR = "editor";
    private static final String VALIDATOR_ATTR = "validator";
    private IConfigurationElement config;
    private IAnnotationEditor editor;
    private boolean editorLoaded = false;
    private IAnnotationValidator validator;
    private boolean validatorLoaded = false;
    private IStatus status;

    public ConfigurationItem(IConfigurationElement config) {
        this.config = config;
    }

    public IConfigurationElement getConfiguration() {
        return this.config;
    }

    public IAnnotationEditor getEditor() {
        if (!this.editorLoaded) {
            this.editorLoaded = true;
            if (this.config.getAttribute(EDITOR_ATTR) != null) {
                try {
                    this.editor = (IAnnotationEditor)this.config.createExecutableExtension(EDITOR_ATTR);
                }
                catch (CoreException e) {
                    DiagramPlugin.log((IStatus)e.getStatus());
                }
            }
        }
        return this.editor;
    }

    public IAnnotationValidator getValidator() {
        if (!this.validatorLoaded) {
            this.validatorLoaded = true;
            if (this.config.getAttribute(VALIDATOR_ATTR) != null) {
                try {
                    this.validator = (IAnnotationValidator)this.config.createExecutableExtension(VALIDATOR_ATTR);
                }
                catch (CoreException e) {
                    DiagramPlugin.log((IStatus)e.getStatus());
                }
            }
        }
        return this.validator;
    }

    public String getConfigurationAttribute(String name) {
        return this.config.getAttribute(name);
    }

    public IConfigurationElement[] getConfigurationChildren(String name) {
        return this.config.getChildren(name);
    }

    public String getName() {
        String name = this.getConfigurationAttribute("label");
        if (name == null) {
            name = this.getConfigurationAttribute("name");
        }
        return name;
    }

    void validate() {
        this.status = Status.OK_STATUS;
        try {
            IAnnotationValidator validator;
            if (this instanceof IAnnotation && (validator = this.getValidator()) != null) {
                this.status = validator.validate((IAnnotation)((Object)this));
            }
        }
        catch (Exception ex) {
            this.status = new Status(2, "org.eclipse.stardust.modeling.data.structured", Structured_Messages.EXC_DURING_VALIDATION, (Throwable)ex);
        }
    }

    public IStatus getValidationStatus() {
        if (this.status == null) {
            this.validate();
        }
        return this.status;
    }

    public String toString() {
        return this.getName();
    }
}

