/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.annotations.AttributeAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.ElementAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.EnumerationItem;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotationChangedListener;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotationModifier;
import org.eclipse.xsd.XSDFeature;

public class DefaultAnnotationModifier
implements IAnnotationModifier {
    private static boolean notify;
    private List<IAnnotationChangedListener> listeners = new ArrayList<IAnnotationChangedListener>();
    public static final IAnnotationModifier INSTANCE;

    static {
        INSTANCE = new DefaultAnnotationModifier();
    }

    @Override
    public boolean exists(IAnnotation annotation) {
        return annotation.exists();
    }

    @Override
    public boolean canModify(IAnnotation annotation) {
        if (annotation instanceof ElementAnnotation) {
            return "false".equals(((ElementAnnotation)annotation).getConfigurationAttribute("empty"));
        }
        return annotation instanceof AttributeAnnotation;
    }

    @Override
    public Object getValue(IAnnotation annotation) {
        return this.getValue(annotation, annotation.getElement());
    }

    @Override
    public Object getValue(IAnnotation annotation, XSDFeature element) {
        String rawValue = this.getRawValue(annotation, element);
        if (DefaultAnnotationModifier.isSelectionBased(annotation)) {
            if (rawValue != null) {
                List<Object> items = DefaultAnnotationModifier.getAnnotationAllowedValues(annotation);
                int i = 0;
                while (i < items.size()) {
                    EnumerationItem item = (EnumerationItem)items.get(i);
                    if (rawValue.equals(item.getValue())) {
                        return item;
                    }
                    ++i;
                }
            }
            return null;
        }
        return rawValue == null ? "" : rawValue;
    }

    @Override
    public void setValue(IAnnotation annotation, XSDFeature element, Object value) {
        if (value != null) {
            annotation.setRawValue(element, value.toString());
        } else {
            this.delete(annotation);
        }
    }

    private String getRawValue(IAnnotation annotation, XSDFeature element) {
        return annotation.getRawValue(element);
    }

    @Override
    public void setValue(IAnnotation annotation, Object value) {
        Object oldValue = null;
        if (DefaultAnnotationModifier.isSelectionBased(annotation)) {
            EnumerationItem item = (EnumerationItem)DefaultAnnotationModifier.getAnnotationValue(annotation);
            if (item != null) {
                oldValue = item;
            }
            item = (EnumerationItem)value;
            annotation.setRawValue(item.getValue());
        } else {
            if (DefaultAnnotationModifier.getAnnotationValue(annotation) != null) {
                oldValue = (String)DefaultAnnotationModifier.getAnnotationValue(annotation);
            }
            annotation.setRawValue((String)value);
        }
        this.fireAnnotationChanged(annotation, oldValue, value);
    }

    @Override
    public boolean delete(IAnnotation annotation) {
        this.fireAnnotationChanged(annotation, DefaultAnnotationModifier.getAnnotationValue(annotation), null);
        if (annotation instanceof ElementAnnotation) {
            return ((ElementAnnotation)annotation).delete();
        }
        if (annotation instanceof AttributeAnnotation) {
            return ((AttributeAnnotation)annotation).delete();
        }
        return false;
    }

    @Override
    public List<Object> getAllowedValues(IAnnotation annotation) {
        IConfigurationElement[] enumerations = annotation.getConfiguration().getChildren("enumeration");
        if (enumerations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> labels = new ArrayList<Object>(enumerations.length);
        boolean isBoolean = "boolean".equals(DefaultAnnotationModifier.getType(annotation));
        boolean hasTrue = false;
        boolean hasFalse = false;
        int i = 0;
        while (i < enumerations.length) {
            String name = enumerations[i].getAttribute("name");
            String value = enumerations[i].getAttribute("value");
            if (isBoolean && "true".equals(value)) {
                hasTrue = true;
            }
            if (isBoolean && "false".equals(value)) {
                hasFalse = true;
            }
            labels.add(new EnumerationItem(name, value));
            ++i;
        }
        if (isBoolean) {
            if (!hasTrue) {
                labels.add(new EnumerationItem(Structured_Messages.LBL_TRUE));
            }
            if (!hasFalse) {
                labels.add(new EnumerationItem(Structured_Messages.LBL_FALSE));
            }
        }
        return labels;
    }

    public static boolean annotationExists(IAnnotation annotation) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        return modifier == null ? INSTANCE.exists(annotation) : modifier.exists(annotation);
    }

    public static boolean canModifyAnnotation(IAnnotation annotation) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        return modifier == null ? INSTANCE.canModify(annotation) : modifier.canModify(annotation);
    }

    public static void setAnnotationValue(IAnnotation annotation, Object object) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        (modifier == null ? INSTANCE : modifier).setValue(annotation, object);
    }

    public static Object getAnnotationValue(IAnnotation annotation) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        return modifier == null ? INSTANCE.getValue(annotation) : modifier.getValue(annotation);
    }

    public static Object getAnnotationValue(IAnnotation annotation, XSDFeature element) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        return modifier == null ? INSTANCE.getValue(annotation, element) : modifier.getValue(annotation, element);
    }

    public static List<Object> getAnnotationAllowedValues(IAnnotation annotation) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        return modifier == null ? INSTANCE.getAllowedValues(annotation) : modifier.getAllowedValues(annotation);
    }

    public static boolean deleteAnnotation(IAnnotation annotation) {
        IAnnotationModifier modifier = DefaultAnnotationModifier.getModifier(annotation);
        return modifier == null ? INSTANCE.delete(annotation) : modifier.delete(annotation);
    }

    public static boolean isSelectionBased(IAnnotation annotation) {
        return !DefaultAnnotationModifier.getAnnotationAllowedValues(annotation).isEmpty();
    }

    public static IAnnotationModifier getModifier(IAnnotation annotation) {
        IAnnotation root = DefaultAnnotationModifier.getRootAnnotation(annotation);
        IConfigurationElement config = root.getConfiguration();
        if (config.getAttribute("modifier") != null) {
            try {
                return (IAnnotationModifier)config.createExecutableExtension("modifier");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IAnnotation getRootAnnotation(IAnnotation annotation) {
        while (annotation.getParent() != null) {
            annotation = annotation.getParent();
        }
        return annotation;
    }

    public static Verifier getVerifierFor(IAnnotation annotation) {
        String type = DefaultAnnotationModifier.getType(annotation);
        if ("long".equals(type)) {
            return VerifierFactory.longVerifier;
        }
        if ("double".equals(type)) {
            return VerifierFactory.doubleVerifier;
        }
        return null;
    }

    public static String getType(IAnnotation annotation) {
        return annotation.getConfiguration().getAttribute("type");
    }

    @Override
    public void addAnnotationChangedListener(IAnnotationChangedListener listener) {
        this.listeners.add(listener);
        DefaultAnnotationModifier.startNotifying();
    }

    @Override
    public void removeAnnotationChangedListener(IAnnotationChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void fireAnnotationChanged(IAnnotation annotation, Object oldValue, Object newValue) {
        if (notify) {
            for (IAnnotationChangedListener listener : this.listeners) {
                listener.annotationChanged(annotation, oldValue, newValue);
            }
        }
    }

    public static void stopNotifying() {
        notify = false;
    }

    public static void startNotifying() {
        notify = true;
    }
}

