/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.validation;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;

public class DataValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        DataType data = (DataType)element;
        if (data.getExternalReference() != null) {
            return null;
        }
        String typeId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType");
        if (StringUtils.isEmpty((String)typeId)) {
            issues.add(new Issue(2, (EObject)element, Structured_Messages.DataValidator_NoType, (Object)"carnot:engine:dataType"));
        } else {
            TypeDeclarationType type = StructuredTypeUtils.getTypeDeclaration((DataType)data);
            if (type == null) {
                String message = String.valueOf(Structured_Messages.DataValidator_InvalidType) + typeId;
                issues.add(new Issue(1, (EObject)element, message, (Object)"carnot:engine:dataType"));
            } else if (TypeDeclarationUtils.isEnumeration((TypeDeclarationType)type, (boolean)true)) {
                issues.add(new Issue(2, (EObject)element, Structured_Messages.MSG_TypeDeclarationJavaBoundEnum, (Object)"carnot:engine:dataType"));
            }
        }
        return issues.toArray(new Issue[issues.size()]);
    }
}

