/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;

public class ElementValidator {
    private static List<String> messages;

    public static List<String> validateElements(TypeDeclarationType declaration) {
        messages = new ArrayList<String>();
        XSDComplexTypeDefinition complexType = TypeDeclarationUtils.getComplexType((TypeDeclarationType)declaration);
        if (complexType != null) {
            ElementValidator.visit(complexType);
        }
        if (!messages.isEmpty()) {
            return messages;
        }
        return null;
    }

    public static void visit(XSDComplexTypeDefinition complexType) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (XSDAttributeGroupContent attribute : complexType.getAttributeContents()) {
            XSDAttributeDeclaration attr;
            String name;
            if (!(attribute instanceof XSDAttributeUse) || (name = (attr = ((XSDAttributeUse)attribute).getContent()).getName()) == null) continue;
            if (attributeNames.contains(name)) {
                messages.add(MessageFormat.format(Structured_Messages.ComplexTypePropertyPage_DuplicateFieldErrorMessage, name));
            }
            attributeNames.add(name);
        }
        ArrayList<String> names = new ArrayList<String>();
        XSDComplexTypeContent content = complexType.getContent();
        if (content instanceof XSDParticle) {
            ElementValidator.visit((XSDParticle)content);
            XSDParticleContent particleContent = ((XSDParticle)content).getContent();
            if (particleContent instanceof XSDModelGroup) {
                for (XSDParticle xsdParticle : ((XSDModelGroup)particleContent).getContents()) {
                    String name;
                    XSDParticleContent xsdParticleContent = xsdParticle.getContent();
                    if (!(xsdParticleContent instanceof XSDElementDeclaration) || (name = ((XSDElementDeclaration)xsdParticleContent).getName()) == null) continue;
                    if (names.contains(name)) {
                        messages.add(MessageFormat.format(Structured_Messages.ComplexTypePropertyPage_DuplicateFieldErrorMessage, name));
                    }
                    names.add(name);
                }
            }
        }
    }

    public static void visit(XSDParticle particle) {
        XSDParticleContent particleContent = particle.getContent();
        if (!(particleContent instanceof XSDModelGroupDefinition) && particleContent instanceof XSDTerm) {
            ElementValidator.visit((XSDTerm)particleContent);
        }
    }

    public static void visit(XSDTerm term) {
        if (term instanceof XSDElementDeclaration) {
            ElementValidator.visit((XSDElementDeclaration)term);
        } else if (term instanceof XSDModelGroup) {
            ElementValidator.visit((XSDModelGroup)term);
        }
    }

    public static void visit(XSDModelGroup group) {
        ArrayList<String> names = new ArrayList<String>();
        for (XSDParticle xsdParticle : group.getContents()) {
            String name;
            XSDParticleContent particleContent = xsdParticle.getContent();
            if (particleContent instanceof XSDElementDeclaration && (name = ((XSDElementDeclaration)particleContent).getName()) != null) {
                if (names.contains(name)) {
                    messages.add(MessageFormat.format(Structured_Messages.ComplexTypePropertyPage_DuplicateFieldErrorMessage, name));
                }
                names.add(name);
            }
            ElementValidator.visit(xsdParticle);
        }
    }

    public static void visit(XSDElementDeclaration element) {
        String name;
        XSDTypeDefinition type = element.getAnonymousTypeDefinition();
        if (type instanceof XSDComplexTypeDefinition) {
            ElementValidator.visit((XSDComplexTypeDefinition)type);
        } else if (type == null && !ElementValidator.isValidElementName(name = element.getName())) {
            messages.add(MessageFormat.format(Structured_Messages.ComplexTypePropertyPage_InvalidFieldIdentifierErrorMessage, name));
        }
    }

    public static boolean isValidElementName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        char ch = name.charAt(0);
        if (!Character.isLetter(ch) && ch != ':' && ch != '_') {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            ch = name.charAt(i);
            if (!Character.isLetter(ch) && !Character.isDigit(ch) && ch != '.' && ch != '-' && ch != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

