/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.dto.ActivityDetails;
import org.eclipse.stardust.engine.api.model.ApplicationContext;
import org.eclipse.stardust.engine.api.model.DataMapping;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IParticipant;
import org.eclipse.stardust.engine.api.model.ImplementationType;
import org.eclipse.stardust.engine.api.runtime.Service;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.api.runtime.WorkflowService;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.engine.core.runtime.beans.IUser;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.ApplicationDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.Highlightable;
import org.eclipse.stardust.modeling.debug.debugger.types.JavaTypeValueFactory;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.highlighting.IHighlightable;

public class ActivityInstanceDigest
extends AbstractJavaTypeValue
implements IHighlightable {
    private static final Logger trace = LogManager.getLogger(ActivityInstanceDigest.class);
    public static final String IMPL_TYPE_MANUAL = ImplementationType.Manual.getId();
    public static final String IMPL_TYPE_ROUTE = ImplementationType.Route.getId();
    public static final String IMPL_TYPE_APPLICATION = ImplementationType.Application.getId();
    public static final String IMPL_TYPE_SUBPROCESS = ImplementationType.SubProcess.getId();
    private long oid;
    private String activityId;
    private String activityName;
    private boolean isInteractive;
    private String implementationTypeId;
    private ProcessInstanceDigest processInstance;
    private DataMappingDigest[] dataMappings;
    private ApplicationDigest application;
    private String procDefId;
    private String performerName;
    private String userPerformerName;
    private IThread thread;

    public ActivityInstanceDigest(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = variable.getValue().getVariables();
            this.oid = DebugVariableUtils.extractAsLong("oid", subVariables);
            this.activityId = DebugVariableUtils.extractAsString("activityId", subVariables);
            this.activityName = DebugVariableUtils.extractAsString("activityName", subVariables);
            this.isInteractive = DebugVariableUtils.extractAsBoolean("isInteractive", subVariables);
            this.implementationTypeId = DebugVariableUtils.extractAsString("implementationTypeId", subVariables);
            this.initDataMappings(subVariables);
            this.application = (ApplicationDigest)JavaTypeValueFactory.createInstance("application", subVariables);
            this.procDefId = DebugVariableUtils.extractAsString("procDefId", subVariables);
            this.processInstance = (ProcessInstanceDigest)JavaTypeValueFactory.createInstance("processInstance", subVariables);
            this.performerName = DebugVariableUtils.extractAsString("performerName", subVariables);
            this.userPerformerName = DebugVariableUtils.extractAsString("userPerformerName", subVariables);
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public ActivityInstanceDigest(IActivityInstance activityInstance) {
        super(null);
        Assert.isNotNull((Object)activityInstance);
        this.oid = activityInstance.getOID();
        IModel model = (IModel)activityInstance.getActivity().getModel();
        ActivityDetails activity = new ActivityDetails(activityInstance.getActivity());
        this.activityId = String.valueOf('{') + model.getId() + '}' + activity.getId();
        this.activityName = activity.getName();
        this.isInteractive = activity.isInteractive();
        ImplementationType implType = activity.getImplementationType();
        this.implementationTypeId = implType.getId();
        ApplicationContext context = null;
        if (ImplementationType.Manual == implType) {
            context = activity.getApplicationContext("default");
        } else if (ImplementationType.Application == implType) {
            if (this.isInteractive()) {
                context = activity.getApplicationContext("jfc");
                if (context != null) {
                    this.application = new ApplicationDigest(context);
                }
            } else {
                context = activity.getApplicationContext("engine");
                this.application = new ApplicationDigest(activity.getApplication());
            }
        }
        if (context != null) {
            this.loadDataMappings(activityInstance, context);
        } else {
            this.dataMappings = new DataMappingDigest[0];
        }
        this.procDefId = String.valueOf('{') + model.getId() + '}' + activityInstance.getProcessInstance().getProcessDefinition().getId();
        this.processInstance = new ProcessInstanceDigest(activityInstance.getProcessInstance());
        IParticipant participant = activityInstance.getCurrentPerformer();
        if (participant != null) {
            this.performerName = participant.getName();
        } else {
            IUser user = activityInstance.getCurrentUserPerformer();
            if (user != null) {
                this.userPerformerName = user.getName();
            }
        }
    }

    public void updateDataMappings() {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        int idx = 0;
        while (idx < this.dataMappings.length) {
            if (this.dataMappings[idx].hasChanged()) {
                trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_DataMappingHasChanged"), this.dataMappings[idx]));
                try {
                    Serializable value = this.dataMappings[idx].getDataField().getDataHolder().getData();
                    values.put(this.dataMappings[idx].getMappingId(), value);
                }
                catch (InternalException e) {
                    trace.warn((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_FailedDeserializingOutDataValueOfMapping"), this.dataMappings[idx].getMappingId()), (Throwable)e);
                }
            } else {
                trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_DataMappingHasNotChanged"), this.dataMappings[idx]));
            }
            ++idx;
        }
        if (values.size() > 0) {
            ServiceFactory sf = (ServiceFactory)Parameters.instance().get("CARNOT.WorkflowServiceFactory");
            WorkflowService workflowService = sf.getWorkflowService();
            try {
                workflowService.activate(this.oid);
                workflowService.suspendToDefaultPerformer(this.oid, "default", values);
            }
            finally {
                sf.release((Service)workflowService);
            }
        }
    }

    public IThread getThread() {
        return this.thread;
    }

    public void setThread(IThread thread) {
        this.thread = thread;
    }

    public long getOid() {
        return this.oid;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getImplementationTypeId() {
        return this.implementationTypeId;
    }

    public ApplicationDigest getApplication() {
        return this.application;
    }

    public DataMappingDigest[] getDataMappings() {
        return this.dataMappings;
    }

    public ProcessInstanceDigest getProcessInstance() {
        return this.processInstance;
    }

    public String getPerformerName() {
        return this.performerName;
    }

    public String getUserPerformerName() {
        return this.userPerformerName;
    }

    @Override
    public String getProcessDefinitionChildId() {
        return this.activityId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.procDefId;
    }

    public String toString() {
        return MessageFormat.format(Internal_Debugger_Messages.getString("MSG_ActivityInstanceDigest_ToString"), this.oid, this.activityId, this.procDefId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActivityInstanceDigest)) {
            return false;
        }
        ActivityInstanceDigest tmp = (ActivityInstanceDigest)other;
        return CompareHelper.areEqual((Object)this.procDefId, (Object)tmp.procDefId) && CompareHelper.areEqual((Object)this.activityId, (Object)tmp.activityId);
    }

    public int hashCode() {
        return new Highlightable(this.getProcessDefinitionId(), this.getProcessDefinitionChildId()).hashCode();
    }

    private void loadDataMappings(IActivityInstance activityInstance, ApplicationContext context) {
        Map inValues;
        HashMap<String, Pair> mappings = new HashMap<String, Pair>();
        for (DataMapping mapping : context.getAllInDataMappings()) {
            mappings.put(mapping.getId(), new Pair((Object)mapping, (Object)Direction.IN));
        }
        for (DataMapping mapping : context.getAllOutDataMappings()) {
            mappings.put(mapping.getId(), mappings.containsKey(mapping.getId()) ? new Pair((Object)mapping, (Object)Direction.IN_OUT) : new Pair((Object)mapping, (Object)Direction.OUT));
        }
        ServiceFactory sf = (ServiceFactory)Parameters.instance().get("CARNOT.WorkflowServiceFactory");
        WorkflowService workflowService = sf.getWorkflowService();
        try {
            inValues = workflowService.getInDataValues(activityInstance.getOID(), context.getId(), null);
        }
        finally {
            sf.release((Service)workflowService);
        }
        int idx = 0;
        this.dataMappings = new DataMappingDigest[mappings.size()];
        for (Pair mappingPair : mappings.values()) {
            DataMapping dataMapping = (DataMapping)mappingPair.getFirst();
            this.dataMappings[idx] = new DataMappingDigest(activityInstance, dataMapping, (Direction)mappingPair.getSecond(), (Serializable)inValues.get(dataMapping.getId()));
            ++idx;
        }
    }

    private void initDataMappings(IVariable[] subVariables) {
        Object[] array = JavaTypeValueFactory.createArrayInstance("dataMappings", subVariables);
        if (array != null) {
            this.dataMappings = new DataMappingDigest[array.length];
            System.arraycopy(array, 0, this.dataMappings, 0, array.length);
        }
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }
}

