/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.model.Application;
import org.eclipse.stardust.engine.api.model.ApplicationContext;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.JavaTypeValueFactory;
import org.eclipse.stardust.modeling.debug.debugger.types.NamedValue;

public class ApplicationDigest
extends AbstractJavaTypeValue {
    private NamedValue[] properties;

    public ApplicationDigest(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = this.getAssociatedVariable().getValue().getVariables();
            Object[] result = JavaTypeValueFactory.createArrayInstance("properties", subVariables);
            if (result != null) {
                this.properties = new NamedValue[result.length];
                System.arraycopy(result, 0, this.properties, 0, result.length);
            }
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public ApplicationDigest(Application application) {
        super(null);
        Assert.isNotNull((Object)application);
        this.properties = new NamedValue[application.getAllAttributes().size()];
        int propIdx = 0;
        for (Map.Entry entry : application.getAllAttributes().entrySet()) {
            this.properties[propIdx] = new NamedValue((String)entry.getKey(), Reflect.convertObjectToString(entry.getValue()));
            ++propIdx;
        }
    }

    public ApplicationDigest(ApplicationContext applicationContext) {
        super(null);
        Assert.isNotNull((Object)applicationContext);
        this.properties = new NamedValue[applicationContext.getAllAttributes().size()];
        int propIdx = 0;
        for (Map.Entry entry : applicationContext.getAllAttributes().entrySet()) {
            this.properties[propIdx] = new NamedValue((String)entry.getKey(), Reflect.convertObjectToString(entry.getValue()));
            ++propIdx;
        }
    }

    public NamedValue[] getProperties() {
        return this.properties;
    }
}

