/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.engine.api.model.DataMapping;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.DataField;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.JavaTypeValueFactory;

public class DataMappingDigest
extends AbstractJavaTypeValue {
    private String mappingId;
    private String mappingName;
    private String mappedTypeName;
    private String direction;
    private DataField dataField;

    public DataMappingDigest(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = this.getAssociatedVariable().getValue().getVariables();
            this.mappingId = DebugVariableUtils.extractAsString("mappingId", subVariables);
            this.mappingName = DebugVariableUtils.extractAsString("mappingName", subVariables);
            this.mappedTypeName = DebugVariableUtils.extractAsString("mappedTypeName", subVariables);
            this.direction = DebugVariableUtils.extractAsString("direction", subVariables);
            this.dataField = (DataField)JavaTypeValueFactory.createInstance("dataField", subVariables);
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public DataMappingDigest(IActivityInstance activityInstance, DataMapping dataMapping, Direction direction, Serializable dataValue) {
        super(null);
        IModel model = (IModel)activityInstance.getActivity().getModel();
        this.mappingId = dataMapping.getId();
        this.mappingName = dataMapping.getName();
        this.mappedTypeName = dataValue == null ? dataMapping.getMappedType().getName() : dataValue.getClass().getName();
        this.direction = direction != null ? direction.getId() : dataMapping.getDirection().getId();
        this.dataField = new DataField(this.mappingName, this.mappedTypeName, dataValue, String.valueOf('{') + model.getId() + '}' + dataMapping.getDataId(), dataMapping.getDataPath());
    }

    public boolean supportsValueModification() {
        boolean result = Direction.IN_OUT.getId().equals(this.direction) || Direction.OUT.getId().equals(this.direction);
        return result;
    }

    public String getMappingId() {
        return this.mappingId;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public String getMappedTypeName() {
        return this.mappedTypeName;
    }

    public String getName() {
        return this.getMappingName();
    }

    public String getTypeName() {
        return this.getMappedTypeName();
    }

    public String getValue() {
        try {
            if (this.dataField != null) {
                return this.dataField.getAssociatedVariable().getValue().getValueString();
            }
            return "DataMappingDigest.getValue(): dataField == null";
        }
        catch (DebugException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void setValue(String value) {
        try {
            IJavaVariable variable = (IJavaVariable)DebugVariableUtils.findVariable("evaluatedValue", this.getAssociatedVariable().getValue().getVariables());
            this.setWritebackVariable((IVariable)variable);
            if (variable.verifyValue(value)) {
                variable.setValue(value);
            }
        }
        catch (DebugException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean hasChanged() {
        return this.dataField.hasChanged();
    }

    public DataField getDataField() {
        return this.dataField;
    }

    public DataField[] getSubFields() {
        return new DataField[]{this.dataField};
    }

    public boolean hasSubFields() {
        return true;
    }

    public String toString() {
        return MessageFormat.format(Internal_Debugger_Messages.getString("DataMappingDigest_ToString"), this.mappingId, this.dataField.getDataHolder().getData());
    }
}

