/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.spi.extensions.model.AccessPoint;
import org.eclipse.stardust.engine.core.spi.extensions.model.BridgeObject;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.DataField;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.JavaTypeValueFactory;

public class DataValueDigest
extends AbstractJavaTypeValue {
    private String dataId;
    private String dataName;
    private String dataTypeId;
    private DataField dataField;

    public DataValueDigest(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = this.getAssociatedVariable().getValue().getVariables();
            this.dataId = DebugVariableUtils.extractAsString("dataId", subVariables);
            this.dataName = DebugVariableUtils.extractAsString("dataName", subVariables);
            this.dataTypeId = DebugVariableUtils.extractAsString("dataTypeId", subVariables);
            this.dataField = (DataField)JavaTypeValueFactory.createInstance("dataField", subVariables);
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public DataValueDigest(IData data, Serializable serializedValue) {
        super(null);
        IModel model = (IModel)data.getModel();
        this.dataId = data.getId();
        this.dataName = data.getName();
        BridgeObject dvBridge = BridgeObject.getBridge((AccessPoint)data, null, (Direction)Direction.OUT, null);
        this.dataTypeId = Reflect.getAbbreviatedName((Class)dvBridge.getEndClass());
        this.dataField = new DataField(this.dataName, dvBridge.getEndClass().getName(), serializedValue, String.valueOf('{') + model.getId() + '}' + this.dataId, null);
    }

    public String getDataId() {
        return this.dataId;
    }

    public String getDataName() {
        return this.dataName;
    }

    public String getDataTypeId() {
        return this.dataTypeId;
    }

    public String getName() {
        return MessageFormat.format("{0} ({1})", this.getDataName(), this.getDataId());
    }

    public String getTypeName() {
        return this.getDataTypeId();
    }

    public String getValue() {
        try {
            if (this.dataField != null) {
                return this.dataField.getAssociatedVariable().getValue().getValueString();
            }
            return "DataMappingDigest.getValue(): dataField == null";
        }
        catch (DebugException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void setValue(String value) {
        try {
            IJavaVariable variable = (IJavaVariable)DebugVariableUtils.findVariable("evaluatedValue", this.getAssociatedVariable().getValue().getVariables());
            this.setWritebackVariable((IVariable)variable);
            if (variable.verifyValue(value)) {
                variable.setValue(value);
            }
        }
        catch (DebugException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean hasChanged() {
        return this.dataField.hasChanged();
    }

    public DataField getDataField() {
        return this.dataField;
    }

    public DataField[] getSubFields() {
        return new DataField[0];
    }

    public boolean hasSubFields() {
        return false;
    }

    public String toString() {
        return MessageFormat.format(Internal_Debugger_Messages.getString("DataValueDigest_ToString"), this.dataId, this.dataField.getDataHolder().getData());
    }
}

