/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;

public class PrimitivesFactory {
    public static Object createInstance(String typeName, String stringifiedValue) {
        Object result = null;
        Class type = Reflect.getClassFromClassName((String)typeName);
        if (!PrimitivesFactory.isSupportedType(type)) {
            throw new PublicException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_TypeIsNotSupported"), typeName));
        }
        if (Boolean.class.equals((Object)type)) {
            result = Boolean.valueOf(stringifiedValue);
        } else if (Byte.class.equals((Object)type)) {
            result = new Byte(stringifiedValue);
        } else if (Short.class.equals((Object)type)) {
            result = new Short(stringifiedValue);
        } else if (Integer.class.equals((Object)type)) {
            result = new Integer(stringifiedValue);
        } else if (Long.class.equals((Object)type)) {
            result = new Long(stringifiedValue);
        } else if (Float.class.equals((Object)type)) {
            result = new Float(stringifiedValue);
        } else if (Double.class.equals((Object)type)) {
            result = new Double(stringifiedValue);
        } else if (Character.class.equals((Object)type)) {
            result = new Character(stringifiedValue.charAt(0));
        } else if (String.class.equals((Object)type)) {
            result = stringifiedValue;
        }
        return result;
    }

    public static boolean isSupportedJavaType(Class type) {
        return Boolean.class.equals((Object)type) || Byte.class.equals((Object)type) || Short.class.equals((Object)type) || Integer.class.equals((Object)type) || Long.class.equals((Object)type) || Float.class.equals((Object)type) || Double.class.equals((Object)type) || Character.class.equals((Object)type) || String.class.equals((Object)type);
    }

    public static boolean isSupportedCarnotType(Class type) {
        return Calendar.class.isAssignableFrom(type) || Date.class.equals((Object)type);
    }

    public static boolean isSupportedType(Class type) {
        return PrimitivesFactory.isSupportedJavaType(type) || PrimitivesFactory.isSupportedCarnotType(type) || PrimitivesFactory.isSupportedStructuredType(type);
    }

    private static boolean isSupportedStructuredType(Class type) {
        return Map.class.isAssignableFrom(type) || List.class.isAssignableFrom(type);
    }

    private PrimitivesFactory() {
    }
}

