/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.dto.ProcessDefinitionDetails;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.PluggableType;
import org.eclipse.stardust.engine.api.model.ProcessDefinition;
import org.eclipse.stardust.engine.core.compatibility.el.SymbolTable;
import org.eclipse.stardust.engine.core.runtime.beans.DetailsFactory;
import org.eclipse.stardust.engine.core.runtime.beans.IDataValue;
import org.eclipse.stardust.engine.core.runtime.beans.IProcessInstance;
import org.eclipse.stardust.engine.core.runtime.beans.ProcessInstanceBean;
import org.eclipse.stardust.engine.core.spi.extensions.model.AccessPoint;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.AccessPathEvaluationContext;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.ExtendedAccessPathEvaluator;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.SpiUtils;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataValueDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.JavaTypeValueFactory;

public class ProcessInstanceDigest
extends AbstractJavaTypeValue {
    private static final Logger trace = LogManager.getLogger(ProcessInstanceDigest.class);
    private long oid;
    private String procDefId;
    private ActivityInstanceDigest startingActivityInstance;
    private DataValueDigest[] dataValues;

    public ProcessInstanceDigest(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = this.getAssociatedVariable().getValue().getVariables();
            this.oid = DebugVariableUtils.extractAsLong("oid", subVariables);
            this.procDefId = DebugVariableUtils.extractAsString("procDefId", subVariables);
            this.startingActivityInstance = (ActivityInstanceDigest)JavaTypeValueFactory.createInstance("startingActivityInstance", subVariables);
            this.initDataValues(subVariables);
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public ProcessInstanceDigest(IProcessInstance processInstance) {
        super(null);
        Assert.isNotNull((Object)processInstance);
        this.oid = processInstance.getOID();
        IModel model = (IModel)processInstance.getProcessDefinition().getModel();
        ProcessDefinition procDef = (ProcessDefinition)DetailsFactory.create((Object)processInstance.getProcessDefinition(), IProcessDefinition.class, ProcessDefinitionDetails.class);
        this.procDefId = String.valueOf('{') + model.getId() + '}' + procDef.getId();
        this.startingActivityInstance = processInstance.getStartingActivityInstance() != null ? new ActivityInstanceDigest(processInstance.getStartingActivityInstance()) : null;
        Map dataValueMap = processInstance.getExistingDataValues(false);
        List digests = CollectionUtils.newList((int)dataValueMap.size());
        for (Map.Entry entry : dataValueMap.entrySet()) {
            QName qname = QName.valueOf((String)entry.getKey());
            if (!qname.getNamespaceURI().equals(model.getId())) continue;
            IData data = model.findData(qname.getLocalPart());
            ExtendedAccessPathEvaluator evaluator = SpiUtils.createExtendedAccessPathEvaluator((PluggableType)data.getType());
            Object evaluatedValue = evaluator.evaluate((AccessPoint)data, entry.getValue(), "", new AccessPathEvaluationContext((SymbolTable)processInstance, null));
            if (trace.isDebugEnabled()) {
                trace.debug((Object)("data is " + data.getId() + " value is " + entry.getValue() + " evaluated value is " + evaluatedValue));
            }
            digests.add(new DataValueDigest(data, (Serializable)evaluatedValue));
        }
        this.dataValues = digests.toArray(new DataValueDigest[digests.size()]);
    }

    public void updateDataValues() {
        IDataValue value;
        HashMap<String, IDataValue> existingValues = new HashMap<String, IDataValue>();
        ProcessInstanceBean processInstance = ProcessInstanceBean.findByOID((long)this.oid);
        Iterator i = processInstance.getAllDataValues();
        while (i.hasNext()) {
            value = (IDataValue)i.next();
            IData data = value.getData();
            if (data.isPredefined()) continue;
            existingValues.put(data.getId(), value);
        }
        int idx = 0;
        while (idx < this.dataValues.length) {
            if (this.dataValues[idx].hasChanged() && existingValues.containsKey(this.dataValues[idx].getDataId())) {
                trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_DataValueHasChanged"), this.dataValues[idx]));
                value = (IDataValue)existingValues.get(this.dataValues[idx].getDataId());
                try {
                    value.setValue((Object)this.dataValues[idx].getDataField(), false);
                }
                catch (InternalException e) {
                    trace.warn((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_FailedDeserializingNewValueOfData"), value.getData().getId()), (Throwable)e);
                }
            } else {
                trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_DataValueHasNotChanged"), this.dataValues[idx]));
            }
            ++idx;
        }
    }

    public DataValueDigest[] getDataValues() {
        return this.dataValues;
    }

    public long getOid() {
        return this.oid;
    }

    public String getProcDefId() {
        return this.procDefId;
    }

    public ActivityInstanceDigest getStartingActivityInstance() {
        return this.startingActivityInstance;
    }

    public String toString() {
        return MessageFormat.format(Internal_Debugger_Messages.getString("MSG_ProcessInstanceDigest_ToString"), new Long(this.getOid()), this.getProcDefId());
    }

    private void initDataValues(IVariable[] subVariables) {
        Object[] array = JavaTypeValueFactory.createArrayInstance("dataValues", subVariables);
        if (array != null) {
            this.dataValues = new DataValueDigest[array.length];
            System.arraycopy(array, 0, this.dataValues, 0, array.length);
        }
    }
}

