/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.core.actions.EditDomainAwareAction;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.launching.LaunchShortcut;

public class LaunchAction
extends EditDomainAwareAction
implements IAction {
    private LaunchShortcut launcher = new LaunchShortcut();

    public LaunchAction() {
        this.setId("org.eclipse.stardust.modeling.debug");
        this.setText(Debug_Messages.LaunchAction_Name);
        this.setToolTipText(Debug_Messages.LaunchAction_ToolTip);
    }

    public boolean isEnabled() {
        if (super.isEnabled() && this.getSelectedModelElements().size() == 1) {
            EObject target = (EObject)this.getSelectedModelElements().get(0);
            return this.isInSameModel(target) && this.isLaunchable(target);
        }
        return false;
    }

    private boolean isInSameModel(EObject target) {
        return this.getModel() == this.getEditor().getWorkflowModel();
    }

    private boolean isLaunchable(EObject target) {
        return this.isProcessDefinition(target) || this.isProcessDiagram(target);
    }

    private boolean isProcessDefinition(EObject target) {
        return target instanceof ProcessDefinitionType;
    }

    private boolean isProcessDiagram(EObject target) {
        return target instanceof DiagramType && target.eContainer() instanceof ProcessDefinitionType;
    }

    public void run() {
        Object target = this.getSelectedModelElements().get(0);
        if (target instanceof ProcessDefinitionType) {
            this.launcher.launch((ProcessDefinitionType)target, "debug");
        } else if (target instanceof DiagramType) {
            this.launcher.launch((DiagramType)target, "debug");
        }
    }
}

