/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching.ui;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.debug.CwmFileSelectionDialog;
import org.eclipse.stardust.modeling.debug.DebugPlugin;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.ModelElementSelectionDialog;
import org.eclipse.stardust.modeling.debug.debugger.UiAccessor;
import org.eclipse.stardust.modeling.debug.launching.LaunchConfigUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MainTab
extends AbstractLaunchConfigurationTab {
    private Text projectText;
    private Button projectButton;
    private Text modelText;
    private Button modelButton;
    private Text processDefinitionText;
    private Button processDefinitionButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 3);
        Label programLabel = new Label(comp, 0);
        programLabel.setText(Debug_Messages.LB_Project);
        GridData gd = new GridData(1);
        programLabel.setLayoutData((Object)gd);
        programLabel.setFont(font);
        this.projectText = new Text(comp, 2052);
        gd = new GridData(768);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton(comp, Debug_Messages.LB_Browse, null);
        this.projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.browseProjects();
            }
        });
        this.createVerticalSpacer(comp, 3);
        programLabel = new Label(comp, 0);
        programLabel.setText(Debug_Messages.LB_Model);
        gd = new GridData(1);
        programLabel.setLayoutData((Object)gd);
        programLabel.setFont(font);
        this.modelText = new Text(comp, 2052);
        gd = new GridData(768);
        this.modelText.setLayoutData((Object)gd);
        this.modelText.setFont(font);
        this.modelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.modelButton = this.createPushButton(comp, Debug_Messages.LB_Browse, null);
        this.modelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.browseModelFiles();
            }
        });
        this.createVerticalSpacer(comp, 3);
        Label pdLabel = new Label(comp, 0);
        pdLabel.setText(Debug_Messages.LB_ProcessDefinition);
        gd = new GridData(1);
        pdLabel.setLayoutData((Object)gd);
        pdLabel.setFont(font);
        this.processDefinitionText = new Text(comp, 2052);
        gd = new GridData(768);
        this.processDefinitionText.setLayoutData((Object)gd);
        this.processDefinitionText.setFont(font);
        this.processDefinitionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.processDefinitionButton = this.createPushButton(comp, Debug_Messages.LB_Browse, null);
        this.processDefinitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.browseProcessDefinitions();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, configuration);
        } else {
            LaunchConfigUtils.setProjectName(configuration, "");
        }
        LaunchConfigUtils.setDefaultAttributes(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String procDef;
            String model;
            String project = LaunchConfigUtils.getProjectName(configuration);
            if (project != null) {
                this.projectText.setText(project);
            }
            if ((model = LaunchConfigUtils.getModelFileName(configuration)) != null) {
                this.modelText.setText(model);
            }
            if ((procDef = LaunchConfigUtils.getProcessDefinitionId(configuration)) != null) {
                this.processDefinitionText.setText(procDef);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        LaunchConfigUtils.setProjectName(configuration, this.projectText.getText());
        LaunchConfigUtils.setModelFileName(configuration, this.modelText.getText());
        LaunchConfigUtils.setProcessDefinitionId(configuration, this.processDefinitionText.getText());
        LaunchConfigUtils.setProgramArguments(configuration, this.projectText.getText(), this.modelText.getText(), this.processDefinitionText.getText());
    }

    public String getName() {
        return "Main";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String projectName = this.projectText.getText().trim();
        if (StringUtils.isEmpty((String)projectName)) {
            this.setErrorMessage(Debug_Messages.ERR_SpecifyProject);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            this.setErrorMessage(Debug_Messages.ERR_SpecifiedProjectDoesNotExist);
            return false;
        }
        String model = this.modelText.getText().trim();
        if (StringUtils.isEmpty((String)model)) {
            this.setErrorMessage(Debug_Messages.ERR_SpecifyModelFile);
            return false;
        }
        IResource resource = project.findMember(model);
        if (resource == null) {
            this.setErrorMessage(Debug_Messages.ERR_SpecifiedModelFileDoesNotExist);
            return false;
        }
        String pd = this.processDefinitionText.getText().trim();
        if (StringUtils.isEmpty((String)pd)) {
            this.setErrorMessage(Debug_Messages.ERR_SpecifyProcessDefinitionID);
            return false;
        }
        return super.isValid(launchConfig);
    }

    public Image getImage() {
        return DebugPlugin.getImage("icons/full/obj16/process.gif");
    }

    private IJavaElement getContext() {
        IWorkbenchWindow workbench = UiAccessor.getActiveWorkbenchWindow();
        if (workbench == null) {
            return null;
        }
        IWorkbenchPage page = workbench.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IJavaElement) {
                    return (IJavaElement)obj;
                }
                if (obj instanceof IResource) {
                    IJavaElement je = JavaCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = JavaCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input;
                if (part instanceof WorkflowModelEditor) {
                    IProject project;
                    IJavaProject je;
                    input = part.getEditorInput();
                    IFile file = (IFile)input.getAdapter(IFile.class);
                    if (file != null && (je = JavaCore.create((IProject)(project = file.getProject()))) != null) {
                        return je;
                    }
                } else {
                    input = part.getEditorInput();
                    return (IJavaElement)input.getAdapter(IJavaElement.class);
                }
            }
        }
        return null;
    }

    private void initializeJavaProject(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String name = null;
        if (javaProject != null && javaProject.exists()) {
            name = javaProject.getElementName();
        }
        LaunchConfigUtils.setProjectName(config, name);
    }

    private void browseProjects() {
        IJavaProject javaProject;
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Debug_Messages.TITLE_CarnotWorkflowModel);
        dialog.setMessage(Debug_Messages.TESTCHANGEKEY);
        dialog.setElements(projects);
        String projectName = this.projectText.getText();
        if (!StringUtils.isEmpty((String)projectName) && (javaProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            javaProject = (IJavaProject)dialog.getFirstResult();
            if (javaProject != null) {
                this.projectText.setText(javaProject.getElementName());
            } else {
                this.projectText.setText("");
            }
        }
    }

    private void browseModelFiles() {
        String projectName = this.projectText.getText();
        Assert.isNotEmpty((String)projectName, (String)Debug_Messages.TXT_ProjectHasToBeSpecified);
        CwmFileSelectionDialog dialog = new CwmFileSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), 1);
        dialog.setTitle(Debug_Messages.TITLE_CarnotWorkflowModel);
        dialog.setMessage(MessageFormat.format(Debug_Messages.MSG_SelectWorkflowModelInProject, projectName));
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            String fullPath = file.getFullPath().toString();
            this.modelText.setText(fullPath.substring(projectName.length() + 2));
        }
    }

    private void browseProcessDefinitions() {
        String projectName = this.projectText.getText();
        Assert.isNotEmpty((String)projectName, (String)Debug_Messages.TXT_ProjectHasToBeSpecified);
        String modelFileName = this.modelText.getText();
        Assert.isNotEmpty((String)modelFileName, (String)Debug_Messages.TXT_ModelFileHasToBeSpecified);
        ModelElementSelectionDialog dialog = new ModelElementSelectionDialog(this.getShell(), ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(modelFileName), new Class[]{ProcessDefinitionType.class});
        dialog.setTitle(Debug_Messages.TITLE_CarnotWorkflowModel);
        dialog.setMessage(MessageFormat.format(Debug_Messages.MSG_SelectProcessDefinitionFromModelFile, modelFileName));
        if (dialog.open() == 0) {
            Object[] modelElements = dialog.getResult();
            ProcessDefinitionType processDefinition = (ProcessDefinitionType)modelElements[0];
            this.processDefinitionText.setText(processDefinition.getId());
        }
    }
}

