/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.DateUtils;
import org.eclipse.stardust.common.Money;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataConverter;
import org.eclipse.stardust.modeling.debug.DebugPlugin;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.model.CWMStackFrame;
import org.eclipse.stardust.modeling.debug.model.IWMVariableValueEditor;
import org.eclipse.stardust.modeling.debug.model.ui.ControlGuiFactory;
import org.eclipse.stardust.modeling.debug.model.ui.DebuggerUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ManualApplicationDialog
extends Dialog {
    private final ActivityInstanceDigest ai;
    private final DataMappingDigest[] dataMappings;
    private final Map outValues = new HashMap();

    private static IWMVariableValueEditor createWmVariableValueEditor() {
        String className = "org.eclipse.stardust.modeling.debug.model.CWMVariableValueEditor";
        Bundle debuggerBundle = DebugPlugin.getContext().getBundle();
        try {
            Class valueEditorClass = debuggerBundle.loadClass(className);
            return (IWMVariableValueEditor)valueEditorClass.newInstance();
        }
        catch (Exception e) {
            throw new InternalException(MessageFormat.format(Internal_Debugger_Messages.getString("MSG_CannotInstantiateClass"), className), (Throwable)e);
        }
    }

    public ManualApplicationDialog(Shell parentShell, ActivityInstanceDigest ai, DataMappingDigest[] dataMappings) {
        super(parentShell);
        this.ai = ai;
        this.dataMappings = dataMappings;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MessageFormat.format("{0} [{1}]", this.ai.getActivityName(), this.ai.getActivityId()));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Internal_Debugger_Messages.getString("B_Complete"), true);
        this.createButton(parent, 1, Internal_Debugger_Messages.getString("B_Suspend"), false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrolled = new ScrolledComposite(composite, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 800;
        gridData.heightHint = 600;
        scrolled.setLayoutData((Object)gridData);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite panel = new Composite((Composite)scrolled, 0);
        scrolled.setContent((Control)panel);
        panel.setLayout((Layout)new GridLayout(2, false));
        int idx = 0;
        while (idx < this.dataMappings.length) {
            Label label = new Label(panel, 0);
            label.setText(this.dataMappings[idx].getMappingName());
            GridData gdLabel = new GridData(1, 2, false, false);
            gdLabel.widthHint = 150;
            label.setLayoutData((Object)gdLabel);
            JavaVariableDecorator variable = new JavaVariableDecorator((IJavaVariable)this.dataMappings[idx].getDataField().getWritebackVariable(), this.dataMappings[idx].supportsValueModification());
            try {
                ControlGuiFactory.create((IVariable)variable, this.dataMappings[idx], panel, this.outValues);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++idx;
        }
        scrolled.setMinSize(panel.computeSize(-1, -1));
        return composite;
    }

    protected void cancelPressed() {
        this.suspendActivityInstance(this.ai);
        super.cancelPressed();
    }

    protected void okPressed() {
        try {
            this.completeActivityInstance(this.ai);
        }
        catch (Exception exception) {
            try {
                this.suspendActivityInstance(this.ai);
            }
            catch (Exception exception2) {}
        }
        super.okPressed();
    }

    private void completeActivityInstance(ActivityInstanceDigest ai) {
        for (Map.Entry entry : this.outValues.entrySet()) {
            IVariable variable = (IVariable)entry.getKey();
            try {
                Object value = entry.getValue();
                if (value == null) {
                    variable.setValue(null);
                    continue;
                }
                variable.setValue(value.toString());
            }
            catch (DebugException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void suspendActivityInstance(ActivityInstanceDigest ai) {
    }

    public static void main(String[] args) {
        Display display = new Display();
        Color red = display.getSystemColor(3);
        Color blue = display.getSystemColor(9);
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        ScrolledComposite sc1 = new ScrolledComposite((Composite)shell, 512);
        final Composite c1 = new Composite((Composite)sc1, 0);
        sc1.setContent((Control)c1);
        c1.setBackground(red);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        c1.setLayout((Layout)layout);
        Button b1 = new Button(c1, 8);
        b1.setText("first button");
        c1.setSize(c1.computeSize(-1, -1));
        final ScrolledComposite sc2 = new ScrolledComposite((Composite)shell, 2816);
        sc2.setExpandHorizontal(true);
        sc2.setExpandVertical(true);
        final Composite c2 = new Composite((Composite)sc2, 0);
        sc2.setContent((Control)c2);
        c2.setBackground(blue);
        layout = new GridLayout();
        layout.numColumns = 4;
        c2.setLayout((Layout)layout);
        Button b2 = new Button(c2, 8);
        b2.setText("first button");
        sc2.setMinSize(c2.computeSize(-1, -1));
        Button add = new Button((Composite)shell, 8);
        add.setText("add children");
        final int[] index = new int[1];
        add.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                index[0] = index[0] + 1;
                Button button = new Button(c1, 8);
                button.setText("button " + index[0]);
                c1.setSize(c1.computeSize(-1, -1));
                c1.layout();
                button = new Button(c2, 8);
                button.setText("button " + index[0]);
                sc2.setMinSize(c2.computeSize(-1, -1));
                c2.layout();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private final class JavaValueDecorator
    implements IJavaValue {
        private IJavaValue value;
        private boolean supportsModification;

        public JavaValueDecorator(IJavaValue value, boolean supportsModification) {
            this.value = value;
            this.supportsModification = supportsModification;
        }

        public Object getAdapter(Class adapter) {
            return this.value.getAdapter(adapter);
        }

        public IDebugTarget getDebugTarget() {
            return this.value.getDebugTarget();
        }

        public String getGenericSignature() throws DebugException {
            return this.value.getGenericSignature();
        }

        public IJavaType getJavaType() throws DebugException {
            return this.value.getJavaType();
        }

        public ILaunch getLaunch() {
            return this.value.getLaunch();
        }

        public String getModelIdentifier() {
            return this.value.getModelIdentifier();
        }

        public String getReferenceTypeName() throws DebugException {
            return this.value.getReferenceTypeName();
        }

        public String getSignature() throws DebugException {
            return this.value.getSignature();
        }

        public String getValueString() throws DebugException {
            return this.getReadableValueString(this.value);
        }

        public IVariable[] getVariables() throws DebugException {
            IVariable[] variables = this.value.getVariables();
            JavaVariableDecorator[] decorators = new JavaVariableDecorator[variables.length];
            int idx = 0;
            while (idx < decorators.length) {
                decorators[idx] = new JavaVariableDecorator((IJavaVariable)variables[idx], this.supportsModification);
                ++idx;
            }
            return this.value.getVariables();
        }

        public boolean hasVariables() throws DebugException {
            return this.value.hasVariables();
        }

        public boolean isAllocated() throws DebugException {
            return this.value.isAllocated();
        }

        private String getReadableValueString(IJavaValue value) throws DebugException {
            StringBuffer result = new StringBuffer();
            IJavaType javaType = value.getJavaType();
            Class type = null;
            if (javaType != null && (type = Reflect.getClassFromClassName((String)javaType.getName())) != null) {
                if (String.class.equals((Object)type)) {
                    result.append(value.getValueString());
                } else if (Boolean.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsBoolean("value", value.getVariables()));
                } else if (Byte.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsLong("value", value.getVariables()));
                } else if (Short.class.isAssignableFrom(type)) {
                    result.append(DebugVariableUtils.extractAsLong("value", value.getVariables()));
                } else if (Integer.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsLong("value", value.getVariables()));
                } else if (Long.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsLong("value", value.getVariables()));
                } else if (Float.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsDouble("value", value.getVariables()));
                } else if (Double.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsDouble("value", value.getVariables()));
                } else if (Character.class.equals((Object)type)) {
                    result.append(DebugVariableUtils.extractAsString("value", value.getVariables()));
                } else if (Calendar.class.isAssignableFrom(type)) {
                    result.append(this.formatTime(DebugVariableUtils.extractAsLong("time", value.getVariables())));
                } else if (Date.class.equals((Object)type)) {
                    result.append(this.formatTime(DebugVariableUtils.extractAsLong("fastTime", value.getVariables())));
                } else {
                    Money.class.equals((Object)type);
                }
            }
            return result.toString();
        }

        private String formatTime(long l) {
            return DateUtils.getInteractiveDateFormat().format(new Date(l));
        }

        public boolean isNull() {
            return this.value == null;
        }
    }

    private final class JavaVariableDecorator
    implements IJavaVariable {
        private IJavaVariable variable;
        private boolean supportsModification;

        public JavaVariableDecorator(IJavaVariable variable, boolean supportsModification) {
            this.variable = variable;
            this.supportsModification = supportsModification;
        }

        public Object getAdapter(Class adapter) {
            return this.variable.getAdapter(adapter);
        }

        public IDebugTarget getDebugTarget() {
            return this.variable.getDebugTarget();
        }

        public String getGenericSignature() throws DebugException {
            return this.variable.getGenericSignature();
        }

        public IJavaType getJavaType() throws DebugException {
            return this.variable.getJavaType();
        }

        public ILaunch getLaunch() {
            return this.variable.getLaunch();
        }

        public String getModelIdentifier() {
            return this.variable.getModelIdentifier();
        }

        public String getName() throws DebugException {
            return this.variable.getName();
        }

        public String getReferenceTypeName() throws DebugException {
            return this.variable.getReferenceTypeName();
        }

        public String getSignature() throws DebugException {
            return this.variable.getSignature();
        }

        public IValue getValue() throws DebugException {
            return new JavaValueDecorator((IJavaValue)this.variable.getValue(), this.supportsModification);
        }

        public boolean hasValueChanged() throws DebugException {
            return this.variable.hasValueChanged();
        }

        public boolean isFinal() throws DebugException {
            return this.variable.isFinal();
        }

        public boolean isLocal() throws DebugException {
            return this.variable.isLocal();
        }

        public boolean isPackagePrivate() throws DebugException {
            return this.variable.isPackagePrivate();
        }

        public boolean isPrivate() throws DebugException {
            return this.variable.isPrivate();
        }

        public boolean isProtected() throws DebugException {
            return this.variable.isProtected();
        }

        public boolean isPublic() throws DebugException {
            return this.variable.isPublic();
        }

        public boolean isStatic() throws DebugException {
            return this.variable.isStatic();
        }

        public boolean isSynthetic() throws DebugException {
            return this.variable.isSynthetic();
        }

        public void setValue(IValue value) throws DebugException {
            this.variable.setValue(value);
        }

        public void setValue(String expression) throws DebugException {
            IWMVariableValueEditor editor = ManualApplicationDialog.createWmVariableValueEditor();
            IThread thread = ManualApplicationDialog.this.ai.getThread();
            if (thread != null) {
                IStackFrame[] stackFrames = thread.getStackFrames();
                CWMStackFrame stackFrame = null;
                int idx = stackFrames.length - 1;
                while (idx >= 0) {
                    if (stackFrames[idx] instanceof CWMStackFrame) {
                        stackFrame = (CWMStackFrame)stackFrames[idx];
                    }
                    --idx;
                }
                if (stackFrame != null) {
                    IValue value = editor.evaluate2((IJavaStackFrame)stackFrame.getJavaStackFrame(), this.getEvaluationString(expression));
                    this.variable.setValue(value);
                }
            }
        }

        public boolean supportsValueModification() {
            return this.supportsModification && this.variable.supportsValueModification();
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return this.variable.verifyValue(value);
        }

        public boolean verifyValue(String expression) throws DebugException {
            return this.variable.verifyValue(expression);
        }

        private String getEvaluationString(String value) throws DebugException {
            StringBuffer result = new StringBuffer();
            IJavaType javaType = this.variable.getJavaType();
            Class type = null;
            if (javaType != null && (type = Reflect.getClassFromClassName((String)javaType.getName())) != null) {
                if (String.class.isAssignableFrom(type)) {
                    result.append("new String(\"");
                    result.append(value);
                    result.append("\")");
                } else if (Character.class.isAssignableFrom(type)) {
                    result.append("new Character('");
                    if (StringUtils.isEmpty((String)value)) {
                        result.append(' ');
                    } else {
                        result.append(value.charAt(0));
                    }
                    result.append("')");
                } else {
                    if (Calendar.class.isAssignableFrom(type)) {
                        try {
                            if (value.indexOf(32) < 0) {
                                value = String.valueOf(value) + " 00:00:00";
                            }
                            Date date = DateUtils.getInteractiveDateFormat().parse(value);
                            result.append("java.util.Calendar result = java.util.Calendar.getInstance();");
                            result.append("result.setTime(new java.util.Date(");
                            result.append(date.getTime());
                            result.append("L));");
                            result.append("return result;");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return "";
                        }
                    }
                    if (Date.class.equals((Object)type)) {
                        try {
                            if (value.indexOf(32) < 0) {
                                value = String.valueOf(value) + " 00:00:00";
                            }
                            Date date = DateUtils.getInteractiveDateFormat().parse(value);
                            result.append("new java.util.Date(");
                            result.append(date.getTime());
                            result.append("L)");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return "";
                        }
                    }
                    if (Map.class.isAssignableFrom(type) || List.class.isAssignableFrom(type)) {
                        DataMappingDigest dataMappingDigest = this.findDataMappingDigest(this.variable.getName());
                        String dataPath = dataMappingDigest.getDataField().getDataPath();
                        if (dataPath == null) {
                            dataPath = "";
                        }
                        try {
                            IXPathMap xPathMap = DebuggerUtils.getXPathMapOfCurrentModel(dataMappingDigest.getDataField().getDeclaredTypeAdapterId());
                            StructuredDataConverter structuredDataConverter = new StructuredDataConverter(xPathMap);
                            Object o = structuredDataConverter.toCollection(value, dataPath, true);
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ObjectOutputStream objectOut = new ObjectOutputStream(out);
                            objectOut.writeObject(o);
                            objectOut.close();
                            String encodedResult = new String(Base64.encode((byte[])out.toByteArray()));
                            result.append("java.lang.String encodedResult = \"" + encodedResult + "\";");
                            result.append("byte[] encodedBytes = encodedResult.getBytes();");
                            result.append("byte[] bytes = org.eclipse.stardust.common.Base64.decode(encodedBytes);");
                            result.append("java.io.ByteArrayInputStream in = new java.io.ByteArrayInputStream(bytes);");
                            result.append("java.io.ObjectInputStream objectIn = new java.io.ObjectInputStream(in);");
                            result.append("return objectIn.readObject();");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                    if (!Money.class.equals((Object)type)) {
                        try {
                            type.getConstructor(String.class);
                            result.append("new ");
                            result.append(javaType.getName());
                            result.append("(\"");
                            result.append(value);
                            result.append("\")");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return "";
                        }
                    }
                }
            }
            return result.toString();
        }

        private DataMappingDigest findDataMappingDigest(String mappingId) {
            int i = 0;
            while (i < ManualApplicationDialog.this.dataMappings.length) {
                if (ManualApplicationDialog.this.dataMappings[i].getMappingId().equals(mappingId)) {
                    return ManualApplicationDialog.this.dataMappings[i];
                }
                ++i;
            }
            throw new RuntimeException(MessageFormat.format(Internal_Debugger_Messages.getString("MSG_DataMappingNotFound"), mappingId));
        }
    }
}

