/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model.ui;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredTreeContentProvider;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredTreeLabelProvider;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredTreeModel;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredValue;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class StructuredTree
extends TreeViewer {
    public StructuredTree(Composite parent, StructuredValue rootValue, final IXPathMap xPathMap, final boolean suportsValueModification) {
        super(parent, 67584);
        this.setLabelProvider((IBaseLabelProvider)new StructuredTreeLabelProvider());
        this.setContentProvider((IContentProvider)new StructuredTreeContentProvider(xPathMap));
        this.setInput(new StructuredTreeModel(rootValue));
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 3) {
                    return;
                }
                if (StructuredTree.this.getTree().getSelection().length != 1 || !suportsValueModification) {
                    return;
                }
                Menu popupMenu = new Menu((Control)StructuredTree.this.getTree());
                final StructuredValue selectedValue = (StructuredValue)StructuredTree.this.getTree().getSelection()[0].getData();
                for (final TypedXPath typedXPath : xPathMap.getAllXPaths()) {
                    if (!StructuredDataXPathUtils.getParentXPath((String)typedXPath.getXPath()).equals(selectedValue.getXPath().getXPath()) || !typedXPath.isList()) continue;
                    MenuItem actionItem = new MenuItem(popupMenu, 8);
                    final String elementName = StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath());
                    actionItem.setText(MessageFormat.format(Debug_Messages.BTN_AddToElement, elementName));
                    actionItem.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            Map selectedMap = (Map)selectedValue.getData();
                            LinkedList<Object> list = (LinkedList<Object>)selectedMap.get(elementName);
                            if (list == null) {
                                list = new LinkedList<Object>();
                                selectedMap.put(elementName, list);
                            }
                            if (typedXPath.getType() == -1) {
                                Object initialValue = StructuredDataXPathUtils.createInitialValue((IXPathMap)xPathMap, (String)typedXPath.getXPath(), (boolean)true);
                                if (typedXPath.isList()) {
                                    initialValue = ((List)initialValue).get(0);
                                }
                                list.add(initialValue);
                            } else {
                                list.add(null);
                            }
                            StructuredTree.this.refresh();
                        }
                    });
                }
                if (selectedValue.getXPath().isList()) {
                    MenuItem actionItem = new MenuItem(popupMenu, 8);
                    actionItem.setText(Debug_Messages.BTN_Delete);
                    actionItem.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            String elementName = StructuredDataXPathUtils.getLastXPathPart((String)selectedValue.getXPath().getXPath());
                            Map parentMap = (Map)selectedValue.getParent().getData();
                            List list = (List)parentMap.get(elementName);
                            list.remove(selectedValue.getData());
                            StructuredTree.this.refresh();
                        }
                    });
                }
                popupMenu.setVisible(true);
            }
        });
    }
}

