/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model.ui;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredTreeModel;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredValue;

public class StructuredTreeContentProvider
implements ITreeContentProvider {
    private IXPathMap xPathMap;

    public StructuredTreeContentProvider(IXPathMap xPathMap) {
        this.xPathMap = xPathMap;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private TypedXPath makeChildXPath(TypedXPath parentXPath, String childName) {
        if (StructuredDataXPathUtils.isRootXPath((String)parentXPath.getXPath())) {
            return this.xPathMap.getXPath(childName);
        }
        return this.xPathMap.getXPath(String.valueOf(parentXPath.getXPath()) + "/" + childName);
    }

    public Object[] getChildren(Object parentElement) {
        StructuredValue parentValue = (StructuredValue)parentElement;
        LinkedList<StructuredValue> childNodes = new LinkedList<StructuredValue>();
        Map parent = (Map)parentValue.getData();
        for (Map.Entry e : parent.entrySet()) {
            String childName = (String)e.getKey();
            TypedXPath childXPath = this.makeChildXPath(parentValue.getXPath(), childName);
            if (childXPath.isList()) {
                Iterator c = ((List)e.getValue()).iterator();
                while (c.hasNext()) {
                    childNodes.add(new StructuredValue(c.next(), childXPath, parentValue, this.xPathMap));
                }
                continue;
            }
            if (childXPath.getType() != -1) continue;
            childNodes.add(new StructuredValue(e.getValue(), childXPath, parentValue, this.xPathMap));
        }
        return childNodes.toArray();
    }

    public Object getParent(Object element) {
        StructuredValue value = (StructuredValue)element;
        return value.getParent();
    }

    public boolean hasChildren(Object element) {
        StructuredValue parentValue = (StructuredValue)element;
        if (parentValue.getXPath().getType() != -1) {
            return false;
        }
        Map parent = (Map)parentValue.getData();
        if (parent == null) {
            return false;
        }
        for (Map.Entry e : parent.entrySet()) {
            String childName = (String)e.getKey();
            TypedXPath childXPath = this.makeChildXPath(parentValue.getXPath(), childName);
            if (!(childXPath.isList() ? ((List)e.getValue()).size() > 0 : childXPath.getType() == -1)) continue;
            return true;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        StructuredTreeModel model = (StructuredTreeModel)inputElement;
        Object rootData = model.getStructuredValue().getData();
        if (rootData instanceof Map) {
            return new Object[]{model.getStructuredValue()};
        }
        if (rootData instanceof List) {
            LinkedList<StructuredValue> childNodes = new LinkedList<StructuredValue>();
            Iterator c = ((List)rootData).iterator();
            while (c.hasNext()) {
                childNodes.add(new StructuredValue(c.next(), model.getStructuredValue().getXPath(), null, this.xPathMap));
            }
            return childNodes.toArray();
        }
        throw new PublicException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedClass"), rootData.getClass().getName()));
    }
}

