/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.util;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public final class WorkflowModelUtils {
    private WorkflowModelUtils() {
    }

    public static List<ActivitySymbolType> getActivitySymbols(DiagramType diagram, ActivityType activity) {
        List result = CollectionUtils.newList();
        EList allSymbols = activity.getActivitySymbols();
        for (ActivitySymbolType symbol : allSymbols) {
            if (diagram != ModelUtils.findContainingDiagram((IGraphicalObject)symbol)) continue;
            result.add(symbol);
        }
        return result;
    }

    public static List getGatewaySymbols(DiagramType diagram, TransitionType transition) {
        return DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_GatewaySymbol(), (IModelElement)transition);
    }

    public static List getTransitionConnections(DiagramType diagram, TransitionType transition) {
        return DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_TransitionConnection(), (IModelElement)transition);
    }

    public static ProcessDefinitionType findProcessDefinition(ModelType model, String id) {
        return (ProcessDefinitionType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ProcessDefinition(), (String)id);
    }

    public static ActivityType findActivity(ProcessDefinitionType processDefinition, String id) {
        return (ActivityType)ModelUtils.findIdentifiableElement((EObject)processDefinition, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Activity(), (String)id);
    }
}

