/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.deploy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.error.LoginFailedException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.Inconsistency;
import org.eclipse.stardust.engine.api.runtime.DeploymentElement;
import org.eclipse.stardust.engine.api.runtime.DeploymentException;
import org.eclipse.stardust.engine.api.runtime.DeploymentOptions;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.api.runtime.ServiceFactoryLocator;
import org.eclipse.stardust.engine.cli.common.DeploymentCallback;
import org.eclipse.stardust.engine.cli.common.DeploymentUtils;
import org.eclipse.stardust.engine.core.compatibility.gui.ErrorDialog;
import org.eclipse.stardust.engine.core.model.beans.DefaultConfigurationVariablesProvider;
import org.eclipse.stardust.engine.core.model.beans.DefaultXMLReader;
import org.eclipse.stardust.engine.core.model.beans.IConfigurationVariablesProvider;
import org.eclipse.stardust.engine.core.model.parser.info.ExternalPackageInfo;
import org.eclipse.stardust.engine.core.model.parser.info.ModelInfo;
import org.eclipse.stardust.engine.core.model.parser.info.ModelInfoRetriever;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.beans.BpmRuntimeEnvironment;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.PropertyLayerProviderInterceptor;
import org.eclipse.stardust.modeling.deploy.DeployModelDialog;
import org.eclipse.stardust.modeling.deploy.DeployUtil;
import org.eclipse.stardust.modeling.deploy.Deploy_Messages;
import org.eclipse.stardust.modeling.deploy.ProgressDialog;
import org.eclipse.stardust.modeling.deploy.RuntimeUtil;

public class ModelDeploymentTool {
    private static final Logger trace = LogManager.getLogger(ModelDeploymentTool.class);
    private ServiceFactory serviceFactory;
    private static boolean version = false;
    private static String user;
    private static String password;
    private static String realm;
    private static String partition;
    private static String domain;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        trace.info((Object)Deploy_Messages.getString("MSG_Starting"));
        List modelFiles = CollectionUtils.newList();
        int i = 0;
        while (i < args.length) {
            if ("--filename".equals(args[i]) && i + 1 < args.length) {
                modelFiles.add(new File(args[++i]));
            } else if ("--filename64".equals(args[i]) && i + 1 < args.length) {
                try {
                    modelFiles.add(new File(new String(Base64.decode((byte[])args[++i].getBytes()), "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if ("--version".equals(args[i]) && i + 1 < args.length) {
                version = true;
            }
            if ("--user".equals(args[i]) && i + 1 < args.length) {
                user = new String(Base64.decode((byte[])args[++i].getBytes()));
            }
            if ("--password".equals(args[i]) && i + 1 < args.length) {
                password = new String(Base64.decode((byte[])args[++i].getBytes()));
            }
            if ("--realm".equals(args[i]) && i + 1 < args.length) {
                realm = new String(Base64.decode((byte[])args[++i].getBytes()));
            }
            if ("--domain".equals(args[i]) && i + 1 < args.length) {
                domain = new String(Base64.decode((byte[])args[++i].getBytes()));
            }
            if ("--partition".equals(args[i]) && i + 1 < args.length) {
                partition = new String(Base64.decode((byte[])args[++i].getBytes()));
            }
            ++i;
        }
        trace.info((Object)(String.valueOf(Deploy_Messages.getString("MSG_DeployModel")) + modelFiles));
        if (!modelFiles.isEmpty()) {
            new ModelDeploymentTool(modelFiles);
        } else {
            trace.error((Object)Deploy_Messages.getString("MSG_NoModelSpecified"));
        }
    }

    public ModelDeploymentTool(List<File> modelFiles) {
        ProgressDialog progress = ProgressDialog.showDialog(null, Deploy_Messages.getString("MSG_LoadingModel"), ProgressDialog.ON_CANCEL_EXIT_WITH_MINUS_ONE);
        BpmRuntimeEnvironment runtimeEnvironment = PropertyLayerProviderInterceptor.getCurrent();
        List models = CollectionUtils.newList((int)modelFiles.size());
        try {
            Map fileMap = CollectionUtils.newMap();
            Map infoMap = CollectionUtils.newMap();
            for (File file : modelFiles) {
                try {
                    ModelInfo info = ModelInfoRetriever.get((File)file);
                    infoMap.put(info.id, info);
                    fileMap.put(info.id, file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (runtimeEnvironment == null) {
                runtimeEnvironment = new BpmRuntimeEnvironment(null);
                PropertyLayerProviderInterceptor.setCurrent((BpmRuntimeEnvironment)runtimeEnvironment);
            }
            Map overrides = CollectionUtils.newMap();
            runtimeEnvironment.setModelOverrides(overrides);
            for (String modelId : this.orderModels(infoMap)) {
                DefaultConfigurationVariablesProvider confVarProvider = new DefaultConfigurationVariablesProvider();
                File file = (File)fileMap.get(modelId);
                IModel model = null;
                byte[] data = null;
                try {
                    data = DeployUtil.fileToBytes(file.getPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (file.getName().endsWith("xpdl")) {
                    String encoding = (String)Parameters.instance().getObject("carnot.engine.xml.encoding", (Object)"ISO-8859-1");
                    data = XpdlUtils.convertXpdl2Carnot((byte[])data, (String)encoding);
                }
                model = new DefaultXMLReader(false, (IConfigurationVariablesProvider)confVarProvider).importFromXML((InputStream)new ByteArrayInputStream(data));
                models.add(model);
                overrides.put(modelId, model);
            }
        }
        finally {
            progress.setVisible(false);
        }
        if (this.deployModel(modelFiles, models)) {
            JOptionPane.showMessageDialog(null, Deploy_Messages.getString("MSG_ModelDeployed"));
        } else {
            JOptionPane.showMessageDialog(null, Deploy_Messages.getString("MSG_ModelNotDeployed"));
        }
        System.exit(0);
    }

    private List<String> orderModels(Map<String, ModelInfo> infos) {
        List orderedModelIds = CollectionUtils.newList();
        Set visited = CollectionUtils.newSet();
        for (ModelInfo info : infos.values()) {
            this.addModel(orderedModelIds, info, infos, visited);
        }
        return orderedModelIds;
    }

    private void addModel(List<String> orderedModelIds, ModelInfo info, Map<String, ModelInfo> infos, Set<ModelInfo> visited) {
        if (info != null && !visited.contains(info)) {
            visited.add(info);
            if (info.externalPackages != null) {
                for (ExternalPackageInfo ref : info.externalPackages) {
                    this.addModel(orderedModelIds, infos.get(ref.href), infos, visited);
                }
            }
            orderedModelIds.add(info.id);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deployModel(List<File> modelFiles, List<IModel> models) {
        boolean deployed = false;
        try {
            try {
                this.getServiceFactory();
                if (version) {
                    try {
                        List<DeploymentElement> units = RuntimeUtil.createDeploymentElements(modelFiles);
                        DeploymentOptions options = new DeploymentOptions();
                        DeploymentUtils.deployFromFiles((ServiceFactory)this.serviceFactory, (DeploymentCallback)new DeploymentCallback(){

                            public void reportErrors(List<Inconsistency> errors) {
                            }

                            public boolean reportWarnings(List<Inconsistency> warnings) {
                                return false;
                            }
                        }, units, (DeploymentOptions)options);
                        deployed = true;
                        return deployed;
                    }
                    catch (DeploymentException e) {
                        e.printStackTrace();
                    }
                    return deployed;
                } else {
                    if (!DeployModelDialog.showDialog(this.serviceFactory, modelFiles, models, null)) return deployed;
                    deployed = true;
                    return deployed;
                }
            }
            catch (LoginFailedException e) {
                if (e.getReason() == -1) {
                    boolean bl = deployed;
                    if (this.serviceFactory == null) return bl;
                    this.serviceFactory.close();
                    return bl;
                }
                JOptionPane.showMessageDialog(null, String.valueOf(Deploy_Messages.getString("MSG_LoginFailed")) + e.getMessage());
                if (this.serviceFactory == null) return deployed;
                this.serviceFactory.close();
                return deployed;
            }
            catch (Exception x) {
                trace.warn((Object)"", (Throwable)x);
                ErrorDialog.showDialog(null, (String)"", (Throwable)x);
                if (this.serviceFactory == null) return deployed;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.serviceFactory.close();
                return deployed;
            }
        }
        finally {
            if (this.serviceFactory != null) {
                this.serviceFactory.close();
            }
        }
    }

    private synchronized void getServiceFactory() {
        if (this.serviceFactory == null || ServiceFactoryLocator.hasMultipleIdentities()) {
            if (this.serviceFactory != null) {
                this.serviceFactory.close();
            }
            if (StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)password)) {
                this.serviceFactory = ServiceFactoryLocator.get((int)1);
                return;
            }
            Map credentials = CollectionUtils.newMap();
            credentials.put("user", user);
            credentials.put("password", password);
            if (!StringUtils.isEmpty((String)domain)) {
                credentials.put("Security.Domain", domain);
            }
            if (!StringUtils.isEmpty((String)realm)) {
                credentials.put("Security.Realm", realm);
            }
            if (!StringUtils.isEmpty((String)partition)) {
                credentials.put("Security.Partition", partition);
            }
            this.serviceFactory = ServiceFactoryLocator.get((Map)credentials);
        }
    }
}

