/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.diagramexport.servlet;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.modeling.diagramexport.servlet.DiagramRenderJob;
import org.eclipse.stardust.modeling.diagramexport.servlet.ServletDiagramExporter;
import org.eclipse.stardust.modeling.diagramexport.servlet.Servlet_Messages;

public class DiagramRenderService
implements Runnable {
    private static final Logger trace = LogManager.getLogger(DiagramRenderService.class);
    private static final DiagramRenderJob SHUTDOWN = new DiagramRenderJob(null, null, null, null);
    private List jobs = new LinkedList();

    public synchronized DiagramRenderJob scheduleJob(DiagramType diagram, Map highlighting, String encoding, Integer fontSize) {
        DiagramRenderJob job = null;
        if (!this.jobs.contains(SHUTDOWN)) {
            job = new DiagramRenderJob(diagram, highlighting, encoding, fontSize);
            this.jobs.add(job);
            this.notify();
        }
        return job;
    }

    public synchronized void shutDown() {
        if (!this.jobs.contains(SHUTDOWN)) {
            this.jobs.add(SHUTDOWN);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DiagramRenderJob currentJob = null;
        do {
            Object object = this;
            synchronized (object) {
                while (true) {
                    if (!this.jobs.isEmpty()) {
                        currentJob = (DiagramRenderJob)this.jobs.remove(0);
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (SHUTDOWN == currentJob) continue;
            trace.info((Object)MessageFormat.format(Servlet_Messages.LOG_EXECUTING_RENDERJOB_FOR_DIAGRAM, currentJob.diagram));
            try {
                ServletDiagramExporter diagramExporter = new ServletDiagramExporter(currentJob.diagram, currentJob.fontSize);
                diagramExporter.setHighligteStates(currentJob.highlighting);
                currentJob.imgData = "image/png".equals(currentJob.encoding) ? diagramExporter.dumpDiagramToPNG() : ("image/gif".equals(currentJob.encoding) ? diagramExporter.dumpDiagramToGIF() : (byte[])("image/jpeg".equals(currentJob.encoding) ? diagramExporter.dumpDiagramToJPEG() : null));
            }
            catch (Throwable t) {
                currentJob.error = t;
                currentJob.imgData = null;
            }
            object = currentJob;
            synchronized (object) {
                currentJob.done = true;
                currentJob.notify();
            }
            currentJob = null;
        } while (currentJob != SHUTDOWN);
        trace.info((Object)Servlet_Messages.LOG_SHUTTING_DOWN);
    }
}

