/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.diagramexport.servlet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.ExtensionProviderUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.config.ParametersFacade;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.api.query.ActivityInstanceQuery;
import org.eclipse.stardust.engine.api.query.ActivityInstances;
import org.eclipse.stardust.engine.api.query.FilterCriterion;
import org.eclipse.stardust.engine.api.query.ProcessInstanceQuery;
import org.eclipse.stardust.engine.api.runtime.ActivityInstance;
import org.eclipse.stardust.engine.api.runtime.ActivityInstanceState;
import org.eclipse.stardust.engine.api.runtime.DeployedModelDescription;
import org.eclipse.stardust.engine.api.runtime.ProcessInstance;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.api.runtime.Service;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.api.web.ServiceFactoryLocator;
import org.eclipse.stardust.engine.api.web.ServiceFactoryProvider;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceImpl;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.highlighting.HighlightState;
import org.eclipse.stardust.modeling.diagramexport.servlet.DiagramLocator;
import org.eclipse.stardust.modeling.diagramexport.servlet.DiagramRenderService;
import org.eclipse.stardust.modeling.diagramexport.servlet.Servlet_Messages;

public class DiagramServlet
extends HttpServlet {
    private static final long serialVersionUID = 2L;
    private static final Map<Long, HighlightState> NO_HIGHLIGHTING = Collections.emptyMap();
    private static final String MISSING_MANDATORY_PARAMETER_ERROR = Servlet_Messages.DiagramServlet_EXC_EXACT_ONE_OF_THESE_PARAMETERS_IS_MANDATORY_FOR_DIAGRAM_RETRIVAL_NULL_ONE_TWO;
    public static final String INIT_PRM_CARNOT_USER = "carnotUser";
    public static final String INIT_PRM_CARNOT_PASSWORD = "carnotPassword";
    public static final String INIT_PRM_FONT_SIZE = "fontSize";
    public static final String PRM_ENCODING = "encoding";
    public static final String PRM_MODEL_VERSION = "modelVersion";
    public static final String PRM_MODEL_OID = "modelOid";
    public static final String PRM_ACTIVITY_OID = "activityInstanceOid";
    public static final String PRM_ACTIVITY_ID = "activityId";
    public static final String PRM_PROCESS_OID = "processInstanceOid";
    public static final String PRM_PROCESS_ID = "processId";
    public static final String PRM_DIAGRAM_ID = "diagramId";
    public static final String PRM_FONT_SIZE = "fontSize";
    public static final String PRM_PARTITION_ID = "partitionId";
    public static final String PRM_REALM_ID = "realmId";
    public static final String PRM_MODEL_SOURCE = "modelSource";
    public static final Integer DEFAULT_DIAGRAM_FONT_SIZE = new Integer(7);
    private static DiagramRenderService renderService;
    private Map<CacheKey, ModelType> modelsCache = CollectionUtils.newHashMap();
    private Integer fontSize = null;

    public void destroy() {
        DiagramServlet.getRenderService().shutDown();
        super.destroy();
    }

    private long getIdFromParam(String paramName, Map<?, ?> params) {
        long id = -1L;
        String param = DiagramServlet.getStringParam(paramName, params);
        try {
            id = Long.parseLong(param);
        }
        catch (Exception exception) {}
        return id;
    }

    private long getModelOid(String modelOidParam) {
        return Long.parseLong(modelOidParam);
    }

    private void validateRequired(String paramName, Map<?, ?> params) {
        String value = DiagramServlet.getStringParam(paramName, params);
        if (StringUtils.isEmpty((String)value)) {
            String message = Servlet_Messages.EXC_THE_PARAMETER_NULL_MUST_NOT_BE_EMPTY;
            throw new IllegalArgumentException(MessageFormat.format(message, paramName));
        }
    }

    private void validateNumeric(String paramName, Map<?, ?> params) {
        this.validateRequired(paramName, params);
        String message = Servlet_Messages.EXC_THE_PARAMETER_NULL_MUST_BE_NUMERIC_VALUE;
        long id = -1L;
        String param = DiagramServlet.getStringParam(paramName, params);
        try {
            id = Long.parseLong(param);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(MessageFormat.format(message, paramName));
        }
        if (id <= 0L) {
            message = String.valueOf(message) + Servlet_Messages.EXC_BIGGER_THAN_0;
            throw new IllegalArgumentException(MessageFormat.format(message, paramName));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map params = req.getParameterMap();
        this.initFontSize(params);
        String imgEncoding = DiagramServlet.getStringParam(PRM_ENCODING, params);
        if (imgEncoding == null) {
            imgEncoding = "image/png";
        }
        try {
            if (params.containsKey(PRM_ACTIVITY_OID)) {
                this.validateNumeric(PRM_ACTIVITY_OID, params);
                long aiOid = this.getIdFromParam(PRM_ACTIVITY_OID, params);
                this.generateActivityDiagram(aiOid, DiagramServlet.getStringParam(PRM_DIAGRAM_ID, params), imgEncoding, DiagramServlet.getModelSource(req), req, resp);
            } else if (params.containsKey(PRM_PROCESS_OID)) {
                this.validateNumeric(PRM_PROCESS_OID, params);
                long piOid = this.getIdFromParam(PRM_PROCESS_OID, params);
                this.generateProcessDiagram(piOid, DiagramServlet.getStringParam(PRM_ACTIVITY_ID, params), DiagramServlet.getStringParam(PRM_DIAGRAM_ID, params), imgEncoding, DiagramServlet.getModelSource(req), req, resp);
            } else if (params.containsKey(PRM_PROCESS_ID)) {
                this.validateRequired(PRM_PROCESS_ID, params);
                String processId = DiagramServlet.getStringParam(PRM_PROCESS_ID, params);
                this.validateRequired(PRM_MODEL_OID, params);
                String modelOidParam = DiagramServlet.getStringParam(PRM_MODEL_OID, params);
                long modelOid = this.getModelOid(modelOidParam);
                this.generateProcessDiagram(-1L, processId, modelOid, DiagramServlet.getStringParam(PRM_DIAGRAM_ID, params), NO_HIGHLIGHTING, imgEncoding, DiagramServlet.getModelSource(req), req, resp);
            } else {
                resp.sendError(400, MessageFormat.format(MISSING_MANDATORY_PARAMETER_ERROR, PRM_ACTIVITY_OID, PRM_PROCESS_OID, PRM_PROCESS_ID));
            }
        }
        catch (Exception x) {
            resp.sendError(400, x.getMessage());
        }
    }

    protected ServiceFactory getServiceFactory(HttpServletRequest request) {
        ServiceFactory srvcFact = null;
        List providerFactories = ExtensionProviderUtils.getExtensionProviders(ServiceFactoryProvider.Factory.class);
        for (ServiceFactoryProvider.Factory factory : providerFactories) {
            ServiceFactoryProvider provider;
            if (factory != null && (provider = factory.getServiceFactoryProvider()) != null && (srvcFact = provider.getServiceFactory(request)) != null) break;
        }
        if (srvcFact == null) {
            String realmId;
            HashMap properties = CollectionUtils.newHashMap();
            String partitionId = DiagramServlet.getStringParam(PRM_PARTITION_ID, request.getParameterMap());
            if (!StringUtils.isEmpty((String)partitionId)) {
                properties.put("Security.Partition", partitionId);
            }
            if (!StringUtils.isEmpty((String)(realmId = DiagramServlet.getStringParam(PRM_REALM_ID, request.getParameterMap())))) {
                properties.put("Security.Realm", realmId);
            }
            srvcFact = ServiceFactoryLocator.get((String)this.getInitParameter(INIT_PRM_CARNOT_USER), (String)this.getInitParameter(INIT_PRM_CARNOT_PASSWORD), (Map)properties);
        }
        return srvcFact;
    }

    private static String getXmlEncoding(String text) {
        String pattern = "encoding=\"";
        int offset = text.indexOf(pattern) + pattern.length();
        int pos = text.indexOf("\"", offset);
        return text.substring(offset, pos);
    }

    private void initFontSize(Map<?, ?> params) {
        this.fontSize = DEFAULT_DIAGRAM_FONT_SIZE;
        try {
            if (params.containsKey("fontSize")) {
                this.fontSize = new Integer(DiagramServlet.getStringParam("fontSize", params));
            } else if (!StringUtils.isEmpty((String)this.getInitParameter("fontSize"))) {
                this.fontSize = new Integer(this.getInitParameter("fontSize"));
            }
        }
        catch (Throwable throwable) {}
    }

    private void generateActivityDiagram(long activityOid, String diagramId, String encoding, String modelSource, HttpServletRequest req, HttpServletResponse resp) {
        Parameters.instance();
        try (ServiceFactory srvcFact = this.getServiceFactory(req);){
            QueryService srvcQuery = srvcFact.getQueryService();
            try {
                try {
                    ActivityInstanceQuery saiq = ActivityInstanceQuery.findAll();
                    saiq.where((FilterCriterion)ActivityInstanceQuery.OID.isEqual(activityOid));
                    ActivityInstance sai = srvcQuery.findFirstActivityInstance(saiq);
                    if (sai != null) {
                        String processId = sai.getProcessDefinitionId();
                        HashMap highlighting = CollectionUtils.newHashMap();
                        ActivityInstanceQuery aiq = ActivityInstanceQuery.findForProcessInstance((long)sai.getProcessInstanceOID());
                        ActivityInstances ais = srvcQuery.getAllActivityInstances(aiq);
                        for (ActivityInstance ai : ais) {
                            Long activityEOid = new Long(ai.getActivity().getElementOID());
                            if (!StringUtils.isEmpty((String)sai.getActivity().getId()) && CompareHelper.areEqual((Object)sai.getActivity().getId(), (Object)ai.getActivity().getId())) {
                                highlighting.put(activityEOid, HighlightState.SELECTED_LITERAL);
                            }
                            highlighting.put(activityEOid, DiagramServlet.mergeHighlighting((HighlightState)highlighting.get(activityEOid), DiagramServlet.getHighlightingFromState(ai.getState())));
                        }
                        this.generateProcessDiagram(sai.getProcessInstanceOID(), processId, -1L, diagramId, highlighting, encoding, modelSource, req, resp);
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    srvcFact.release((Service)srvcQuery);
                }
            }
            finally {
                srvcFact.release((Service)srvcQuery);
            }
        }
    }

    private void generateProcessDiagram(long processOid, String activityId, String diagramId, String encoding, String modelSource, HttpServletRequest req, HttpServletResponse resp) {
        Parameters.instance();
        try (ServiceFactory srvcFact = this.getServiceFactory(req);){
            QueryService srvcQuery = srvcFact.getQueryService();
            try {
                try {
                    ProcessInstanceQuery piq = ProcessInstanceQuery.findAll();
                    piq.where((FilterCriterion)ProcessInstanceQuery.OID.isEqual(processOid));
                    ProcessInstance pi = srvcQuery.findFirstProcessInstance(piq);
                    if (pi != null) {
                        String processId = pi.getProcessID();
                        HashMap highlighting = CollectionUtils.newHashMap();
                        ActivityInstanceQuery aiq = ActivityInstanceQuery.findForProcessInstance((long)processOid);
                        ActivityInstances ais = srvcQuery.getAllActivityInstances(aiq);
                        for (ActivityInstance ai : ais) {
                            Long activityEOid = new Long(ai.getActivity().getElementOID());
                            if (!StringUtils.isEmpty((String)activityId) && CompareHelper.areEqual((Object)activityId, (Object)ai.getActivity().getId())) {
                                highlighting.put(activityEOid, HighlightState.SELECTED_LITERAL);
                            }
                            highlighting.put(activityEOid, DiagramServlet.mergeHighlighting((HighlightState)highlighting.get(activityEOid), DiagramServlet.getHighlightingFromState(ai.getState())));
                        }
                        this.generateProcessDiagram(processOid, processId, -1L, diagramId, highlighting, encoding, modelSource, req, resp);
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    srvcFact.release((Service)srvcQuery);
                }
            }
            finally {
                srvcFact.release((Service)srvcQuery);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateProcessDiagram(long processOid, String processId, long modelOid, String diagramId, Map<Long, HighlightState> highlighting, String encoding, String modelSource, HttpServletRequest req, HttpServletResponse resp) {
        try {
            block26: {
                block25: {
                    block24: {
                        model = null;
                        if (!StringUtils.isEmpty((String)modelSource)) break block24;
                        srvcFact = this.getServiceFactory(req);
                        qSrvc = srvcFact.getQueryService();
                        if (-1L != processOid) {
                            qryPi = ProcessInstanceQuery.findAll();
                            qryPi.where((FilterCriterion)ProcessInstanceQuery.OID.isEqual(processOid));
                            try {
                                pi = qSrvc.findFirstProcessInstance(qryPi);
                                modelDescr = qSrvc.getModelDescription((long)pi.getModelOID());
                            }
                            catch (ObjectNotFoundException v0) {
                                message = Servlet_Messages.EXC_COULD_NOT_FIND_PROCESS_INSTANCE_FOR_OID;
                                throw new IllegalArgumentException(MessageFormat.format(message, new Object[]{processOid}));
                            }
                        } else {
                            modelDescr = qSrvc.getModelDescription(modelOid);
                            if (modelDescr == null) {
                                message = Servlet_Messages.EXC_COULD_NOT_FIND_MODEL_FOR_OID;
                                throw new IllegalArgumentException(MessageFormat.format(message, new Object[]{modelOid}));
                            }
                        }
                        model = this.modelsCache.get(new CacheKey(modelDescr));
                        if (model != null) break block25;
                        modelXml = qSrvc.getModelAsXML((long)modelDescr.getModelOID());
                        if (ParametersFacade.instance().getBoolean("Carnot.Engine.Deployment.XPDL", true)) {
                            modelXml = XpdlUtils.convertXpdl2Carnot((String)modelXml, (String)"UTF-8");
                        }
                        break block26;
                    }
                    manager = new WorkflowModelManager();
                    modelFile = new File(modelSource);
                    model = this.modelsCache.get(new CacheKey(modelFile));
                    if (model == null) {
                        manager.load(modelFile);
                        model = manager.getModel();
                        this.modelsCache.put(new CacheKey(modelFile), model);
                    }
                    if (model == null) {
                        throw new InternalException(MessageFormat.format(Servlet_Messages.EXC_MODEL_NULL_CANNOT_BE_LOADED, new Object[]{modelFile}));
                    }
                }
lbl39:
                // 2 sources

                while (true) {
                    block28: {
                        block27: {
                            diagram = DiagramLocator.findDiagram(model, processId, diagramId);
                            if (diagram == null) break block27;
                            job = DiagramServlet.getRenderService().scheduleJob(diagram, highlighting, encoding, this.fontSize);
                            if (job != null) {
                                var16_14 = job;
                                synchronized (var16_14) {
                                    while (true) {
                                        if (job.done) {
                                            break;
                                        }
                                        try {
                                            job.wait();
                                        }
                                        catch (InterruptedException v1) {}
                                    }
                                }
                                if (job.error != null) {
                                    throw new PublicException(Servlet_Messages.EXC_FAILED_RENDERING_DIAGRAM, job.error);
                                }
                                imgData = job.imgData;
                                break block28;
                            } else {
                                imgData = null;
                            }
                            break block28;
                        }
                        imgData = null;
                    }
                    if (imgData != null) {
                        resp.setContentType(encoding);
                        resp.setContentLength(imgData.length);
                        resp.getOutputStream().write(imgData);
                        return;
                    }
                    resp.setStatus(204);
                    return;
                }
            }
            modelXmlEncoding = DiagramServlet.getXmlEncoding(modelXml);
            resource = new CarnotWorkflowModelResourceImpl(URI.createURI((String)"http://only/a/dummy/URI"));
            options = CollectionUtils.newHashMap();
            options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            resource.load((InputStream)new ByteArrayInputStream(modelXml.getBytes(modelXmlEncoding)), (Map)options);
            l = resource.getContents();
            var22_22 = l.iterator();
            if (true) ** GOTO lbl91
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
        do {
            if (!((o = (EObject)var22_22.next()) instanceof DocumentRoot)) continue;
            model = ((DocumentRoot)o).getModel();
            break;
lbl91:
            // 2 sources

        } while (var22_22.hasNext());
        this.modelsCache.put(new CacheKey(modelDescr), model);
        ** while (true)
    }

    private static HighlightState getHighlightingFromState(ActivityInstanceState state) {
        HighlightState result = HighlightState.DEFAULT_LITERAL;
        if (state != null) {
            switch (state.getValue()) {
                case 4: 
                case 6: {
                    result = HighlightState.BROKEN_LITERAL;
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    result = HighlightState.ACTIVE_LITERAL;
                    break;
                }
                case 2: {
                    result = HighlightState.DONE_LITERAL;
                    break;
                }
                case 0: {
                    result = HighlightState.DEFAULT_LITERAL;
                    break;
                }
            }
        }
        return result;
    }

    private static HighlightState mergeHighlighting(HighlightState lhs, HighlightState rhs) {
        HighlightState[] precedence = new HighlightState[]{HighlightState.SELECTED_LITERAL, HighlightState.BROKEN_LITERAL, HighlightState.ACTIVE_LITERAL, HighlightState.DONE_LITERAL};
        HighlightState result = HighlightState.DEFAULT_LITERAL;
        int i = 0;
        while (i < precedence.length) {
            HighlightState state = precedence[i];
            if (state.equals(lhs) || state.equals(rhs)) {
                result = state;
                break;
            }
            ++i;
        }
        return result;
    }

    private static String getStringParam(String name, Map<?, ?> params) {
        String result = null;
        if (params.containsKey(name)) {
            if (params.get(name) instanceof Object[] && ((Object[])params.get(name)).length > 0 && ((Object[])params.get(name))[0] instanceof String) {
                result = (String)((Object[])params.get(name))[0];
            } else if (params.get(name) instanceof String) {
                result = (String)params.get(name);
            }
        }
        return result;
    }

    private static synchronized DiagramRenderService getRenderService() {
        if (renderService == null) {
            renderService = new DiagramRenderService();
            Thread renderThread = new Thread(renderService);
            renderThread.setDaemon(true);
            renderThread.setName(String.valueOf(DiagramRenderService.class.getName()) + "  " + renderThread.getName());
            renderThread.start();
        }
        return renderService;
    }

    private static String getModelSource(HttpServletRequest req) {
        Map params = req.getParameterMap();
        String modelSource = DiagramServlet.getStringParam(PRM_MODEL_SOURCE, params);
        if (StringUtils.isEmpty((String)modelSource)) {
            return "";
        }
        File modelSourceFile = new File(modelSource);
        if (!modelSourceFile.isAbsolute()) {
            modelSourceFile = new File(req.getSession().getServletContext().getRealPath(modelSource));
        }
        String absolutePath = modelSourceFile.getAbsolutePath();
        if (!modelSourceFile.exists()) {
            throw new ParameterException(MessageFormat.format(Servlet_Messages.EXC_PATH_NULL_FOR_MODELSOURCE_DOES_NOT_EXIST, absolutePath));
        }
        return absolutePath;
    }

    private static class CacheKey {
        private int modelOid;
        private long deploymentTime;
        private String path;

        public CacheKey(int modelOid, long deploymentTime) {
            this.modelOid = modelOid;
            this.deploymentTime = deploymentTime;
        }

        public CacheKey(DeployedModelDescription modelDescr) {
            this.modelOid = modelDescr.getModelOID();
            this.deploymentTime = modelDescr.getDeploymentTime().getTime();
        }

        public CacheKey(File modelFile) {
            this.path = modelFile.getAbsolutePath();
        }

        public boolean equals(Object other) {
            boolean isEqual;
            if (this == other) {
                isEqual = true;
            } else if (!(other instanceof CacheKey)) {
                isEqual = false;
            } else {
                CacheKey otherKey = (CacheKey)other;
                isEqual = this.modelOid == otherKey.modelOid && this.deploymentTime == otherKey.deploymentTime && (this.path != null ? this.path.equals(otherKey.path) : otherKey.path == null);
            }
            return isEqual;
        }

        public int hashCode() {
            int result = this.modelOid;
            result = 29 * result + new Long(this.deploymentTime).hashCode();
            result = 29 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }

    private static class ParameterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParameterException(String message) {
            super(message);
        }
    }
}

