/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.webservices.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.xml.sax.InputSource;

public class WsdlUtils {
    private static final String httpAuthCharEncoding = "ISO-8859-1";

    public static InputSource getInputSourceFromURI(String uri, String username, String password, Properties customProperties) throws IOException, ProtocolException, UnsupportedEncodingException {
        URL wsdlurl = null;
        try {
            wsdlurl = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            return new InputSource(uri);
        }
        if (!wsdlurl.getProtocol().startsWith("http")) {
            return new InputSource(uri);
        }
        if (WsdlUtils.getProxyAuth() == null && username == null && wsdlurl.getUserInfo() == null && (customProperties == null || customProperties.isEmpty())) {
            return new InputSource(uri);
        }
        URLConnection connection = wsdlurl.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return new InputSource(uri);
        }
        HttpURLConnection uconn = (HttpURLConnection)connection;
        String userinfo = wsdlurl.getUserInfo();
        uconn.setRequestMethod("GET");
        uconn.setAllowUserInteraction(false);
        uconn.setDefaultUseCaches(false);
        uconn.setDoInput(true);
        uconn.setDoOutput(false);
        uconn.setInstanceFollowRedirects(true);
        uconn.setUseCaches(false);
        String auth = null;
        if (userinfo != null) {
            auth = userinfo;
        } else if (username != null) {
            String string = auth = password == null ? username : String.valueOf(username) + ":" + password;
        }
        if (auth != null) {
            String authorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])auth.getBytes(httpAuthCharEncoding));
            uconn.setRequestProperty("Authorization", authorization);
        }
        if (WsdlUtils.getProxyAuth() != null) {
            String proxyAuthorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])WsdlUtils.getProxyAuth().getBytes(httpAuthCharEncoding));
            uconn.setRequestProperty("Proxy-Authorization", proxyAuthorization);
        }
        if (customProperties != null) {
            for (String string : customProperties.keySet()) {
                String value = customProperties.getProperty(string);
                uconn.setRequestProperty(string, value);
            }
        }
        uconn.connect();
        return new InputSource(uconn.getInputStream());
    }

    private static String getProxyAuth() {
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPassword = System.getProperty("http.proxyPassword");
        return proxyUser == null ? null : (proxyPassword == null ? proxyUser : String.valueOf(proxyUser) + ":" + proxyPassword);
    }
}

