/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.model.i18n.I18N_Messages;
import org.eclipse.stardust.modeling.model.i18n.properties.IPropertyModelListener;
import org.eclipse.stardust.modeling.model.i18n.properties.PropertiesList;
import org.eclipse.stardust.modeling.model.i18n.properties.PropertyValuesEditor;
import org.eclipse.stardust.modeling.model.i18n.properties.ScopedPropertyModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class I18NBundlesPropertyPage
extends AbstractModelElementPropertyPage {
    private static String MESSAGE = I18N_Messages.I18NBundlesPropertyPage_Bundle_Basename_Label;
    private PropertiesList propertiesList;
    private PropertyValuesEditor valuesEditor;
    private ScopedPropertyModel model = null;

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.propertiesList = new PropertiesList();
        this.propertiesList.createBody(composite, 1);
        ((GridData)this.propertiesList.getViewer().getTable().getLayoutData()).widthHint = FormBuilder.getTextSize((Control)parent, (int)(50 + MESSAGE.length() + 1));
        this.valuesEditor = new PropertyValuesEditor();
        this.valuesEditor.createBody(composite, 1);
        this.propertiesList.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                String selectedProperty = selection.isEmpty() ? null : (String)selection.getFirstElement();
                I18NBundlesPropertyPage.this.valuesEditor.setPropertyName(selectedProperty);
            }
        });
        return composite;
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.model.getPropertyModel().save();
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        if (this.model == null) {
            try {
                this.model = new ScopedPropertyModel((EObject)element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.model.register();
            this.propertiesList.setModel(this.model);
            this.valuesEditor.setModel(this.model);
        }
        this.propertiesList.select("Name");
        this.model.getPropertyModel().addPropertyModelListener(new IPropertyModelListener(){

            @Override
            public void localesChanged() {
                I18NBundlesPropertyPage.this.checkLocales();
            }
        });
        this.checkLocales();
    }

    private void checkLocales() {
        if (!this.model.getPropertyModel().hasLocales()) {
            this.setMessage(I18N_Messages.I18NBundlesPropertyPage_NoLanguageBundles, 1);
        } else {
            this.setMessage(null);
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.unregister();
            this.model.dispose();
        }
        super.dispose();
    }

    public ScopedPropertyModel getScopedPropertyModel() {
        return this.model;
    }

    public void apply() {
        super.apply();
        super.addDependentCommand(this.model.getPropertyModel().getCommand());
    }
}

