/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.model.i18n.Activator;
import org.eclipse.stardust.modeling.model.i18n.I18N_Messages;
import org.eclipse.stardust.modeling.model.i18n.properties.IPropertyModelListener;
import org.eclipse.stardust.modeling.model.i18n.properties.PropertyModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class LocalesList
implements IPropertyModelListener {
    private static final String NEW_LOCALE_PLACEHOLDER = "";
    private static final String[] columnProperties = new String[]{I18N_Messages.PropertyValuesEditor_NLS};
    private TableViewer viewer;
    private PropertyModel model;
    private ComboBoxCellEditor comboEditor;

    public void setModel(PropertyModel model) {
        this.model = model;
        model.addPropertyModelListener(this);
        this.localesChanged();
    }

    public void createBody(Composite composite, int span) {
        Table table = FormBuilder.createTable((Composite)composite, (int)67588, (String[])columnProperties, (int[])new int[]{100}, (int)span);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setColumnProperties(columnProperties);
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        this.comboEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), new String[0]);
        this.viewer.setCellEditors(new CellEditor[]{this.comboEditor});
    }

    @Override
    public void localesChanged() {
        List locales = CollectionUtils.newList();
        locales.addAll(this.model.getLocales());
        this.sortLocales(locales);
        this.viewer.setInput((Object)locales);
        this.viewer.add((Object)NEW_LOCALE_PLACEHOLDER);
    }

    public Locale getSelectedNLS() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Locale result = null;
        if (!selection.isEmpty() && selection.getFirstElement() instanceof Locale) {
            result = (Locale)selection.getFirstElement();
        }
        return result;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    private void sortLocales(List<? extends Object> locales) {
        Collections.sort(locales, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String c1 = o1 instanceof Locale ? ((Locale)o1).getDisplayName(Activator.getPlatformLocale()) : o1.toString();
                String c2 = o2 instanceof Locale ? ((Locale)o2).getDisplayName(Activator.getPlatformLocale()) : o2.toString();
                return c1.compareTo(c2);
            }
        });
    }

    private class CellModifier
    implements ICellModifier {
        private List<Locale> cache;
        private boolean modifying = false;

        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return LocalesList.this.model.hasSourceFolders() && property.equals(columnProperties[0]) && element == LocalesList.NEW_LOCALE_PLACEHOLDER;
        }

        public Object getValue(Object element, String property) {
            Integer result = new Integer(-1);
            if (property.equals(columnProperties[0])) {
                this.cache = CollectionUtils.newList();
                Set<Object> existing = LocalesList.this.model.getLocales();
                Locale[] all = Locale.getAvailableLocales();
                int i = 0;
                while (i < all.length) {
                    if (!existing.contains(all[i].toString()) && !existing.contains(all[i])) {
                        this.cache.add(all[i]);
                    }
                    ++i;
                }
                LocalesList.this.sortLocales(this.cache);
                List strings = CollectionUtils.newList();
                int i2 = 0;
                while (i2 < this.cache.size()) {
                    strings.add(this.cache.get(i2).getDisplayName(Activator.getPlatformLocale()));
                    ++i2;
                }
                LocalesList.this.comboEditor.setItems(strings.toArray(new String[strings.size()]));
                result = new Integer(strings.indexOf(element));
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            if (!this.modifying) {
                try {
                    int index;
                    this.modifying = true;
                    if (property.equals(columnProperties[0]) && (index = ((Integer)value).intValue()) >= 0) {
                        Locale newLocale = this.cache.get(index);
                        LocalesList.this.model.addLocale(newLocale, null);
                    }
                }
                finally {
                    this.modifying = false;
                }
            }
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != LocalesList.NEW_LOCALE_PLACEHOLDER) {
                switch (columnIndex) {
                    case 0: {
                        result = element instanceof Locale ? ((Locale)element).getDisplayName() : element.toString();
                    }
                }
            }
            return result == null ? LocalesList.NEW_LOCALE_PLACEHOLDER : result;
        }
    }
}

