/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.model.i18n.I18N_Messages;
import org.eclipse.stardust.modeling.model.i18n.properties.IPropertyModelListener;
import org.eclipse.stardust.modeling.model.i18n.properties.ScopedPropertyModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PropertyValuesEditor
implements IPropertyModelListener {
    private static final String[] columnProperties = new String[]{I18N_Messages.PropertyValuesEditor_NLS, I18N_Messages.PropertyValuesEditor_Value};
    private static final String[] updateProperties = new String[]{columnProperties[1]};
    private TableViewer viewer;
    private ScopedPropertyModel model;
    private String propertyName;
    private TextCellEditor textEditor;

    public void setModel(ScopedPropertyModel model) {
        this.model = model;
        model.getPropertyModel().addPropertyModelListener(this);
        this.localesChanged();
    }

    public void createBody(Composite composite, int span) {
        Table table = FormBuilder.createTable((Composite)composite, (int)67588, (String[])columnProperties, (int[])new int[]{25, 75}, (int)span);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setColumnProperties(columnProperties);
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        this.textEditor = new TextCellEditor((Composite)this.viewer.getTable());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.textEditor;
        this.viewer.setCellEditors(cellEditorArray);
    }

    @Override
    public void localesChanged() {
        this.viewer.setInput(this.propertyName == null ? null : this.model.getPropertyModel().getLocales());
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.localesChanged();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(columnProperties[1]) && PropertyValuesEditor.this.propertyName != null;
        }

        public Object getValue(Object element, String property) {
            Object locale;
            Object result = null;
            Object object = locale = element instanceof TableItem ? ((TableItem)element).getData() : element;
            if (property.equals(columnProperties[0])) {
                result = locale;
            }
            if (property.equals(columnProperties[1])) {
                result = PropertyValuesEditor.this.model.getProperty(locale, PropertyValuesEditor.this.propertyName);
            }
            return result == null ? "" : result;
        }

        public void modify(Object element, String property, Object value) {
            Object locale;
            Object object = locale = element instanceof TableItem ? ((TableItem)element).getData() : element;
            if (property.equals(columnProperties[1])) {
                PropertyValuesEditor.this.model.setProperty(locale, PropertyValuesEditor.this.propertyName, value.toString());
                PropertyValuesEditor.this.viewer.update(locale, updateProperties);
            }
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = element instanceof Locale ? ((Locale)element).getDisplayName() : element.toString();
                    break;
                }
                case 1: {
                    result = PropertyValuesEditor.this.model.getProperty(element, PropertyValuesEditor.this.propertyName);
                }
            }
            return result == null ? "" : result;
        }
    }
}

