/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.stardust.modeling.modelimport.FileSystemStore;

public class ModelNode {
    private String id;
    private String name;
    private String versionCount;
    private String description;
    private String validFrom;
    private String validTo;
    private String deploymentComments;
    private String deploymentTime;
    private String oid;
    private boolean released;
    private String releaseTime;
    private String version;
    private String owner;
    private ModelNode parent;
    private ArrayList versions;
    private ArrayList privateVersions;
    private FileSystemStore store;

    public ModelNode(FileSystemStore store, String id, String name, String version, String versionCount) {
        this(store, id, name, version);
        this.versionCount = versionCount;
    }

    public ModelNode(FileSystemStore store, String id, String name, String version) {
        this.store = store;
        this.id = id;
        this.name = name;
        this.version = version;
        this.versions = new ArrayList();
        this.privateVersions = new ArrayList();
    }

    public String getId() {
        return this.id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValidFrom(String validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(String validTo) {
        this.validTo = validTo;
    }

    public void setDeploymentComment(String deploymentComments) {
        this.deploymentComments = deploymentComments;
    }

    public void setDeploymentTime(String deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public void setModelOID(String oid) {
        this.oid = oid;
    }

    public void release(String releaseTime) {
        this.released = true;
        this.releaseTime = releaseTime;
    }

    public ModelNode attachPublicVersion(String id, String name, String version, String versionCount) {
        ModelNode modelnodebean = new ModelNode(this.store, id, name, version, versionCount);
        this.addToPublicVersions(modelnodebean);
        return modelnodebean;
    }

    public ModelNode attachPrivateVersion(String owner, String version) {
        ModelNode modelnodebean = new ModelNode(this.store, this.id, this.name, version);
        modelnodebean.owner = owner;
        this.addToPrivateVersions(modelnodebean);
        return modelnodebean;
    }

    private void addToPublicVersions(ModelNode modelnodebean) {
        this.versions.add(modelnodebean);
        modelnodebean.parent = this;
    }

    private void addToPrivateVersions(ModelNode modelnodebean) {
        this.privateVersions.add(modelnodebean);
        modelnodebean.parent = this;
    }

    public Iterator publicVersions() {
        return this.versions.iterator();
    }

    public String getFullVersion() {
        return this.isPrivateVersion() ? String.valueOf(this.parent.version) + "_" + this.version : this.version;
    }

    public boolean isPrivateVersion() {
        return this.owner != null;
    }

    public FileSystemStore getStore() {
        return this.store;
    }

    public String getFullName() {
        StringBuffer sb = new StringBuffer();
        if (this.name != null) {
            sb.append(this.name).append(' ');
        }
        sb.append('(').append(this.id).append(" - ");
        if (this.isPrivateVersion()) {
            sb.append(this.parent.version).append('_');
        }
        sb.append(this.version);
        sb.append(')');
        return sb.toString();
    }

    public boolean hasChildren() {
        return !this.versions.isEmpty();
    }

    public ModelNode getParent() {
        return this.parent;
    }

    public Object[] getVersions() {
        return this.versions.toArray();
    }
}

