/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortNotifier;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;
import org.eclipse.stardust.modeling.project.effort.EffortPerUnit;
import org.eclipse.stardust.modeling.project.effort.ScopedItem;

public class EffortByQuantityParameter
extends EffortNotifier
implements EffortParameter {
    private String name;
    private EffortPerUnit effortPerUnit;
    private EffortParameterScope scope;

    public EffortByQuantityParameter(EffortParameterScope scope, String name, String initializers) {
        this(scope, name);
        this.effortPerUnit = initializers == null ? new EffortPerUnit((ScopedItem)this, 0.0) : new EffortPerUnit((ScopedItem)this, initializers);
    }

    public EffortByQuantityParameter(EffortParameterScope scope, String name, double defaultValue) {
        this(scope, name);
        this.effortPerUnit = new EffortPerUnit((ScopedItem)this, defaultValue);
    }

    private EffortByQuantityParameter(EffortParameterScope scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    @Override
    public EffortParameterScope getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        if (!CompareHelper.areEqual((Object)name, (Object)oldName)) {
            this.name = name;
            this.getScope().getEffortParameters().markModified();
            this.getScope().getEffortParameters().parameterNameChanged(this, name, oldName);
            this.notifyListeners(new EffortEvent(this, "name", name, oldName));
        }
    }

    @Override
    public double[] calculateEffort(String quantityString) {
        double quantity = Double.parseDouble(quantityString);
        double[] result = this.effortPerUnit.getEffort();
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] * quantity;
        }
        return result;
    }

    public EffortPerUnit getEffortPerUnit() {
        return this.effortPerUnit;
    }

    @Override
    public String getType() {
        return "ByQuantityParameter";
    }

    @Override
    public String getInitializers() {
        return this.effortPerUnit.getInitializer();
    }

    public String toString() {
        return this.getName();
    }
}

