/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import org.eclipse.stardust.modeling.project.Project_Messages;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;

public class EffortEntry {
    private EffortParameterScope scope;
    private String name;
    private String costDriver;
    private String valueString;
    private double[] effort;

    public EffortEntry(EffortParameterScope scope, String name, String costDriver, String valueString) {
        this.scope = scope;
        this.name = name;
        this.costDriver = costDriver;
        EffortParameter effortParameter = scope.getParameter(costDriver);
        this.valueString = valueString;
        this.effort = effortParameter.calculateEffort(valueString);
    }

    public String getCostDriver() {
        return this.costDriver;
    }

    public String getName() {
        return this.name;
    }

    public String getValueString() {
        return this.valueString;
    }

    public double[] getEffort() {
        return this.effort;
    }

    public EffortParameterScope getScope() {
        return this.scope;
    }

    public String getSimpleName() {
        return Project_Messages.getString(this.getScope().getSimpleName());
    }
}

