/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.EObjectStringValueSubstituteChange;

public class DataMappingOperator
implements IJdtOperator {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        String originalClassName = null;
        String newClassName = null;
        if (element instanceof IType) {
            originalClassName = ((IType)element).getFullyQualifiedName();
            newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
            if (newClassName.equals(originalClassName)) {
                return Collections.EMPTY_LIST;
            }
        }
        String originalMethodName = null;
        String newMethodName = null;
        if (element instanceof IMethod) {
            originalMethodName = ((IMethod)element).getElementName();
            newMethodName = OperatorsRegistry.getNewMethodName((IMethod)element, arguments);
            if (newMethodName.equals(originalMethodName)) {
                return Collections.EMPTY_LIST;
            }
        }
        if (newClassName == null && newMethodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList processTypes = model.getProcessDefinition();
        int i = 0;
        while (i < processTypes.size()) {
            ProcessDefinitionType process = (ProcessDefinitionType)processTypes.get(i);
            EList activities = process.getActivity();
            int j = 0;
            while (j < activities.size()) {
                ActivityType activity = (ActivityType)activities.get(j);
                EList dataMappings = activity.getDataMapping();
                int k = 0;
                while (k < dataMappings.size()) {
                    DataMappingType mapping = (DataMappingType)dataMappings.get(k);
                    if (DirectionType.OUT_LITERAL.equals((Object)mapping.getDirection())) {
                        if (this.isJavaType(mapping.getData())) {
                            if (element instanceof IType) {
                                EObjectStringValueSubstituteChange.addParamsSubstitution(result, CWM_PKG.getDataMappingType_DataPath().getName(), (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_DataPath(), originalClassName, newClassName);
                            } else if (element instanceof IMethod) {
                                EObjectStringValueSubstituteChange.addMethodSubstitution(result, CWM_PKG.getDataMappingType_DataPath().getName(), (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_DataPath(), originalMethodName, newMethodName);
                            }
                        }
                    } else if (DirectionType.IN_LITERAL.equals((Object)mapping.getDirection())) {
                        boolean isJavaApp = this.isJavaApplication(mapping);
                        if (isJavaApp) {
                            if (element instanceof IType) {
                                EObjectStringValueSubstituteChange.addParamsSubstitution(result, CWM_PKG.getDataMappingType_ApplicationAccessPoint().getName(), (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationAccessPoint(), originalClassName, newClassName);
                            } else if (element instanceof IMethod) {
                                EObjectStringValueSubstituteChange.addMethodSubstitution(result, CWM_PKG.getDataMappingType_ApplicationAccessPoint().getName(), (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationAccessPoint(), originalMethodName, newMethodName);
                            }
                        }
                        if (isJavaApp || this.isJavaAccessPoint(mapping)) {
                            if (element instanceof IType) {
                                EObjectStringValueSubstituteChange.addParamsSubstitution(result, CWM_PKG.getDataMappingType_ApplicationPath().getName(), (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationPath(), originalClassName, newClassName);
                            } else if (element instanceof IMethod) {
                                EObjectStringValueSubstituteChange.addMethodSubstitution(result, CWM_PKG.getDataMappingType_ApplicationPath().getName(), (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationPath(), originalMethodName, newMethodName);
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        String className = null;
        if (element instanceof IType) {
            className = ((IType)element).getFullyQualifiedName();
        }
        String methodName = null;
        if (element instanceof IMethod) {
            methodName = ((IMethod)element).getElementName();
        }
        if (className == null && methodName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        EList processTypes = model.getProcessDefinition();
        int i = 0;
        while (i < processTypes.size()) {
            ProcessDefinitionType process = (ProcessDefinitionType)processTypes.get(i);
            EList activities = process.getActivity();
            int j = 0;
            while (j < activities.size()) {
                ActivityType activity = (ActivityType)activities.get(j);
                EList dataMappings = activity.getDataMapping();
                int k = 0;
                while (k < dataMappings.size()) {
                    DataMappingType mapping = (DataMappingType)dataMappings.get(k);
                    if (DirectionType.OUT_LITERAL.equals((Object)mapping.getDirection())) {
                        if (this.isJavaType(mapping.getData())) {
                            if (element instanceof IType) {
                                EObjectMatch.addParamsMatch(result, file, (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_DataPath(), className);
                            } else if (element instanceof IMethod) {
                                EObjectMatch.addMethodMatch(result, file, (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_DataPath(), methodName);
                            }
                        }
                    } else if (DirectionType.IN_LITERAL.equals((Object)mapping.getDirection())) {
                        boolean isJavaApp = this.isJavaApplication(mapping);
                        if (isJavaApp) {
                            if (element instanceof IType) {
                                EObjectMatch.addParamsMatch(result, file, (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationAccessPoint(), className);
                            } else if (element instanceof IMethod) {
                                EObjectMatch.addMethodMatch(result, file, (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationAccessPoint(), methodName);
                            }
                        }
                        if (isJavaApp || this.isJavaAccessPoint(mapping)) {
                            if (element instanceof IType) {
                                EObjectMatch.addParamsMatch(result, file, (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationPath(), className);
                            } else if (element instanceof IMethod) {
                                EObjectMatch.addMethodMatch(result, file, (EObject)mapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationPath(), methodName);
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private boolean isJavaAccessPoint(DataMappingType mapping) {
        String apId = mapping.getApplicationAccessPoint();
        if (apId != null && apId.length() > 0) {
            ActivityType activity = (ActivityType)mapping.eContainer();
            List inAccessPoints = ActivityUtil.getExplicitAccessPoints((ActivityType)activity, (boolean)true, (String)mapping.getContext());
            int i = 0;
            while (i < inAccessPoints.size()) {
                AccessPointType ap = (AccessPointType)inAccessPoints.get(i);
                if (ap.getId().equals(apId)) {
                    DataTypeType type = ap.getType();
                    String id = type.getId();
                    return "serializable".equals(id) || "entity".equals(id) || "primitive".equals(id);
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isJavaApplication(DataMappingType mapping) {
        ApplicationType application;
        boolean isJavaApplication = false;
        ActivityType activity = (ActivityType)mapping.eContainer();
        if (ActivityUtil.isApplicationActivity((ActivityType)activity) && (application = activity.getApplication()) != null) {
            ApplicationTypeType type;
            isJavaApplication = application.isInteractive() ? "Casabac".equals(mapping.getContext()) || "jfc".equals(mapping.getContext()) : "plainJava".equals((type = application.getType()).getId()) || "sessionBean".equals(type.getId());
        }
        return isJavaApplication;
    }

    private boolean isJavaType(DataType data) {
        if (data != null) {
            DataTypeType type = data.getType();
            String id = type.getId();
            return "serializable".equals(id) || "entity".equals(id) || "primitive".equals(id) || "hibernate".equals(id);
        }
        return false;
    }
}

