/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.filters;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.modeling.repository.common.IFilter;

public class IdentifiableModelElementFilter
implements IFilter {
    private EClass[] objectTypes;
    private String idPattern;
    private String namePattern;

    public IdentifiableModelElementFilter(EClass[] objectTypes, String idPattern, String namePattern) {
        this.objectTypes = objectTypes;
        this.idPattern = idPattern;
        this.namePattern = namePattern;
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof IIdentifiableModelElement) {
            IIdentifiableModelElement element = (IIdentifiableModelElement)object;
            return this.matchesTypes(element.eClass()) && this.matchesPattern(this.idPattern, element.getId()) && this.matchesPattern(this.namePattern, element.getName());
        }
        if (object instanceof IObjectReference) {
            IObjectReference element = (IObjectReference)object;
            return this.matchesTypes((EClass)element.getType()) && this.matchesPattern(this.idPattern, element.getId()) && this.matchesPattern(this.namePattern, element.getName());
        }
        return false;
    }

    private boolean matchesTypes(EClass element) {
        if (this.objectTypes != null && this.objectTypes.length > 0) {
            int i = 0;
            while (i < this.objectTypes.length) {
                if (this.objectTypes[i] != null && this.objectTypes[i].equals(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean matchesPattern(String pattern, String value) {
        return value.indexOf(pattern) >= 0;
    }
}

