/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.stardust.engine.core.javascript.StructuredDataMapAccessor;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.engine.core.struct.Utils;
import org.eclipse.stardust.modeling.transformation.debug.WatchExpressionDelegate;
import org.eclipse.stardust.modeling.transformation.debug.model.AbstractVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.JsValue;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataListVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataMapVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataPrimitiveValue;

public class StructuredDataPrimitiveVariable
extends AbstractVariable {
    private final StructuredDataMapAccessor accessor;
    private final TypedXPath typedXPath;
    private final String name;
    private final JsStackFrame stackFrame;
    private StructuredDataPrimitiveValue value;

    public StructuredDataPrimitiveVariable(JsStackFrame stackFrame, AbstractVariable parent, String name, StructuredDataMapAccessor accessor) {
        this(stackFrame, parent, name, accessor, accessor.getXPath());
    }

    public StructuredDataPrimitiveVariable(JsStackFrame stackFrame, AbstractVariable parent, String name, StructuredDataMapAccessor accessor, TypedXPath typedXPath) {
        super(stackFrame, parent);
        this.accessor = accessor;
        this.typedXPath = typedXPath;
        this.name = name;
        this.stackFrame = stackFrame;
        this.value = new StructuredDataPrimitiveValue(this);
    }

    public JsStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public StructuredDataMapAccessor getAccessor() {
        return this.accessor;
    }

    public TypedXPath getTypedXPath() {
        return this.typedXPath;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getTypedXPath().getXsdTypeName();
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public void setValue(String expression) throws DebugException {
        IWatchExpressionResult result;
        StringBuffer buffer = new StringBuffer();
        AbstractVariable parent = this.getParent();
        if (parent instanceof StructuredDataMapVariable) {
            buffer.append("[\"").append(this.name).append("\"]");
        } else {
            buffer.append(this.name);
        }
        while (parent != null) {
            if (!(parent instanceof StructuredDataMapVariable) && !(parent instanceof StructuredDataListVariable)) {
                buffer.insert(0, ".");
            }
            buffer.insert(0, parent.getQualifiedName());
            parent = parent.getParent();
        }
        buffer.append(" = ").append(expression);
        if (this.verifyValue(buffer.toString()) && !(result = WatchExpressionDelegate.evaluateExpression(buffer.toString(), this.getFrame())).hasErrors()) {
            IValue rawValue = result.getValue();
            if (rawValue instanceof JsValue) {
                JsValue jsValue = (JsValue)rawValue;
                if (this.isCompatible(jsValue)) {
                    this.hasChanged = true;
                    this.fireChangeEvent(512);
                }
            } else if (rawValue instanceof StructuredDataPrimitiveValue) {
                this.value = (StructuredDataPrimitiveValue)rawValue;
                this.hasChanged = true;
                this.fireChangeEvent(512);
            }
        }
    }

    private boolean isCompatible(JsValue jsValue) {
        Object rawValue;
        Class currentType = Utils.getJavaTypeForTypedXPath((TypedXPath)this.typedXPath);
        return currentType.isAssignableFrom((rawValue = jsValue.getRawValue()).getClass());
    }
}

