/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.launch;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.extensions.transformation.format.IMessageFormat;
import org.eclipse.stardust.engine.extensions.transformation.format.ParsingException;
import org.eclipse.stardust.engine.extensions.transformation.format.SerializationException;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.transformation.messaging.format.FormatManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;

public class ProcessingLaunchDelegate
extends LaunchConfigurationDelegate {
    private String sourceFormat;
    private FileInputStream fis;
    private Document schemaDocument;
    private String targetFormat;

    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ModelType model;
        ILaunchManager launchManager;
        block17: {
            launchManager = DebugPlugin.getDefault().getLaunchManager();
            String modelUri = configuration.getAttribute("modelUri", "");
            model = null;
            try {
                model = this.loadModel(modelUri);
            }
            catch (Exception e) {
                if (!(e instanceof PublicException) || e.getCause() instanceof TransformerException) break block17;
                throw new RuntimeException(Modeling_Messages.EXC_MD_COULD_NOT_LOD, e);
            }
        }
        if (model != null) {
            MessageConsole myConsole = new MessageConsole(Modeling_Messages.MSG_OP_CSL, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{myConsole});
            MessageConsoleStream msgStream = myConsole.newMessageStream();
            Document sourceDoc = null;
            String inputFileName = configuration.getAttribute("sourceFilePath", null);
            try {
                this.fis = new FileInputStream(inputFileName);
                this.sourceFormat = configuration.getAttribute("sourceFormat", null);
                this.targetFormat = configuration.getAttribute("targetFormat", null);
                String declaredTypeId = configuration.getAttribute("legoData", null);
                TypeDeclarationType typeDeclaration = model.getTypeDeclarations().getTypeDeclaration(declaredTypeId);
                this.schemaDocument = typeDeclaration.getSchema().getDocument();
                if (this.schemaDocument != null) {
                    sourceDoc = this.performParsing(this.fis, this.sourceFormat, this.schemaDocument, configuration);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(String.valueOf(Modeling_Messages.EXC_IP_FILE_NOT_FOUND) + inputFileName + "'.", e);
            }
            catch (ParsingException e) {
                throw new RuntimeException(String.valueOf(Modeling_Messages.EXC_PB_PR_FILE_CONTENT_OF) + inputFileName + "'.", e);
            }
            catch (Throwable e) {
                throw new RuntimeException(String.valueOf(Modeling_Messages.EXC_PB_PR_FILE_CONTENT_OF) + inputFileName + "'.", e);
            }
            if (configuration.getAttribute("testSerialization", true)) {
                if (configuration.getAttribute("screenOnly", true)) {
                    try {
                        this.performSerializing(sourceDoc, (OutputStream)msgStream, this.schemaDocument, configuration);
                    }
                    catch (SerializationException e) {
                        throw new RuntimeException(Modeling_Messages.EXC_PB_SER_SR_DOC, e);
                    }
                }
                try {
                    msgStream.println(String.valueOf(Modeling_Messages.TXT_WRT_OP_TO) + configuration.getAttribute("targetFilePath", ""));
                    this.performSerializing(sourceDoc, new FileOutputStream(configuration.getAttribute("targetFilePath", "")), this.schemaDocument, configuration);
                    msgStream.println(Modeling_Messages.TXT_DONE);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(Modeling_Messages.EXC_EXPO_FILE_FOUND, e);
                }
                catch (SerializationException e) {
                    throw new RuntimeException(Modeling_Messages.PB_SER_SR_DOC, e);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(Modeling_Messages.PB_SER_SR_DOC, e);
                }
            }
            launchManager.removeLaunch(launch);
        }
    }

    public Document performParsing(FileInputStream fis, String sourceFormat, Object schemaDocument, ILaunchConfiguration launchConfiguration) throws ParsingException {
        IMessageFormat messageFormat = FormatManager.getMessageFormat(sourceFormat, launchConfiguration);
        Document sourceDoc = messageFormat.parse((InputStream)fis, schemaDocument);
        return sourceDoc;
    }

    public void performSerializing(Document document, OutputStream os, Object schemaDocument, ILaunchConfiguration launchConfiguration) throws SerializationException {
        IMessageFormat messageFormat = FormatManager.getMessageFormat(this.targetFormat, launchConfiguration);
        messageFormat.serialize(document, os, schemaDocument);
    }

    public ModelType loadModel(String modelUri) throws Exception {
        WorkflowModelManager modelManager = new WorkflowModelManager();
        modelManager.load(URI.createURI((String)modelUri));
        ModelType model = modelManager.getModel();
        return model;
    }
}

