/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.PrimitivesFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.StructuredTypesFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class MessageRenameDialog
extends Dialog
implements ModifyListener {
    private WorkflowModelEditor wfme;
    private MessageTransformationController controller;
    private List allMessageTypes = new ArrayList();
    private List typeFilters = new ArrayList();
    private AccessPointType messageType;
    private static Text messageNameText;
    private Combo messageCombo;
    private ComboViewer messageComboViewer;
    private Combo dataTypeCombo;
    private ComboViewer dataTypeComboViewer;
    private Label errorLabel;
    private boolean isError = false;
    private Composite structPrimComposite;
    protected ViewerFilter selectedFilter;
    private boolean isSource;
    private static String messageName;

    public MessageRenameDialog(Shell parentShell, MessageTransformationController controller, boolean isSource) {
        super(parentShell);
        this.controller = controller;
        this.isSource = isSource;
        this.allMessageTypes.addAll(controller.getSourceMessageTypes());
        this.allMessageTypes.addAll(controller.getTargetMessageTypes());
        this.typeFilters.add(new StructuredTypesFilter());
        this.typeFilters.add(new PrimitivesFilter());
    }

    protected Control createDialogArea(Composite parent) {
        IEditorPart currentEditor;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
            this.wfme = (WorkflowModelEditor)currentEditor;
        }
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 3;
        Label tagNameLabel = new Label(comp, 16384);
        tagNameLabel.setText(MessageFormat.format(Modeling_Messages.TXT_NAME, this.controller.getNameString()));
        messageNameText = new Text(comp, 2052);
        messageNameText.addModifyListener((ModifyListener)this);
        GridData data = new GridData(768);
        messageNameText.setLayoutData((Object)data);
        this.errorLabel = new Label(comp, 0);
        this.errorLabel.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error.gif").createImage());
        this.errorLabel.setVisible(false);
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        comboData.horizontalSpan = 2;
        Label typeLabel = new Label(comp, 16384);
        typeLabel.setText(Modeling_Messages.TXT_DATETYPE);
        this.dataTypeCombo = new Combo(comp, 128);
        this.dataTypeCombo.setLayoutData((Object)comboData);
        this.dataTypeComboViewer = new ComboViewer(this.dataTypeCombo);
        this.dataTypeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.structPrimComposite = new Composite(comp, 0);
        GridLayout structPrimLayout = new GridLayout();
        structPrimLayout.numColumns = 2;
        GridData structPrimData = new GridData();
        structPrimData.grabExcessHorizontalSpace = true;
        structPrimData.grabExcessVerticalSpace = true;
        structPrimData.verticalAlignment = 4;
        structPrimData.horizontalAlignment = 4;
        structPrimData.horizontalSpan = 2;
        this.structPrimComposite.setLayoutData((Object)structPrimData);
        this.structPrimComposite.setLayout((Layout)structPrimLayout);
        this.messageCombo = new Combo(this.structPrimComposite, 128);
        this.messageCombo.setLayoutData((Object)comboData);
        this.messageComboViewer = new ComboViewer(this.messageCombo);
        this.messageComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.messageComboViewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.wfme));
        parent.getShell().setMinimumSize(300, 150);
        parent.getShell().setText(String.valueOf(Modeling_Messages.TXT_MODIFY) + this.controller.getNameString());
        return comp;
    }

    private void initCombos() {
        this.messageComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    MessageRenameDialog.this.messageType = (AccessPointType)selection.getFirstElement();
                    String text = MessageRenameDialog.this.messageType.getId();
                    int n = 1;
                    while (MessageRenameDialog.this.isAccessPointIdDefined(String.valueOf(text) + n)) {
                        ++n;
                    }
                    text = String.valueOf(text) + n;
                    messageNameText.setText(text);
                    messageNameText.setSelection(0, messageNameText.getText().length());
                }
                MessageRenameDialog.this.buttonEnablement();
            }
        });
        this.dataTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                MessageRenameDialog.this.selectedFilter = (ViewerFilter)selection.getFirstElement();
                MessageRenameDialog.this.messageComboViewer.setFilters(new ViewerFilter[]{MessageRenameDialog.this.selectedFilter});
            }
        });
        this.messageComboViewer.setInput(this.controller.getAvailableMessageTypes());
        this.messageComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    MessageRenameDialog.this.messageType = (AccessPointType)selection.getFirstElement();
                }
            }
        });
        this.messageType = this.isSource ? this.controller.getSelectedSourceField() : this.controller.getSelectedTargetField();
        int typeSelected = 0;
        if (!(this.messageType instanceof StructAccessPointType)) {
            typeSelected = 1;
        }
        messageNameText.setText(this.messageType.getId());
        this.dataTypeComboViewer.setInput((Object)this.typeFilters);
        ArrayList filterSelection = new ArrayList();
        filterSelection.add(this.typeFilters.get(typeSelected));
        this.dataTypeComboViewer.setSelection((ISelection)new StructuredSelection(filterSelection));
        List<AccessPointType> availableMessageTypes = this.controller.getAvailableMessageTypes();
        ArrayList<AccessPointType> dataSelection = new ArrayList<AccessPointType>();
        for (AccessPointType currentType : availableMessageTypes) {
            if (typeSelected == 1) {
                AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)this.messageType, (String)"carnot:engine:type");
                AttributeType currentAttribute = AttributeUtil.getAttribute((IExtensibleElement)currentType, (String)"carnot:engine:type");
                String currentAttributeType = attribute.getType();
                if (!currentAttributeType.equals("ag.carnot.workflow.spi.providers.data.java.Type") || !currentAttribute.getValue().equals(attribute.getValue())) continue;
                dataSelection.add(currentType);
                break;
            }
            String messageTypeType = AttributeUtil.getAttribute((IExtensibleElement)this.messageType, (String)"carnot:engine:dataType").getValue();
            DataTypeType type = currentType.getType();
            if (!type.equals(this.messageType.getType()) || !messageTypeType.equals(currentType.getId())) continue;
            dataSelection.add(currentType);
            break;
        }
        this.messageComboViewer.setSelection((ISelection)new StructuredSelection(dataSelection));
        messageNameText.setSelection(0, messageNameText.getText().length());
    }

    protected void buttonEnablement() {
        String text = messageNameText.getText();
        this.errorLabel.setVisible(this.isError);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!this.isError && !text.equalsIgnoreCase("") && text.indexOf(" ") == -1 && this.messageCombo.getSelectionIndex() != -1);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.initCombos();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.messageType = this.isSource ? this.controller.getSelectedSourceField() : this.controller.getSelectedTargetField();
        messageNameText.setText(this.messageType.getId());
        return control;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            messageName = messageNameText.getText();
        }
        super.buttonPressed(buttonId);
    }

    public void modifyText(ModifyEvent arg0) {
        String text = messageNameText.getText();
        if (this.getMessageTypeByName(text) != null) {
            this.isError = true;
            this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_DOES_ALREADY_EXIST, text));
        } else if (!StringUtils.isValidIdentifier((String)text)) {
            this.isError = true;
            this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
        } else {
            this.isError = false;
            this.errorLabel.setToolTipText(null);
        }
        this.buttonEnablement();
    }

    public AccessPointType getMessageType() {
        return this.messageType;
    }

    public static String getMessageName() {
        return messageName;
    }

    private boolean isAccessPointIdDefined(String id) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private AccessPointType getMessageTypeByName(String name) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(name)) continue;
            return messageType;
        }
        return null;
    }
}

