/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.validation.ExtensionDescriptor;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.IValidationExtensionRegistry;
import org.eclipse.stardust.modeling.validation.util.ExtensionsResolver;

public class ValidatorRegistry {
    private static final IModelValidator[] EMPTY_MODEL_VALIDATORS = new IModelValidator[0];
    private static final IModelElementValidator[] EMPTY_MODEL_ELEMENT_VALIDATORS = new IModelElementValidator[0];
    private static IValidationExtensionRegistry validationExtensionRegistry = ValidatorRegistry.discoveryValidationExtensionRegistry();
    private static ThreadLocal<Map<String, String>> filterSet = new ThreadLocal();

    private static IValidationExtensionRegistry discoveryValidationExtensionRegistry() {
        Iterator<IValidationExtensionRegistry> registries = ServiceLoader.load(IValidationExtensionRegistry.class).iterator();
        return registries.hasNext() ? registries.next() : null;
    }

    public static void setValidationExtensionRegistry(IValidationExtensionRegistry validationExtensionRegistry) {
        ValidatorRegistry.validationExtensionRegistry = validationExtensionRegistry;
    }

    public static void setFilters(Map<String, String> filters) {
        filterSet.set(filters);
    }

    public static Map<String, String> getFilters() {
        Map<String, String> filters = filterSet.get();
        if (filters == null) {
            filters = Collections.emptyMap();
        }
        return filters;
    }

    public static IModelValidator[] getModelValidators() {
        List result = null;
        List<ExtensionDescriptor> extensions = validationExtensionRegistry.getExtensionDescriptorsFor("org.eclipse.stardust.modeling.validation.modelValidator");
        int i = 0;
        while (i < extensions.size()) {
            ExtensionDescriptor extension = extensions.get(i);
            try {
                IModelValidator validator = (IModelValidator)extension.createExecutableExtension();
                if (result == null) {
                    result = CollectionUtils.newList();
                }
                result.add(validator);
            }
            catch (Exception exception) {}
            ++i;
        }
        return result == null ? EMPTY_MODEL_VALIDATORS : result.toArray(new IModelValidator[result.size()]);
    }

    public static IModelElementValidator[] getModelElementValidators(IModelElement element) {
        List result = null;
        List<ExtensionDescriptor> extensions = validationExtensionRegistry.getExtensionDescriptorsFor("org.eclipse.stardust.modeling.validation.modelElementValidator");
        for (ExtensionDescriptor extension : extensions) {
            if (!ExtensionsResolver.isMatchingElement((EObject)element, "targetType", ValidatorRegistry.getFilters(), extension)) continue;
            try {
                IModelElementValidator validator = (IModelElementValidator)extension.createExecutableExtension();
                if (result == null) {
                    result = CollectionUtils.newList();
                }
                result.add(validator);
            }
            catch (Exception exception) {}
        }
        return result == null ? EMPTY_MODEL_ELEMENT_VALIDATORS : result.toArray(new IModelElementValidator[result.size()]);
    }
}

